/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.cde.core;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.MouseEvent;
import org.eclipse.draw2d.MouseListener;
import org.eclipse.draw2d.RoundedRectangle;
import org.eclipse.draw2d.XYLayout;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.gef.editpolicies.AbstractEditPolicy;
import org.eclipse.gef.editpolicies.FlowLayoutEditPolicy;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ve.internal.cde.core.ActionBarActionEditPart;

public class ActionBarGraphicalEditPart
extends AbstractGraphicalEditPart {
    IFigure actionBarFigure = null;
    ActionBarDecorationsFigure decorationsFigure = null;
    List actionBarChildren = null;
    boolean actionBarOpen = false;
    Rectangle dividerGradientArea = null;
    private Rectangle hostBounds = null;
    static final Color ACTIONBAR_BACKGROUND_COLOR = new Color(null, 255, 255, 220);
    static final int ACTIONBAR_CHILD_FIGURE_MARGIN = 5;

    public void activate() {
        super.activate();
        this.getFigure().addMouseListener((MouseListener)new ActionBarMouseListener());
        this.getLayer("Handle Layer").add(this.getFigure());
    }

    public void deactivate() {
        super.deactivate();
        this.getLayer("Handle Layer").remove(this.getFigure());
        if (this.decorationsFigure != null) {
            this.getLayer("Handle Layer").remove((IFigure)this.decorationsFigure);
        }
    }

    public void addActionBarChildren(List actionBarChildren) {
        this.actionBarChildren = actionBarChildren;
    }

    public void show(Rectangle hostBounds, int orientation) {
        this.hostBounds = hostBounds;
        this.actionBarFigure.setLocation(new Point(hostBounds.x + hostBounds.width - 8, hostBounds.y + 1));
        if (this.decorationsFigure == null) {
            this.decorationsFigure = new ActionBarDecorationsFigure();
            this.getLayer("Handle Layer").remove(this.actionBarFigure);
            this.getLayer("Handle Layer").add((IFigure)this.decorationsFigure);
            this.getLayer("Handle Layer").add(this.actionBarFigure);
        }
        this.decorationsFigure.setHostBounds(hostBounds.getCopy());
        this.getLayer("Handle Layer").remove((IFigure)this.decorationsFigure);
        this.getLayer("Handle Layer").remove(this.actionBarFigure);
        this.getLayer("Handle Layer").add((IFigure)this.decorationsFigure);
        this.getLayer("Handle Layer").add(this.actionBarFigure);
        this.decorationsFigure.setVisible(true);
        this.actionBarFigure.setVisible(true);
    }

    public void hide() {
        this.actionBarOpen = false;
        this.actionBarFigure.setVisible(false);
        this.decorationsFigure.setVisible(false);
    }

    protected IFigure createFigure() {
        this.actionBarFigure = new RoundedRectangle(){
            PointList actionBarStub = null;
            PointList rightArrow = null;
            PointList leftArrow = null;
            PointList divider = null;

            public void setBounds(Rectangle rect) {
                super.setBounds(rect);
                this.actionBarStub = new PointList(6);
                this.actionBarStub.addPoint(this.bounds.x + 5, this.bounds.y + 1);
                this.actionBarStub.addPoint(this.bounds.x + this.bounds.width - 4, this.bounds.y + 1);
                this.actionBarStub.addPoint(this.bounds.x + this.bounds.width - 1, this.bounds.y + 4);
                this.actionBarStub.addPoint(this.bounds.x + this.bounds.width - 1, this.bounds.y + this.bounds.height - 4);
                this.actionBarStub.addPoint(this.bounds.x + this.bounds.width - 4, this.bounds.y + this.bounds.height - 1);
                this.actionBarStub.addPoint(this.bounds.x + 5, this.bounds.y + this.bounds.height - 1);
                this.rightArrow = new PointList(3);
                this.rightArrow.addPoint(this.bounds.x + this.bounds.width - 7, this.bounds.y + this.bounds.height / 2 - 3);
                this.rightArrow.addPoint(this.bounds.x + this.bounds.width - 4, this.bounds.y + this.bounds.height / 2);
                this.rightArrow.addPoint(this.bounds.x + this.bounds.width - 7, this.bounds.y + this.bounds.height / 2 + 3);
                this.leftArrow = new PointList(3);
                this.leftArrow.addPoint(this.bounds.x + this.bounds.width - 5, this.bounds.y + this.bounds.height / 2 - 3);
                this.leftArrow.addPoint(this.bounds.x + this.bounds.width - 8, this.bounds.y + this.bounds.height / 2);
                this.leftArrow.addPoint(this.bounds.x + this.bounds.width - 5, this.bounds.y + this.bounds.height / 2 + 3);
                this.divider = new PointList(4);
                this.divider.addPoint(this.bounds.x + this.bounds.width - 10, this.bounds.y + 1);
                this.divider.addPoint(this.bounds.x + this.bounds.width - 12, this.bounds.y + 3);
                this.divider.addPoint(this.bounds.x + this.bounds.width - 12, this.bounds.y + this.bounds.height - 3);
                this.divider.addPoint(this.bounds.x + this.bounds.width - 10, this.bounds.y + this.bounds.height - 1);
                ActionBarGraphicalEditPart.this.dividerGradientArea = this.bounds.getCopy();
                ActionBarGraphicalEditPart.this.dividerGradientArea.x = this.bounds.x + this.bounds.width - 12;
                ActionBarGraphicalEditPart.this.dividerGradientArea.width = this.bounds.x + this.bounds.width - ActionBarGraphicalEditPart.this.dividerGradientArea.x;
                ActionBarGraphicalEditPart.this.dividerGradientArea.expand(-1, -1);
            }

            public void paintFigure(Graphics graphics) {
                if (ActionBarGraphicalEditPart.this.actionBarOpen) {
                    super.paintFigure(graphics);
                    graphics.setForegroundColor(ColorConstants.white);
                    graphics.setBackgroundColor(Display.getCurrent().getSystemColor(35));
                    graphics.fillGradient(ActionBarGraphicalEditPart.this.dividerGradientArea, false);
                    graphics.setLineWidth(2);
                    graphics.setForegroundColor(ColorConstants.black);
                    graphics.drawPolyline(this.leftArrow);
                    graphics.setForegroundColor(ColorConstants.gray);
                    graphics.drawPolyline(this.divider);
                    graphics.setLineWidth(1);
                    graphics.setForegroundColor(ColorConstants.black);
                    this.outlineShape(graphics);
                } else {
                    graphics.setBackgroundColor(ColorConstants.white);
                    graphics.fillPolygon(this.actionBarStub);
                    graphics.setForegroundColor(ColorConstants.white);
                    graphics.setBackgroundColor(Display.getCurrent().getSystemColor(35));
                    graphics.fillGradient(ActionBarGraphicalEditPart.this.dividerGradientArea, false);
                    graphics.setLineWidth(2);
                    graphics.setForegroundColor(ColorConstants.orange);
                    graphics.drawPolyline(this.actionBarStub);
                    graphics.setForegroundColor(ColorConstants.black);
                    graphics.drawPolyline(this.rightArrow);
                }
            }

            protected void fillShape(Graphics graphics) {
                graphics.setForegroundColor(ColorConstants.white);
                graphics.setBackgroundColor(ColorConstants.tooltipBackground);
                Rectangle rect = this.getBounds().getCopy().expand(-1, -1);
                rect.width -= ActionBarGraphicalEditPart.this.dividerGradientArea.width;
                graphics.fillGradient(rect, false);
            }
        };
        XYLayout xylayout = new XYLayout();
        this.actionBarFigure.setLayoutManager((LayoutManager)xylayout);
        this.actionBarFigure.setVisible(false);
        return this.actionBarFigure;
    }

    protected void createEditPolicies() {
        this.installEditPolicy("LayoutEditPolicy", (EditPolicy)new FlowLayoutEditPolicy(){

            protected void showLayoutTargetFeedback(Request request) {
            }

            protected boolean isHorizontal() {
                return true;
            }

            protected Command createAddCommand(EditPart child, EditPart after) {
                return null;
            }

            protected Command createMoveChildCommand(EditPart child, EditPart after) {
                return null;
            }

            protected Command getCreateCommand(CreateRequest request) {
                return null;
            }

            protected Command getDeleteDependantCommand(Request request) {
                return null;
            }

            protected EditPolicy createChildEditPolicy(EditPart child) {
                if (child instanceof ActionBarActionEditPart) {
                    return new AbstractEditPolicy(this){
                        final /* synthetic */ 2 this$1;
                        {
                            this.this$1 = var1_1;
                        }
                    };
                }
                return super.createChildEditPolicy(child);
            }
        });
    }

    protected void refreshChildren() {
        super.refreshChildren();
        this.refreshFigures();
    }

    protected void refreshFigures() {
        Iterator iter = this.actionBarFigure.getChildren().iterator();
        while (iter.hasNext()) {
            IFigure child = (IFigure)iter.next();
            if (child.isVisible() == this.actionBarOpen) continue;
            child.setVisible(this.actionBarOpen);
        }
        this.setChildrenConstraints();
        this.calculateFigureSize();
    }

    private void calculateFigureSize() {
        List children = this.getFigure().getChildren();
        if (children.isEmpty()) {
            return;
        }
        int abWidth = 5;
        int abHeight = 0;
        int i = 0;
        while (i < children.size()) {
            Dimension size = ((IFigure)children.get(i)).getPreferredSize();
            abWidth += size.width + 5;
            if (size.height > abHeight) {
                abHeight = size.height;
            }
            ++i;
        }
        abWidth = this.actionBarOpen ? (abWidth += 30) : 15;
        this.getFigure().setSize(abWidth, abHeight + 10);
        if (this.decorationsFigure != null && this.hostBounds != null) {
            this.decorationsFigure.setHostBounds(this.hostBounds.getCopy());
        }
    }

    private void setChildrenConstraints() {
        List children = this.getFigure().getChildren();
        LayoutManager lm = this.getFigure().getLayoutManager();
        if (children.isEmpty() || lm == null) {
            return;
        }
        int abWidth = 5;
        int i = 0;
        while (i < children.size()) {
            IFigure childFigure = (IFigure)children.get(i);
            if (lm.getConstraint(childFigure) == null) {
                this.getFigure().setConstraint(childFigure, (Object)new Rectangle(abWidth, 5, childFigure.getPreferredSize().width, childFigure.getPreferredSize().height));
            }
            abWidth += childFigure.getPreferredSize().width + 5;
            ++i;
        }
    }

    protected EditPart createChild(Object model) {
        return (EditPart)model;
    }

    protected List getModelChildren() {
        return this.actionBarChildren == null ? Collections.EMPTY_LIST : this.actionBarChildren;
    }

    private class ActionBarMouseListener
    extends MouseListener.Stub {
        ActionBarMouseListener() {
        }

        public void mousePressed(MouseEvent me) {
            if (me.getSource() == ActionBarGraphicalEditPart.this.actionBarFigure && ActionBarGraphicalEditPart.this.dividerGradientArea != null && ActionBarGraphicalEditPart.this.dividerGradientArea.contains(me.getLocation())) {
                ActionBarGraphicalEditPart.this.actionBarOpen = !ActionBarGraphicalEditPart.this.actionBarOpen;
                ActionBarGraphicalEditPart.this.refreshFigures();
            }
        }
    }

    private class ActionBarDecorationsFigure
    extends Figure {
        PointList hostBorderPoints = null;
        private Rectangle hostBounds;

        ActionBarDecorationsFigure() {
        }

        public void paint(Graphics graphics) {
            if (this.hostBorderPoints != null) {
                graphics.setForegroundColor(ColorConstants.orange);
                graphics.setLineWidth(2);
                graphics.drawPolyline(this.hostBorderPoints);
            }
            if (ActionBarGraphicalEditPart.this.actionBarOpen) {
                graphics.setBackgroundColor(ColorConstants.darkGray);
                try {
                    graphics.setAlpha(110);
                }
                catch (SWTException sWTException) {}
                Rectangle shadowRect = ActionBarGraphicalEditPart.this.actionBarFigure.getBounds().getCopy().translate(13, 10);
                graphics.fillRoundRectangle(shadowRect, 8, 8);
            }
        }

        public void setHostBounds(Rectangle bounds) {
            this.hostBounds = bounds;
            Rectangle afBounds = ActionBarGraphicalEditPart.this.actionBarFigure.getBounds().getCopy();
            this.hostBorderPoints = new PointList(5);
            this.hostBorderPoints.addPoint(this.hostBounds.x + this.hostBounds.width - 2, this.hostBounds.y + 2);
            this.hostBorderPoints.addPoint(this.hostBounds.x + 2, this.hostBounds.y + 2);
            this.hostBorderPoints.addPoint(this.hostBounds.x + 2, this.hostBounds.y + this.hostBounds.height - 2);
            this.hostBorderPoints.addPoint(this.hostBounds.x + this.hostBounds.width - 2, this.hostBounds.y + this.hostBounds.height - 2);
            this.hostBorderPoints.addPoint(this.hostBounds.x + this.hostBounds.width - 2, this.hostBounds.y + afBounds.height);
            this.setBounds(this.hostBounds.getCopy().union(afBounds.translate(13, 10)));
        }

        public boolean isOpaque() {
            return false;
        }

        public boolean containsPoint(int x, int y) {
            return ActionBarGraphicalEditPart.this.actionBarFigure != null && ActionBarGraphicalEditPart.this.actionBarFigure.getBounds().contains(x, y);
        }
    }
}

