/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.cde.core;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.draw2d.ActionEvent;
import org.eclipse.draw2d.ActionListener;
import org.eclipse.draw2d.Cursors;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.MouseEvent;
import org.eclipse.draw2d.MouseListener;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ve.internal.cde.core.CDEMessages;
import org.eclipse.ve.internal.cde.core.CDEPlugin;

public abstract class ActionBarActionEditPart
extends AbstractGraphicalEditPart {
    static final Image DEFAULT_IMAGE = CDEPlugin.getImageFromPlugin((Plugin)CDEPlugin.getPlugin(), "images/action_plus.gif");
    protected String fToolTip;
    protected Image fIcon = DEFAULT_IMAGE;
    protected List fActionListeners = null;

    public ActionBarActionEditPart() {
    }

    public ActionBarActionEditPart(String tip) {
        this.fToolTip = tip;
    }

    public ActionBarActionEditPart(Image icon) {
        this.fIcon = icon;
    }

    public ActionBarActionEditPart(Image icon, String toolTip) {
        this.fIcon = icon;
        this.fToolTip = toolTip;
    }

    public void addActionListener(ActionListener listener) {
        if (this.fActionListeners == null) {
            this.fActionListeners = new ArrayList();
        }
        if (this.fActionListeners.indexOf(listener) == -1) {
            this.fActionListeners.add(listener);
        }
    }

    public void removeActionListener(ActionListener listener) {
        if (this.fActionListeners != null && !this.fActionListeners.isEmpty() && this.fActionListeners.indexOf(listener) != -1) {
            this.fActionListeners.remove(listener);
        }
    }

    protected IFigure createFigure() {
        Label fig = new Label(this.fIcon);
        if (this.fToolTip != null) {
            fig.setToolTip((IFigure)new Label(this.fToolTip));
        }
        fig.setCursor(Cursors.HAND);
        fig.addMouseListener((MouseListener)new MouseListener.Stub((IFigure)fig){
            private final /* synthetic */ IFigure val$fig;
            {
                this.val$fig = iFigure;
            }

            public void mousePressed(MouseEvent me) {
                if (me.getSource() == this.val$fig) {
                    ActionBarActionEditPart.this.run();
                    ActionBarActionEditPart.this.handleActionPerformed(me.getSource());
                }
            }
        });
        return fig;
    }

    private void handleActionPerformed(Object source) {
        Iterator iter = this.fActionListeners.iterator();
        while (iter.hasNext()) {
            ((ActionListener)iter.next()).actionPerformed(new ActionEvent(source, CDEMessages.ActionBarActionEditPart_Action_Performed_Msg));
        }
    }

    protected void createEditPolicies() {
    }

    public abstract void run();

    public void setIcon(Image icon) {
        this.fIcon = icon;
    }

    public void setToolTip(String toolTip) {
        this.fToolTip = toolTip;
    }
}

