/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.cde.commands;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.ve.internal.cde.commands.AbstractAttributeCommand;
import org.eclipse.ve.internal.cde.core.CDEPlugin;

public class CancelAttributeSettingCommand
extends AbstractAttributeCommand {
    protected Object oldValue;
    protected boolean oldSet;
    protected int[] oldIndexes;

    public CancelAttributeSettingCommand(String name) {
        super(name);
    }

    public CancelAttributeSettingCommand() {
    }

    public boolean prepare() {
        return super.prepare() && (!this.feature.isMany() || !this.getAttributeSettingValues().isEmpty());
    }

    public void execute() {
        EObject target = this.getTarget();
        if (!this.feature.isMany()) {
            this.oldSet = target.eIsSet(this.feature);
            if (this.oldSet) {
                this.oldValue = target.eGet(this.feature);
            }
            try {
                target.eUnset(this.feature);
            }
            catch (RuntimeException e) {
                try {
                    this.undo();
                }
                catch (RuntimeException e2) {
                    CDEPlugin.getPlugin().getLog().log((IStatus)new Status(2, CDEPlugin.getPlugin().getBundle().getSymbolicName(), 0, "", (Throwable)e2));
                }
                throw e;
            }
        }
        List values = this.getAttributeSettingValues();
        ArrayList<Object> orderedValues = new ArrayList<Object>(values.size());
        this.oldIndexes = new int[values.size()];
        int oldI = -1;
        ListIterator itr = ((List)target.eGet(this.feature)).listIterator();
        Object v = null;
        try {
            while (!values.isEmpty() && itr.hasNext()) {
                v = itr.next();
                if (!values.remove(v)) continue;
                this.oldIndexes[++oldI] = itr.previousIndex();
                orderedValues.add(v);
                itr.remove();
            }
            this.setAttributeSettingValue(orderedValues);
        }
        catch (RuntimeException e) {
            this.setAttributeSettingValue(orderedValues);
            try {
                this.undo();
                values.addAll(orderedValues);
                this.setAttributeSettingValue(values);
            }
            catch (RuntimeException e2) {
                CDEPlugin.getPlugin().getLog().log((IStatus)new Status(2, CDEPlugin.getPlugin().getBundle().getSymbolicName(), 0, "", (Throwable)e2));
            }
            throw e;
        }
    }

    public void undo() {
        EObject target = this.getTarget();
        if (!this.feature.isMany()) {
            if (this.oldSet) {
                try {
                    target.eSet(this.feature, this.oldValue);
                }
                catch (RuntimeException e) {
                    target.eUnset(this.feature);
                    throw e;
                }
            } else {
                target.eUnset(this.feature);
            }
        } else {
            if (this.getAttributeSettingValues().isEmpty()) {
                return;
            }
            int oldI = this.getAttributeSettingValues().size();
            ListIterator oldItr = this.getAttributeSettingValues().listIterator(oldI);
            int nextI = this.oldIndexes[--oldI];
            ListIterator itr = ((List)target.eGet(this.feature)).listIterator(nextI);
            while (true) {
                if (nextI == itr.nextIndex()) {
                    itr.add(oldItr.previous());
                    if (--oldI < 0) break;
                    nextI = this.oldIndexes[oldI];
                }
                itr.previous();
            }
        }
        this.oldIndexes = null;
        this.oldValue = null;
    }
}

