/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.emf.event.impl;

import com.ibm.etools.emf.event.Add;
import com.ibm.etools.emf.event.AddMany;
import com.ibm.etools.emf.event.Change;
import com.ibm.etools.emf.event.ChangeUtil;
import com.ibm.etools.emf.event.Event;
import com.ibm.etools.emf.event.EventUtil;
import com.ibm.etools.emf.event.FeatureKind;
import com.ibm.etools.emf.event.Move;
import com.ibm.etools.emf.event.Remove;
import com.ibm.etools.emf.event.RemoveMany;
import com.ibm.etools.emf.event.Set;
import com.ibm.etools.emf.event.Unset;
import com.ibm.etools.emf.event.impl.EventAdapter;
import com.ibm.etools.emf.event.impl.EventReaderHelper;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;

public class EventUtilImpl
implements EventUtil {
    EventReaderHelper helper = null;

    protected EventUtilImpl(Notifier topNotifier, ResourceSet defaultResourceSet) {
        this.helper = new EventReaderHelper(topNotifier, defaultResourceSet);
    }

    protected EventUtilImpl(EventReaderHelper helper) {
        this.helper = helper;
    }

    public void activateEventAdapter(List eventsList) {
        EventAdapter adapter = this.helper.getEventAdapter();
        if (adapter != null) {
            adapter.setIsActive(true);
            if (adapter.getEventsList() != eventsList) {
                adapter.setEventsList(eventsList);
            }
        } else {
            this.helper.attachEventAdapter(eventsList);
        }
    }

    public void deactivateEventAdapter() {
        EventAdapter adapter = this.helper.getEventAdapter();
        if (adapter != null) {
            adapter.setIsActive(false);
        }
    }

    public EventUtil makeCopy() {
        return this.makeCopy(new EcoreUtil.Copier());
    }

    public EventUtil makeCopy(EcoreUtil.Copier copyMap) {
        EventReaderHelper copyHelper = this.helper.makeCopy(copyMap);
        EventUtilImpl copyUtil = new EventUtilImpl(copyHelper);
        return copyUtil;
    }

    public EventUtil doForwardEvents(List eventsList) {
        int i = 0;
        int size = eventsList.size();
        while (i < size) {
            Object o = eventsList.get(i);
            if (o instanceof Event) {
                Event e = (Event)o;
                this.replayEvent(e);
            }
            ++i;
        }
        return this;
    }

    public EventUtil doBackwardEvents(List eventsList) {
        int i = eventsList.size() - 1;
        while (i >= 0) {
            Object o = eventsList.get(i);
            if (o instanceof Event) {
                Event e = (Event)o;
                this.undoEvent(e);
            }
            --i;
        }
        return this;
    }

    public Change[] getBackwardChanges(List eventsList) {
        if (eventsList == null) {
            return new Change[0];
        }
        EcoreUtil.Copier newToOldMap = new EcoreUtil.Copier();
        EventReaderHelper copyHelper = this.helper.makeCopy(newToOldMap);
        EventUtilImpl copyUtil = new EventUtilImpl(copyHelper);
        copyUtil.doBackwardEvents(eventsList);
        Map oldToNewMap = ChangeUtil.eINSTANCE.createInverseMap((Map)newToOldMap);
        return ChangeUtil.eINSTANCE.getChanges(copyHelper.getTopNotifier(), this.helper.getTopNotifier(), oldToNewMap);
    }

    public Iterator getBackwardIterator(List eventsList) {
        if (eventsList == null) {
            return Collections.EMPTY_LIST.iterator();
        }
        return new BackwardEventIterator(eventsList);
    }

    public Iterator getForwardIterator(List eventsList) {
        if (eventsList == null) {
            return Collections.EMPTY_LIST.iterator();
        }
        return new ForwardEventIterator(eventsList);
    }

    public Change[] getForwardChanges(List eventsList) {
        if (eventsList == null) {
            return new Change[0];
        }
        EcoreUtil.Copier oldToNewMap = new EcoreUtil.Copier();
        EventReaderHelper copyHelper = this.helper.makeCopy(oldToNewMap);
        EventUtilImpl copyUtil = new EventUtilImpl(copyHelper);
        copyUtil.doForwardEvents(eventsList);
        return ChangeUtil.eINSTANCE.getChanges(this.helper.getTopNotifier(), copyHelper.getTopNotifier(), (Map)oldToNewMap);
    }

    protected void replayEvent(Event e) {
        this.helper.createObjectsFromDescriptorList(e, e.getAddedEObjects(), e.getAddedDescriptors());
        e.setNotifier(this.helper.getNotifier(e));
        e.setFeature(this.helper.getFeature(e));
        switch (e.getEventKind().getValue()) {
            case 0: {
                this.replaySet((Set)e);
                break;
            }
            case 1: {
                this.replayUnset((Unset)e);
                break;
            }
            case 2: {
                this.replayAdd((Add)e);
                break;
            }
            case 3: {
                this.replayRemove((Remove)e);
                break;
            }
            case 4: {
                this.replayAddMany((AddMany)e);
                break;
            }
            case 5: {
                this.replayRemoveMany((RemoveMany)e);
                break;
            }
            case 6: {
                this.replayMove((Move)e);
            }
        }
        this.helper.rememberEventIdsInDescriptorList(e, e.getRemovedEObjects(), e.getRemovedDescriptors());
    }

    protected void replaySet(Set e) {
        EObject eObj = (EObject)this.helper.getNotifier(e);
        Object oldVal = eObj.eGet(this.helper.getFeature(e));
        if (this.helper.getFeatureKind(e) == FeatureKind.REFERENCE_LITERAL) {
            this.helper.rememberEventId((EObject)oldVal, e.getOldLiteral());
        }
        if (e.isSetOldLiteral()) {
            e.setOldObject(oldVal);
        } else {
            e.unsetOldObject();
        }
        e.setNewObject(this.helper.createFromString(e, e.getNewLiteral()));
        if (e.getNewObject() == null && e.getAddedEObjects().size() == 1) {
            EObject template = (EObject)e.getAddedEObjects().get(0);
            e.setNewObject(EcoreUtil.copy((EObject)template));
        }
        this.helper.setValue(e, e.getNewObject());
    }

    protected void replayUnset(Unset e) {
        EObject eObj = (EObject)this.helper.getNotifier(e);
        Object oldVal = eObj.eGet(this.helper.getFeature(e));
        if (this.helper.getFeatureKind(e) == FeatureKind.REFERENCE_LITERAL) {
            this.helper.rememberEventId((EObject)oldVal, e.getLiteral());
        }
        e.setObject(oldVal);
        this.helper.unsetValue(e);
    }

    protected void replayAdd(Add e) {
        if (e.getLiteral() != null) {
            e.setObject(this.helper.createFromString(e, e.getLiteral()));
        }
        if (e.getObject() == null && e.getAddedEObjects().size() == 1) {
            EObject template = (EObject)e.getAddedEObjects().get(0);
            e.setObject(EcoreUtil.copy((EObject)template));
        }
        this.helper.setValue(e, e.getObject(), e.getPosition());
    }

    protected void replayRemove(Remove e) {
        EList contents = this.helper.getNotifierContents(e);
        if (this.helper.getFeatureKind(e) == FeatureKind.REFERENCE_LITERAL) {
            Object obj = this.helper.getEObjectFromString(e.getLiteral());
            if (obj == null) {
                obj = contents.get(e.getPosition());
            }
            e.setObject(obj);
            this.helper.rememberEventId((EObject)obj, e.getLiteral());
            contents.remove(e.getObject());
        } else {
            Object obj = contents.remove(e.getPosition());
            e.setObject(obj);
        }
    }

    protected void replayAddMany(AddMany e) {
        e.getObjects().clear();
        EList list = this.helper.getNotifierContents(e);
        int i = 0;
        int size = e.getLiterals().size();
        while (i < size) {
            String val = (String)e.getLiterals().get(i);
            e.getObjects().add(this.helper.createFromString(e, val));
            ++i;
        }
        if (e.getObjects().size() == 0) {
            i = 0;
            size = e.getAddedEObjects().size();
            while (i < size) {
                EObject template = (EObject)e.getAddedEObjects().get(i);
                e.getObjects().add((Object)EcoreUtil.copy((EObject)template));
                ++i;
            }
        }
        this.helper.addAll(e, e.getObjects(), e.getPositions());
    }

    protected void replayRemoveMany(RemoveMany e) {
        int i;
        e.getObjects().clear();
        EList list = this.helper.getNotifierContents(e);
        if (this.helper.getFeatureKind(e) == FeatureKind.REFERENCE_LITERAL) {
            this.helper.rememberAllEventIds(list, e.getPositions(), e.getLiterals());
        }
        if (e.getPositions().size() > 0) {
            i = 0;
            int size = e.getPositions().size();
            while (i < size) {
                Object oldVal = null;
                if (e.getLiterals().size() > 0) {
                    oldVal = this.helper.getEObjectFromString((String)e.getLiterals().get(i));
                }
                if (oldVal == null) {
                    int pos = (Integer)e.getPositions().get(i);
                    oldVal = list.get(pos);
                }
                e.getObjects().add(oldVal);
                ++i;
            }
        } else {
            i = 0;
            int size = list.size();
            while (i < size) {
                e.getObjects().add(list.get(i));
                ++i;
            }
        }
        EList contents = this.helper.getNotifierContents(e);
        this.helper.removeAll(contents, e.getPositions(), e.getLiterals());
    }

    protected void replayMove(Move e) {
        EList contents = this.helper.getNotifierContents(e);
        contents.move(e.getNewPosition(), e.getOldPosition());
    }

    protected void undoEvent(Event e) {
        this.helper.createObjectsFromDescriptorList(e, e.getRemovedEObjects(), e.getRemovedDescriptors());
        e.setNotifier(this.helper.getNotifier(e));
        e.setFeature(this.helper.getFeature(e));
        switch (e.getEventKind().getValue()) {
            case 0: {
                this.undoSet((Set)e);
                break;
            }
            case 1: {
                this.undoUnset((Unset)e);
                break;
            }
            case 2: {
                this.undoAdd((Add)e);
                break;
            }
            case 3: {
                this.undoRemove((Remove)e);
                break;
            }
            case 4: {
                this.undoAddMany((AddMany)e);
                break;
            }
            case 5: {
                this.undoRemoveMany((RemoveMany)e);
                break;
            }
            case 6: {
                this.undoMove((Move)e);
            }
        }
        this.helper.rememberEventIdsInDescriptorList(e, e.getAddedEObjects(), e.getAddedDescriptors());
    }

    protected void undoSet(Set e) {
        EObject eObj = (EObject)this.helper.getNotifier(e);
        Object newVal = eObj.eGet(this.helper.getFeature(e));
        if (this.helper.getFeatureKind(e) == FeatureKind.REFERENCE_LITERAL) {
            this.helper.rememberEventId((EObject)newVal, e.getNewLiteral());
        }
        e.setNewObject(newVal);
        if (e.isSetOldLiteral()) {
            e.setOldObject(this.helper.createFromString(e, e.getOldLiteral()));
            if (e.getOldObject() == null && e.getRemovedEObjects().size() == 1) {
                EObject template = (EObject)e.getRemovedEObjects().get(0);
                e.setOldObject(EcoreUtil.copy((EObject)template));
            }
        } else {
            e.unsetOldObject();
        }
        if (e.isSetOldObject()) {
            this.helper.setValue(e, e.getOldObject());
        } else {
            this.helper.unsetValue(e);
        }
    }

    protected void undoUnset(Unset e) {
        e.setObject(this.helper.createFromString(e, e.getLiteral()));
        this.helper.setValue(e, e.getObject());
    }

    protected void undoAdd(Add e) {
        EList contents = this.helper.getNotifierContents(e);
        if (this.helper.getFeatureKind(e) == FeatureKind.REFERENCE_LITERAL) {
            Object obj = this.helper.getEObjectFromString(e.getLiteral());
            if (obj == null) {
                obj = contents.get(e.getPosition());
            }
            e.setObject(obj);
            this.helper.rememberEventId((EObject)obj, e.getLiteral());
            contents.remove(e.getObject());
        } else {
            Object obj = contents.remove(e.getPosition());
            e.setObject(obj);
        }
    }

    protected void undoRemove(Remove e) {
        e.setObject(this.helper.createFromString(e, e.getLiteral()));
        if (e.getObject() == null && e.getRemovedEObjects().size() == 1) {
            EObject template = (EObject)e.getRemovedEObjects().get(0);
            e.setObject(EcoreUtil.copy((EObject)template));
        }
        this.helper.setValue(e, e.getObject(), e.getPosition());
    }

    protected void undoAddMany(AddMany e) {
        int i;
        e.getObjects().clear();
        EList list = this.helper.getNotifierContents(e);
        if (this.helper.getFeatureKind(e) == FeatureKind.REFERENCE_LITERAL) {
            this.helper.rememberAllEventIds(list, e.getPositions(), e.getLiterals());
        }
        if (e.getPositions().size() > 0) {
            i = 0;
            int size = e.getPositions().size();
            while (i < size) {
                Integer pos = (Integer)e.getPositions().get(i);
                e.getObjects().add(list.get(pos.intValue()));
                ++i;
            }
        } else {
            i = 0;
            int size = list.size();
            while (i < size) {
                e.getObjects().add(list.get(i));
                ++i;
            }
        }
        EList contents = this.helper.getNotifierContents(e);
        this.helper.removeAll(contents, e.getPositions(), e.getLiterals());
    }

    protected void undoRemoveMany(RemoveMany e) {
        e.getObjects().clear();
        EList list = this.helper.getNotifierContents(e);
        int i = 0;
        int size = e.getLiterals().size();
        while (i < size) {
            String val = (String)e.getLiterals().get(i);
            e.getObjects().add(this.helper.createFromString(e, val));
            ++i;
        }
        this.helper.addAll(e, e.getObjects(), e.getPositions());
    }

    protected void undoMove(Move e) {
        EList contents = this.helper.getNotifierContents(e);
        contents.move(e.getOldPosition(), e.getNewPosition());
    }

    protected class ForwardEventIterator
    implements Iterator {
        Iterator i = null;

        protected ForwardEventIterator(List eventsList) {
            this.i = eventsList.iterator();
        }

        public boolean hasNext() {
            return this.i.hasNext();
        }

        public Object next() {
            Event e = (Event)this.i.next();
            EventUtilImpl.this.replayEvent(e);
            return e;
        }

        public void remove() {
            this.i.remove();
        }
    }

    protected class BackwardEventIterator
    implements Iterator {
        int position = -1;
        List eventsList = null;

        protected BackwardEventIterator(List eventsList) {
            this.eventsList = eventsList;
            this.position = eventsList.size() - 1;
        }

        public boolean hasNext() {
            return this.position > -1;
        }

        public Object next() {
            Event e = (Event)this.eventsList.get(this.position--);
            EventUtilImpl.this.undoEvent(e);
            return e;
        }

        public void remove() {
            this.eventsList.remove(this.position);
        }
    }
}

