/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.eclipse.launch.core.refactoring;

import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jdt.internal.launching.LaunchingPlugin;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jdt.launching.IRuntimeClasspathEntry;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.hibernate.eclipse.console.HibernateConsolePlugin;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HibernateRefactoringUtil {
    private static final String ERROR_MESS = "Error during refactoring";
    private static String[] pathKeys = new String[]{"org.hibernate.eclipse.launch.CFG_XML_FILE", "org.hibernate.eclipse.launch.PROPERTY_FILE", "org.hibernate.tools.templatepath", "org.hibernate.tools.outputdir", "org.hibernate.tools.revengfile"};
    private static String[] pathListKeys = new String[]{"org.hibernate.eclipse.launch.FILE_MAPPINGS"};

    public static boolean isConfigurationAffected(ILaunchConfiguration config, IPath oldPath) throws CoreException {
        return HibernateRefactoringUtil.isAttributesAffected(config, oldPath) || HibernateRefactoringUtil.isClassPathAffected(config, oldPath);
    }

    private static boolean isAttributesAffected(ILaunchConfiguration config, IPath oldPath) throws CoreException {
        String attrib2 = null;
        int i = 0;
        while (i < pathKeys.length) {
            attrib2 = config.getAttribute(pathKeys[i], null);
            if (HibernateRefactoringUtil.isAttributeChanged(attrib2, oldPath)) {
                return true;
            }
            ++i;
        }
        i = 0;
        while (i < pathListKeys.length) {
            List list = config.getAttribute(pathListKeys[i], Collections.EMPTY_LIST);
            ArrayList<String> newMappings = new ArrayList<String>();
            for (String attrib2 : list) {
                if (HibernateRefactoringUtil.isAttributeChanged(attrib2, oldPath)) {
                    return true;
                }
                newMappings.add(attrib2);
            }
            ++i;
        }
        return false;
    }

    private static boolean isClassPathAffected(ILaunchConfiguration config, IPath oldPath) throws CoreException {
        try {
            IRuntimeClasspathEntry[] entries = JavaRuntime.computeUnresolvedRuntimeClasspath((ILaunchConfiguration)config);
            return HibernateRefactoringUtil.isRuntimeClassPathEntriesAffected(entries, oldPath);
        }
        catch (CoreException e) {
            HibernateConsolePlugin.getDefault().log(e);
            return false;
        }
    }

    public static boolean isRuntimeClassPathEntriesAffected(IRuntimeClasspathEntry[] entries, IPath oldPath) {
        String attrib = null;
        String projName = null;
        int i = 0;
        while (i < entries.length) {
            IRuntimeClasspathEntry entry = entries[i];
            attrib = entry.getPath() == null ? null : entry.getPath().toString();
            String string = projName = entry.getJavaProject() == null ? null : entry.getJavaProject().getElementName();
            if (HibernateRefactoringUtil.isAttributeChanged(attrib, oldPath) || HibernateRefactoringUtil.isAttributeChanged(projName, oldPath)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean isAttributeChanged(String attrib, IPath path) {
        if (attrib == null || path == null) {
            return false;
        }
        return path.isPrefixOf((IPath)new Path(attrib));
    }

    public static ILaunchConfiguration updateLaunchConfig(ILaunchConfiguration config, IPath oldPath, IPath newPath) throws CoreException {
        ILaunchConfigurationWorkingCopy wc = config.getWorkingCopy();
        HibernateRefactoringUtil.updateAttributes(oldPath, newPath, wc);
        try {
            IRuntimeClasspathEntry[] entries = JavaRuntime.computeUnresolvedRuntimeClasspath((ILaunchConfiguration)config);
            List oldMementos = config.getAttribute(IJavaLaunchConfigurationConstants.ATTR_CLASSPATH, Collections.EMPTY_LIST);
            ArrayList<String> newMementos = new ArrayList<String>();
            boolean isChanged = HibernateRefactoringUtil.updateClasspathEntries(entries, oldMementos, newMementos, oldPath, newPath);
            if (isChanged) {
                wc.setAttribute(IJavaLaunchConfigurationConstants.ATTR_CLASSPATH, newMementos);
            }
        }
        catch (CoreException e) {
            HibernateConsolePlugin.getDefault().log(e);
        }
        if (wc.isDirty()) {
            return wc.doSave();
        }
        return config;
    }

    public static boolean updateClasspathEntries(IRuntimeClasspathEntry[] entries, List<String> oldMementos, List<String> newMementos, IPath oldPath, IPath newPath) throws CoreException {
        Assert.isNotNull(newMementos);
        Assert.isNotNull((Object)(entries.length == oldMementos.size() ? 1 : 0));
        boolean isChanged = false;
        int i = 0;
        while (i < entries.length) {
            String memento;
            String projName;
            IRuntimeClasspathEntry entry = entries[i];
            String attrib = entry.getPath() == null ? null : entry.getPath().toString();
            String string = projName = entry.getJavaProject() == null ? null : entry.getJavaProject().getElementName();
            if (HibernateRefactoringUtil.isAttributeChanged(attrib, oldPath)) {
                isChanged = true;
                memento = HibernateRefactoringUtil.getUpdatedMemento(oldMementos.get(i), (IPath)new Path(HibernateRefactoringUtil.getUpdatedPath(attrib, oldPath, newPath)), oldPath);
                newMementos.add(memento);
            } else if (HibernateRefactoringUtil.isAttributeChanged(projName, oldPath)) {
                isChanged = true;
                memento = HibernateRefactoringUtil.getUpdatedMemento(oldMementos.get(i), newPath, oldPath);
                newMementos.add(memento);
            } else {
                newMementos.add(entries[i].getMemento());
            }
            ++i;
        }
        return isChanged;
    }

    private static String getUpdatedMemento(String memento, IPath newPath, IPath oldPath) throws CoreException {
        String error_mess = "Error occured while updating classpath.";
        try {
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document doc = builder.parse(new InputSource(new StringReader(memento)));
            DOMSource domSource = new DOMSource(doc);
            StringWriter writer = new StringWriter();
            StreamResult result = new StreamResult(writer);
            TransformerFactory tf = TransformerFactory.newInstance();
            Transformer transformer = tf.newTransformer();
            transformer.transform(domSource, result);
            NodeList nodeList = doc.getElementsByTagName("runtimeClasspathEntry");
            int i = 0;
            while (i < nodeList.getLength()) {
                Node node = nodeList.item(i);
                NamedNodeMap map = node.getAttributes();
                Node changedNode = null;
                String[] attrNames = new String[]{"projectName", "externalArchive", "internalArchive", "containerPath", "javaProject"};
                int j = 0;
                while (j < attrNames.length) {
                    Path attrPath;
                    changedNode = map.getNamedItem(attrNames[j]);
                    if (changedNode != null && oldPath.isPrefixOf((IPath)(attrPath = new Path(changedNode.getNodeValue())))) {
                        if (attrNames[j].equals("projectName") || attrNames[j].equals("javaProject")) {
                            changedNode.setNodeValue(newPath.lastSegment());
                        } else {
                            changedNode.setNodeValue(newPath.toString());
                        }
                    }
                    ++j;
                }
                if (node.getNodeType() == 1) {
                    Element element = (Element)node;
                    NodeList mementoList = element.getElementsByTagName("memento");
                    int j2 = 0;
                    while (j2 < mementoList.getLength()) {
                        Path attrPath;
                        map = mementoList.item(j2).getAttributes();
                        changedNode = map.getNamedItem("project");
                        if (changedNode != null && oldPath.isPrefixOf((IPath)(attrPath = new Path(changedNode.getNodeValue())))) {
                            changedNode.setNodeValue(newPath.lastSegment());
                        }
                        ++j2;
                    }
                }
                ++i;
            }
            domSource = new DOMSource(doc);
            String newMemento = LaunchingPlugin.serializeDocument((Document)doc);
            return newMemento;
        }
        catch (ParserConfigurationException e) {
            Status status = new Status(4, "org.hibernate.eclipse.console", error_mess, (Throwable)e);
            throw new CoreException((IStatus)status);
        }
        catch (SAXException e) {
            Status status = new Status(4, "org.hibernate.eclipse.console", error_mess, (Throwable)e);
            throw new CoreException((IStatus)status);
        }
        catch (IOException e) {
            Status status = new Status(4, "org.hibernate.eclipse.console", error_mess, (Throwable)e);
            throw new CoreException((IStatus)status);
        }
        catch (TransformerException e) {
            Status status = new Status(4, "org.hibernate.eclipse.console", error_mess, (Throwable)e);
            throw new CoreException((IStatus)status);
        }
    }

    private static void updateAttributes(IPath oldPath, IPath newPath, ILaunchConfigurationWorkingCopy wc) throws CoreException {
        String attrib2 = null;
        int i = 0;
        while (i < pathKeys.length) {
            attrib2 = wc.getAttribute(pathKeys[i], null);
            if (HibernateRefactoringUtil.isAttributeChanged(attrib2, oldPath)) {
                attrib2 = HibernateRefactoringUtil.getUpdatedPath(attrib2, oldPath, newPath);
                wc.setAttribute(pathKeys[i], attrib2);
            }
            ++i;
        }
        boolean isChanged = false;
        int i2 = 0;
        while (i2 < pathListKeys.length) {
            List list = wc.getAttribute(pathListKeys[i2], Collections.EMPTY_LIST);
            isChanged = false;
            ArrayList<String> newMappings = new ArrayList<String>();
            for (String attrib2 : list) {
                if (HibernateRefactoringUtil.isAttributeChanged(attrib2, oldPath)) {
                    attrib2 = HibernateRefactoringUtil.getUpdatedPath(attrib2, oldPath, newPath);
                    isChanged = true;
                }
                newMappings.add(attrib2);
            }
            if (isChanged) {
                wc.setAttribute(pathListKeys[i2], newMappings);
            }
            ++i2;
        }
    }

    private static String getUpdatedPath(String attrib, IPath oldPath, IPath newPath) {
        Path attribPath = new Path(attrib);
        Path newAttribPath = new Path("/");
        int j = 0;
        while (j < attribPath.segmentCount()) {
            if (oldPath.isPrefixOf(attribPath.removeFirstSegments(j))) {
                newAttribPath = newAttribPath.append(newPath);
                newAttribPath = newAttribPath.append(attribPath.removeFirstSegments(j + oldPath.segmentCount()));
                break;
            }
            newAttribPath = newAttribPath.append(attribPath.segment(j));
            ++j;
        }
        return newAttribPath.toOSString();
    }

    public static ILaunchConfiguration[] getAffectedLaunchConfigurations(IPath path) {
        ILaunchConfiguration[] configs = null;
        try {
            configs = DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurations();
            ArrayList<ILaunchConfiguration> list = new ArrayList<ILaunchConfiguration>();
            int i = 0;
            while (i < configs.length) {
                if ("org.hibernate.eclipse.launch.ConsoleConfigurationLaunchConfigurationType".equals(configs[i].getType().getIdentifier()) && HibernateRefactoringUtil.isConfigurationAffected(configs[i], path)) {
                    list.add(configs[i]);
                }
                ++i;
            }
            configs = list.toArray(new ILaunchConfiguration[list.size()]);
        }
        catch (CoreException e) {
            configs = new ILaunchConfiguration[]{};
            HibernateConsolePlugin.getDefault().logErrorMessage(ERROR_MESS, e);
        }
        return configs;
    }

    public static Change createChangesFromList(List<Change> changes, String name) {
        if (changes.size() == 0) {
            return null;
        }
        if (changes.size() == 1) {
            return changes.get(0);
        }
        return new CompositeChange(name, changes.toArray(new Change[changes.size()]));
    }
}

