/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.eclipse.launch;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.jface.viewers.AbstractTableViewer;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySheetEntry;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.IPropertySourceProvider;
import org.eclipse.ui.views.properties.PropertySheetEntry;
import org.eclipse.ui.views.properties.PropertySheetPage;
import org.hibernate.eclipse.console.ExtensionManager;
import org.hibernate.eclipse.console.HibernateConsolePlugin;
import org.hibernate.eclipse.console.model.impl.ExporterDefinition;
import org.hibernate.eclipse.console.model.impl.ExporterFactory;
import org.hibernate.eclipse.console.utils.EclipseImages;
import org.hibernate.eclipse.console.wizards.UpDownListComposite;
import org.hibernate.eclipse.launch.AddPropertyDialog;
import org.hibernate.eclipse.launch.ExporterAttributes;
import org.hibernate.eclipse.launch.ExporterFactoryPropertySource;
import org.hibernate.eclipse.launch.PathHelper;

public class ExporterSettingsTab
extends AbstractLaunchConfigurationTab {
    private Button enableEJB3annotations;
    private Button enableJDK5;
    private Set selectedExporters;
    private Set deletedExporterIds;
    private Button selectAll;
    private Button deselectAll;
    private PropertySheetPage propertySheet;
    private Button add;
    private Button remove;
    private IPropertyDescriptor currentDescriptor;
    private UpDownListComposite exporterUpDown;
    private ObservableFactoryList observableFactoryList;

    public void createControl(Composite parent) {
        this.selectedExporters = new HashSet();
        this.deletedExporterIds = new HashSet();
        Composite container = new Composite(parent, 0);
        GridData controlData = new GridData(1808);
        container.setLayoutData((Object)controlData);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 5;
        layout.marginWidth = 5;
        layout.verticalSpacing = 1;
        container.setLayout((Layout)layout);
        this.createGeneralSettings(container);
        this.createExporterTable(container);
        this.createExporterProperties(container);
        this.dialogChanged();
        this.setControl((Control)container);
    }

    private void createExporterProperties(Composite parent) {
        Composite exportersComposite = this.createComposite(parent, "Properties:");
        exportersComposite.setLayout((Layout)new GridLayout(2, false));
        GridData gd = new GridData(4, 4, true, true);
        gd.minimumHeight = 100;
        exportersComposite.setLayoutData((Object)gd);
        Group gr = new Group(exportersComposite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gr.setLayout((Layout)gridLayout);
        gd = new GridData(4, 4, true, true);
        gd.verticalSpan = 2;
        gr.setLayoutData((Object)gd);
        Control sheet = this.createPropertySheet((Composite)gr);
        gd = new GridData(4, 4, true, true);
        sheet.setLayoutData((Object)gd);
        this.add = new Button(exportersComposite, 8);
        this.add.setEnabled(false);
        this.add.setText("Add...");
        gd = new GridData(258);
        gd.horizontalIndent = 5;
        this.add.setLayoutData((Object)gd);
        this.add.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AddPropertyDialog dialog;
                IStructuredSelection ss = (IStructuredSelection)ExporterSettingsTab.this.getExporterTable().getSelection();
                ExporterFactory ef = (ExporterFactory)ss.getFirstElement();
                if (ef != null && (dialog = new AddPropertyDialog(ExporterSettingsTab.this.getShell(), ef)).open() == 0) {
                    ef.setProperty(dialog.getPropertyName(), dialog.getPropertyValue());
                    ExporterSettingsTab.this.dialogChanged();
                    ExporterSettingsTab.this.refreshPropertySheet();
                }
            }
        });
        this.remove = new Button(exportersComposite, 8);
        this.remove.setText("Remove...");
        this.remove.setEnabled(false);
        this.remove.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ExporterSettingsTab.this.currentDescriptor != null) {
                    IStructuredSelection ss = (IStructuredSelection)ExporterSettingsTab.this.getExporterTable().getSelection();
                    ExporterFactory ef = (ExporterFactory)ss.getFirstElement();
                    ef.removeProperty((String)ExporterSettingsTab.this.currentDescriptor.getId());
                    ExporterSettingsTab.this.dialogChanged();
                    ExporterSettingsTab.this.refreshPropertySheet();
                }
            }
        });
        gd = new GridData(258);
        gd.horizontalIndent = 5;
        this.remove.setLayoutData((Object)gd);
    }

    private Control createPropertySheet(Composite exportersComposite) {
        this.propertySheet = new PropertySheetPage(){

            public void handleEntrySelection(ISelection selection) {
                super.handleEntrySelection(selection);
                IStructuredSelection iss = (IStructuredSelection)selection;
                if (iss.isEmpty()) {
                    ExporterSettingsTab.this.currentDescriptor = null;
                } else {
                    MyPropertySheetEntry mse = (MyPropertySheetEntry)((Object)iss.getFirstElement());
                    ExporterSettingsTab.this.currentDescriptor = mse.getMyDescriptor();
                }
            }
        };
        this.propertySheet.createControl(exportersComposite);
        final MyPropertySheetEntry propertySheetEntry = new MyPropertySheetEntry();
        propertySheetEntry.setPropertySourceProvider(new IPropertySourceProvider(){

            public IPropertySource getPropertySource(Object object) {
                if (object instanceof ExporterFactory) {
                    return new ExporterFactoryPropertySource((ExporterFactory)object){

                        public void setPropertyValue(Object id, Object value) {
                            super.setPropertyValue(id, value);
                            ExporterSettingsTab.this.dialogChanged();
                        }
                    };
                }
                return null;
            }
        });
        this.propertySheet.setRootEntry((IPropertySheetEntry)propertySheetEntry);
        this.getExporterTable().addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection s = (IStructuredSelection)event.getSelection();
                if (s.isEmpty()) {
                    if (ExporterSettingsTab.this.add != null) {
                        ExporterSettingsTab.this.add.setEnabled(false);
                    }
                    if (ExporterSettingsTab.this.remove != null) {
                        ExporterSettingsTab.this.remove.setEnabled(false);
                    }
                    propertySheetEntry.setValues(new Object[0]);
                } else {
                    if (ExporterSettingsTab.this.add != null) {
                        ExporterSettingsTab.this.add.setEnabled(true);
                    }
                    if (ExporterSettingsTab.this.remove != null) {
                        ExporterSettingsTab.this.remove.setEnabled(true);
                    }
                    ExporterFactory ep = (ExporterFactory)s.getFirstElement();
                    propertySheetEntry.setValues(new Object[]{ep});
                }
            }
        });
        return this.propertySheet.getControl();
    }

    private void createExporterTable(Composite parent) {
        this.exporterUpDown = new UpDownListComposite(parent, 0, "Exporters:", true, (IBaseLabelProvider)new ExporterLabelProvider(), (IContentProvider)new ExporterContentProvider()){

            protected Object[] handleAdd(int idx) {
                switch (idx) {
                    case 0: {
                        Object[] selectExporters = ExporterSettingsTab.selectExporters(this.getShell(), "Add exporter", "Select the exporter(s) you want to add");
                        int i = 0;
                        while (i < selectExporters.length) {
                            ExporterDefinition exporterDefinition = (ExporterDefinition)selectExporters[i];
                            this.addDef(exporterDefinition);
                            ++i;
                        }
                        return new Object[0];
                    }
                    case 1: {
                        ExporterSettingsTab.this.getExporterTable().setAllChecked(true);
                        break;
                    }
                    case 2: {
                        ExporterSettingsTab.this.getExporterTable().setAllChecked(false);
                        break;
                    }
                }
                return null;
            }

            private void addDef(ExporterDefinition expDef) {
                int initialCount = this.getTable().getItemCount();
                boolean duplicate = false;
                do {
                    duplicate = false;
                    ++initialCount;
                    for (ExporterFactory def : ExporterSettingsTab.this.observableFactoryList.getList()) {
                        if (!def.getId().equals("" + initialCount)) continue;
                        duplicate = true;
                    }
                } while (duplicate);
                String initialName = "" + initialCount;
                ExporterFactory exporterFactory = new ExporterFactory(expDef, initialName);
                ExporterSettingsTab.this.observableFactoryList.add(exporterFactory);
                ExporterSettingsTab.this.selectedExporters.add(exporterFactory);
                ((CheckboxTableViewer)this.getTableViewer()).setChecked((Object)exporterFactory, true);
            }

            protected void handleRemove() {
                IStructuredSelection selection = (IStructuredSelection)this.getTableViewer().getSelection();
                if (selection != null) {
                    selection.size();
                    for (Object item : selection) {
                        ExporterSettingsTab.this.observableFactoryList.remove((ExporterFactory)item);
                        ExporterSettingsTab.this.deletedExporterIds.add(((ExporterFactory)item).getId());
                    }
                    this.listChanged();
                }
            }

            protected void moveSelectionDown() {
                Table table = this.getTableViewer().getTable();
                int[] indices = table.getSelectionIndices();
                if (indices.length < 1) {
                    return;
                }
                int[] newSelection = new int[indices.length];
                int max = table.getItemCount() - 1;
                int i = indices.length - 1;
                while (i >= 0) {
                    int index = indices[i];
                    if (index < max) {
                        ExporterFactory data = (ExporterFactory)this.getTableViewer().getElementAt(index);
                        ExporterSettingsTab.this.observableFactoryList.moveTo(index + 1, data);
                        newSelection[i] = index + 1;
                    }
                    --i;
                }
                table.setSelection(newSelection);
                this.listChanged();
            }

            protected void moveSelectionUp() {
                Table table = this.getTableViewer().getTable();
                int[] indices = table.getSelectionIndices();
                int[] newSelection = new int[indices.length];
                int i = 0;
                while (i < indices.length) {
                    int index = indices[i];
                    if (index > 0) {
                        ExporterFactory data = (ExporterFactory)this.getTableViewer().getElementAt(index);
                        ExporterSettingsTab.this.observableFactoryList.moveTo(index - 1, data);
                        newSelection[i] = index - 1;
                    }
                    ++i;
                }
                table.setSelection(newSelection);
                this.listChanged();
            }

            protected String[] getAddButtonLabels() {
                return new String[]{"Add...", "Select all", "Deselect all"};
            }

            protected void listChanged() {
                ExporterSettingsTab.this.dialogChanged();
            }
        };
        this.getExporterTable().addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                ExporterFactory factory = (ExporterFactory)event.getElement();
                if (!event.getChecked() && ExporterSettingsTab.this.selectedExporters.contains(factory)) {
                    ExporterSettingsTab.this.selectedExporters.remove(factory);
                } else if (event.getChecked() && !ExporterSettingsTab.this.selectedExporters.contains(factory)) {
                    ExporterSettingsTab.this.selectedExporters.add(factory);
                }
                ExporterSettingsTab.this.dialogChanged();
            }
        });
        GridData gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        gd.verticalAlignment = 4;
        gd.horizontalAlignment = 4;
        this.exporterUpDown.setLayoutData(gd);
    }

    private void createOldExporterTable(Composite parent) {
        Composite exporterOptions = this.createComposite(parent, "Exporters:");
        GridData gd = new GridData(4, 4, true, true);
        gd.minimumHeight = 100;
        exporterOptions.setLayoutData((Object)gd);
        exporterOptions.setLayout((Layout)new GridLayout(2, false));
        Table table = new Table(exporterOptions, 2592);
        this.getExporterTable().setContentProvider((IContentProvider)new ExporterContentProvider());
        this.getExporterTable().setLabelProvider((IBaseLabelProvider)new ExporterLabelProvider());
        this.getExporterTable().setColumnProperties(new String[]{"", "Description"});
        this.getExporterTable().addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                ExporterFactory factory = (ExporterFactory)event.getElement();
                if (!event.getChecked() && ExporterSettingsTab.this.selectedExporters.contains(factory)) {
                    ExporterSettingsTab.this.selectedExporters.remove(factory);
                } else if (event.getChecked() && !ExporterSettingsTab.this.selectedExporters.contains(factory)) {
                    ExporterSettingsTab.this.selectedExporters.add(factory);
                }
                ExporterSettingsTab.this.dialogChanged();
            }
        });
        gd = new GridData(4, 4, true, true);
        gd.verticalSpan = 2;
        gd.horizontalSpan = 1;
        table.setLayoutData((Object)gd);
        this.selectAll = new Button(exporterOptions, 8);
        this.selectAll.setText("Select All");
        this.selectAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExporterSettingsTab.this.getExporterTable().setAllChecked(true);
                ExporterSettingsTab.this.dialogChanged();
            }
        });
        gd = new GridData(258);
        gd.horizontalIndent = 5;
        this.selectAll.setLayoutData((Object)gd);
        this.deselectAll = new Button(exporterOptions, 8);
        this.deselectAll.setText("Deselect All");
        this.deselectAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExporterSettingsTab.this.getExporterTable().setAllChecked(false);
                ExporterSettingsTab.this.dialogChanged();
            }
        });
        gd = new GridData(258);
        gd.horizontalIndent = 5;
        this.deselectAll.setLayoutData((Object)gd);
    }

    private void createGeneralSettings(Composite parent) {
        SelectionListener fieldlistener = new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                ExporterSettingsTab.this.dialogChanged();
            }
        };
        Composite generalSettingsComposite = this.createComposite(parent, "General settings:");
        generalSettingsComposite.setLayoutData((Object)new GridData(1, 1, false, false));
        this.enableJDK5 = new Button(generalSettingsComposite, 32);
        this.enableJDK5.setText("Use Java 5 syntax");
        this.enableJDK5.addSelectionListener(fieldlistener);
        this.enableEJB3annotations = new Button(generalSettingsComposite, 32);
        this.enableEJB3annotations.setText("Generate EJB3 annotations");
        this.enableEJB3annotations.addSelectionListener(fieldlistener);
    }

    private Composite createComposite(Composite parent, String name) {
        new Label(parent, 0).setText(name);
        Composite client = new Composite(parent, 0);
        client.setLayoutData((Object)new GridData(4, 4, true, true));
        client.setLayout((Layout)new GridLayout());
        return client;
    }

    private void dialogChanged() {
        boolean configSelected = true;
        if (!configSelected) {
            this.updateStatus("Console configuration must be specified");
            return;
        }
        if (this.selectedExporters.size() == 0) {
            this.updateStatus("At least one exporter option must be selected");
            return;
        }
        for (ExporterFactory ef : this.observableFactoryList.getList()) {
            String str = (String)ef.getProperties().get("outputdir");
            String msg = null;
            if (str != null && (msg = PathHelper.checkDirectory(str, "Output directory for " + ef.getExporterDefinition().getDescription(), false)) != null) {
                this.updateStatus(msg);
                return;
            }
            str = (String)ef.getProperties().get("template_path");
            if (str == null || (msg = PathHelper.checkDirectory(str, "Template directory for " + ef.getExporterDefinition().getDescription(), true)) == null) continue;
            this.updateStatus(msg);
            return;
        }
        this.updateStatus(null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected String checkDirectory(IPath path, String name) {
        IResource res = ResourcesPlugin.getWorkspace().getRoot().findMember(path);
        if (res == null) return String.valueOf(name) + " does not exist";
        int resType = res.getType();
        if (resType != 4 && resType != 2) return String.valueOf(name) + " has to be a folder or project";
        IProject proj = res.getProject();
        if (proj.isOpen()) return null;
        return "Project for " + name + " is closed";
    }

    protected String checkFile(IPath path, String name) {
        IResource res = ResourcesPlugin.getWorkspace().getRoot().findMember(path);
        if (res != null) {
            int resType = res.getType();
            if (resType == 1) {
                return null;
            }
            return String.valueOf(name) + " must be a file";
        }
        return String.valueOf(name) + " does not exist";
    }

    private void updateStatus(String message) {
        this.setErrorMessage(message);
        this.updateLaunchConfigurationDialog();
    }

    private Path pathOrNull(String p) {
        if (p == null || p.trim().length() == 0) {
            return null;
        }
        return new Path(p);
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        try {
            ExporterAttributes attributes = new ExporterAttributes(configuration);
            this.selectedExporters.clear();
            this.enableEJB3annotations.setSelection(attributes.isEJB3Enabled());
            this.enableJDK5.setSelection(attributes.isJDK5Enabled());
            List exporterFactories = attributes.getExporterFactories();
            this.observableFactoryList = new ObservableFactoryList(exporterFactories);
            this.getExporterTable().setInput((Object)this.observableFactoryList);
            for (ExporterFactory exporterFactory : exporterFactories) {
                if (exporterFactory.isEnabled()) {
                    this.getExporterTable().setChecked((Object)exporterFactory, true);
                    this.selectedExporters.add(exporterFactory);
                    continue;
                }
                this.getExporterTable().setChecked((Object)exporterFactory, false);
            }
            this.refreshPropertySheet();
            this.dialogChanged();
        }
        catch (CoreException ce) {
            HibernateConsolePlugin.getDefault().logErrorMessage("Problem when reading hibernate tools launch configuration", ce);
        }
    }

    private void refreshPropertySheet() {
        this.getExporterTable().setSelection(this.getExporterTable().getSelection());
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("org.hibernate.tools.ejb3", this.enableEJB3annotations.getSelection());
        configuration.setAttribute("org.hibernate.tools.jdk5", this.enableJDK5.getSelection());
        List exporterFactories = ((ObservableFactoryList)this.getExporterTable().getInput()).getList();
        ExporterAttributes.saveExporterFactories(configuration, exporterFactories, this.selectedExporters, this.deletedExporterIds);
        this.deletedExporterIds.clear();
    }

    public String getName() {
        return "Exporters";
    }

    public Image getImage() {
        return EclipseImages.getImage("images/hicon.gif");
    }

    private CheckboxTableViewer getExporterTable() {
        return (CheckboxTableViewer)this.exporterUpDown.getTableViewer();
    }

    public static Object[] selectExporters(Shell shell, String title, String description) {
        ExporterLabelProvider labelProvider = new ExporterLabelProvider();
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(shell, (ILabelProvider)labelProvider);
        dialog.setTitle(title);
        dialog.setMessage(description);
        dialog.setElements(ExtensionManager.findExporterDefinitionsAsMap().values().toArray());
        dialog.setMultipleSelection(true);
        if (dialog.open() == 0) {
            return dialog.getResult();
        }
        return new ExporterDefinition[0];
    }

    private class ExporterContentProvider
    implements IStructuredContentProvider,
    PropertyChangeListener {
        private AbstractTableViewer viewer;

        private ExporterContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            return ((ObservableFactoryList)inputElement).getList().toArray();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            this.viewer = (AbstractTableViewer)viewer;
            ObservableFactoryList ol = (ObservableFactoryList)oldInput;
            ObservableFactoryList newList = (ObservableFactoryList)newInput;
            if (ol != null) {
                ol.removePropertyChangeListener(this);
            }
            if (newList != null) {
                newList.addPropertyChangeListener(this);
            }
        }

        public void propertyChange(PropertyChangeEvent evt) {
            if ("addElement".equals(evt.getPropertyName())) {
                this.viewer.add(evt.getNewValue());
            }
            if ("removeElement".equals(evt.getPropertyName())) {
                this.viewer.remove(evt.getOldValue());
            }
            if ("insertElement".equals(evt.getPropertyName())) {
                this.viewer.insert(evt.getNewValue(), ((Integer)evt.getOldValue()).intValue());
            }
        }
    }

    private static class ExporterLabelProvider
    implements ITableLabelProvider,
    ILabelProvider {
        Map exp2img = new HashMap();

        private ExporterLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            ExporterDefinition definition = this.getExporterDefinition(element);
            Image image = (Image)this.exp2img.get(definition.getId());
            if (image == null) {
                image = definition.getIconDescriptor().createImage();
                this.exp2img.put(definition.getId(), image);
            }
            return image;
        }

        private ExporterDefinition getExporterDefinition(Object element) {
            if (element instanceof ExporterFactory) {
                ExporterFactory ef = (ExporterFactory)element;
                return ef.getExporterDefinition();
            }
            return (ExporterDefinition)element;
        }

        public String getColumnText(Object element, int columnIndex) {
            ExporterDefinition definition = this.getExporterDefinition(element);
            return definition.getDescription();
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
            for (Image img : this.exp2img.values()) {
                if (img == null) continue;
                img.dispose();
            }
        }

        public boolean isLabelProperty(Object element, String property) {
            return true;
        }

        public void removeListener(ILabelProviderListener listener) {
        }

        public Image getImage(Object element) {
            return this.getColumnImage(element, 0);
        }

        public String getText(Object element) {
            return this.getColumnText(element, 0);
        }
    }

    public class MyPropertySheetEntry
    extends PropertySheetEntry {
        public IPropertyDescriptor getMyDescriptor() {
            return super.getDescriptor();
        }

        protected PropertySheetEntry createChildEntry() {
            return new MyPropertySheetEntry();
        }
    }

    private class ObservableFactoryList {
        List underlyingList = new ArrayList();
        PropertyChangeSupport pcs = new PropertyChangeSupport(this);

        public ObservableFactoryList(List exporterFactories) {
            this.underlyingList = exporterFactories;
        }

        public void moveTo(int i, ExporterFactory data) {
            this.underlyingList.remove(data);
            this.remove(data);
            this.underlyingList.add(i, data);
            this.pcs.firePropertyChange("insertElement", new Integer(i), data);
        }

        void addPropertyChangeListener(PropertyChangeListener pcl) {
            this.pcs.addPropertyChangeListener(pcl);
        }

        public List getList() {
            return Collections.unmodifiableList(this.underlyingList);
        }

        void removePropertyChangeListener(PropertyChangeListener pcl) {
            this.pcs.removePropertyChangeListener(pcl);
        }

        boolean add(ExporterFactory o) {
            boolean changed = this.underlyingList.add(o);
            this.pcs.firePropertyChange("addElement", null, o);
            return changed;
        }

        boolean remove(ExporterFactory o) {
            boolean changed = this.underlyingList.remove(o);
            this.pcs.firePropertyChange("removeElement", o, null);
            return changed;
        }
    }
}

