/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.eclipse.launch;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.hibernate.console.HibernateConsoleRuntimeException;
import org.hibernate.eclipse.console.ExtensionManager;
import org.hibernate.eclipse.console.HibernateConsolePlugin;
import org.hibernate.eclipse.console.model.impl.ExporterDefinition;
import org.hibernate.eclipse.console.model.impl.ExporterFactory;

public class ExporterAttributes {
    private boolean reverseEngineer;
    private boolean useOwnTemplates;
    private boolean enableJDK5;
    private boolean enableEJB3;
    private boolean preferBasicCompositeIds;
    private String consoleConfigurationName;
    private String revengSettings;
    private String revengStrategy;
    private String packageName;
    private String outputPath;
    private String templatePath;
    private List exporterFactories;
    private boolean autoManyToManyDetection;
    private boolean autoVersioning;

    public ExporterAttributes() {
    }

    public ExporterAttributes(ILaunchConfiguration configuration) throws CoreException {
        this.initialize(configuration);
    }

    public void initialize(ILaunchConfiguration configuration) throws CoreException {
        try {
            this.consoleConfigurationName = configuration.getAttribute("org.hibernate.tools.configurationname", "");
            this.outputPath = configuration.getAttribute("org.hibernate.tools.outputdir", "");
            this.reverseEngineer = configuration.getAttribute("org.hibernate.tools.schema2hbm", false);
            this.revengSettings = configuration.getAttribute("org.hibernate.tools.revengfile", "");
            this.revengStrategy = configuration.getAttribute("org.hibernate.tools.revengstrategy", "");
            this.useOwnTemplates = configuration.getAttribute("org.hibernate.tools.useOwnTemplates", false);
            this.enableJDK5 = configuration.getAttribute("org.hibernate.tools.jdk5", false);
            this.enableEJB3 = configuration.getAttribute("org.hibernate.tools.ejb3", false);
            this.packageName = configuration.getAttribute("org.hibernate.tools.package", "");
            this.templatePath = configuration.getAttribute("org.hibernate.tools.templatepath", "");
            this.preferBasicCompositeIds = configuration.getAttribute("org.hibernate.tools.prefercompositeids", true);
            this.autoManyToManyDetection = configuration.getAttribute("org.hibernate.tools.reveng.detect_many_to_many", true);
            this.autoVersioning = configuration.getAttribute("org.hibernate.tools.reveng.detect_optimistc_lock", true);
            if (!this.useOwnTemplates) {
                this.templatePath = null;
            }
            this.exporterFactories = this.readExporterFactories(configuration);
        }
        catch (CoreException e) {
            throw new CoreException(HibernateConsolePlugin.throwableToStatus(e, 666));
        }
    }

    static String getLaunchAttributePrefix(String exporterId) {
        return "org.hibernate.tools.exporters." + exporterId;
    }

    private List readExporterFactories(ILaunchConfiguration configuration) throws CoreException {
        List exporterNames = configuration.getAttribute("org.hibernate.tools.exporters", null);
        if (exporterNames != null) {
            Map exDefinitions = ExtensionManager.findExporterDefinitionsAsMap();
            ArrayList<ExporterFactory> factories = new ArrayList<ExporterFactory>();
            for (String exporterId : exporterNames) {
                String extensionId = configuration.getAttribute(String.valueOf(ExporterAttributes.getLaunchAttributePrefix(exporterId)) + ".extension_id", null);
                ExporterDefinition expDef = (ExporterDefinition)exDefinitions.get(extensionId);
                if (expDef == null) {
                    throw new HibernateConsoleRuntimeException("Could not locate exporter for '" + extensionId + "' in " + configuration.getName());
                }
                ExporterFactory exporterFactory = new ExporterFactory(expDef, exporterId);
                exporterFactory.isEnabled(configuration);
                factories.add(exporterFactory);
                Map props = configuration.getAttribute(String.valueOf(ExporterAttributes.getLaunchAttributePrefix(exporterFactory.getId())) + ".properties", new HashMap());
                exporterFactory.setProperties(props);
            }
            return factories;
        }
        ExporterDefinition[] exDefinitions = ExtensionManager.findExporterDefinitions();
        ArrayList<ExporterFactory> factories = new ArrayList<ExporterFactory>();
        int i = 0;
        while (i < exDefinitions.length) {
            ExporterDefinition expDef = exDefinitions[i];
            ExporterFactory exporterFactory = new ExporterFactory(expDef, expDef.getId());
            exporterFactory.isEnabled(configuration);
            factories.add(exporterFactory);
            Map props = configuration.getAttribute(String.valueOf(ExporterAttributes.getLaunchAttributePrefix(exporterFactory.getId())) + ".properties", new HashMap());
            exporterFactory.setProperties(props);
            ++i;
        }
        return factories;
    }

    public static void saveExporterFactories(ILaunchConfigurationWorkingCopy configuration, List exporterFactories, Set enabledExporters, Set deletedExporterIds) {
        ArrayList<String> names = new ArrayList<String>();
        for (ExporterFactory ef : exporterFactories) {
            configuration.setAttribute(String.valueOf(ExporterAttributes.getLaunchAttributePrefix(ef.getId())) + ".extension_id", ef.getExporterDefinition().getId());
            boolean enabled = enabledExporters.contains(ef);
            String propertiesId = String.valueOf(ExporterAttributes.getLaunchAttributePrefix(ef.getId())) + ".properties";
            names.add(ef.getId());
            ef.setEnabled(configuration, enabled, false);
            HashMap map = new HashMap(ef.getProperties());
            if (map.isEmpty()) {
                configuration.setAttribute(propertiesId, null);
                continue;
            }
            configuration.setAttribute(propertiesId, map);
        }
        deletedExporterIds.removeAll(names);
        for (String deleted : deletedExporterIds) {
            configuration.setAttribute(ExporterAttributes.getLaunchAttributePrefix(deleted), null);
            configuration.setAttribute(String.valueOf(ExporterAttributes.getLaunchAttributePrefix(deleted)) + ".extension_id", null);
            configuration.setAttribute(ExporterAttributes.getLaunchAttributePrefix(deleted), null);
        }
        configuration.setAttribute("org.hibernate.tools.exporters", names);
    }

    public static void oldSaveExporterFactories(ILaunchConfigurationWorkingCopy configuration, List exporterFactories, List enabledExporters) {
        for (ExporterFactory ef : exporterFactories) {
            boolean enabled = enabledExporters.contains(ef);
            String propertiesId = String.valueOf(ef.getId()) + ".properties";
            ef.setEnabled(configuration, enabled, true);
            HashMap map = new HashMap(ef.getProperties());
            if (map.isEmpty()) {
                configuration.setAttribute(propertiesId, null);
                continue;
            }
            configuration.setAttribute(propertiesId, map);
        }
    }

    private Path pathOrNull(String p) {
        if (p == null || p.trim().length() == 0) {
            return null;
        }
        return new Path(p);
    }

    public String getOutputPath() {
        return this.outputPath;
    }

    public void setOutputPath(String outputPath) {
        this.outputPath = outputPath;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public String getRevengSettings() {
        return this.revengSettings;
    }

    public void setRevengSettings(String revengSettings) {
        this.revengSettings = revengSettings;
    }

    public String getRevengStrategy() {
        return this.revengStrategy;
    }

    public void setRevengStrategy(String revengStrategy) {
        this.revengStrategy = revengStrategy;
    }

    public String getTemplatePath() {
        return this.templatePath;
    }

    public void setTemplatePath(String templatePath) {
        this.templatePath = templatePath;
    }

    public String getConsoleConfigurationName() {
        return this.consoleConfigurationName;
    }

    public void setConsoleConfigurationName(String consoleConfigurationName) {
        this.consoleConfigurationName = consoleConfigurationName;
    }

    public boolean isEJB3Enabled() {
        return this.enableEJB3;
    }

    public void setEnableEJB3(boolean enableEJB3) {
        this.enableEJB3 = enableEJB3;
    }

    public boolean isJDK5Enabled() {
        return this.enableJDK5;
    }

    public void setEnableJDK5(boolean enableJDK5) {
        this.enableJDK5 = enableJDK5;
    }

    public boolean isPreferBasicCompositeIds() {
        return this.preferBasicCompositeIds;
    }

    public void setPreferBasicCompositeIds(boolean preferBasicCompositeIds) {
        this.preferBasicCompositeIds = preferBasicCompositeIds;
    }

    public boolean isReverseEngineer() {
        return this.reverseEngineer;
    }

    public void setReverseEngineer(boolean reverseEngineer) {
        this.reverseEngineer = reverseEngineer;
    }

    public boolean isUseOwnTemplates() {
        return this.useOwnTemplates;
    }

    public void setUseOwnTemplates(boolean useOwnTemplates) {
        this.useOwnTemplates = useOwnTemplates;
    }

    public List getExporterFactories() {
        return this.exporterFactories;
    }

    public boolean detectManyToMany() {
        return this.autoManyToManyDetection;
    }

    public boolean detectOptimisticLock() {
        return this.autoVersioning;
    }
}

