/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.eclipse.launch;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTabGroup;
import org.eclipse.debug.ui.CommonTab;
import org.eclipse.debug.ui.ILaunchConfigurationDialog;
import org.eclipse.debug.ui.ILaunchConfigurationTab;
import org.eclipse.jdt.debug.ui.launchConfigurations.JavaClasspathTab;
import org.eclipse.jdt.launching.IRuntimeClasspathEntry;
import org.eclipse.jdt.launching.JavaRuntime;
import org.hibernate.eclipse.console.HibernateConsolePlugin;
import org.hibernate.eclipse.launch.ConsoleConfigurationMainTab;
import org.hibernate.eclipse.launch.ConsoleConfigurationMappingsTab;
import org.hibernate.eclipse.launch.ConsoleConfigurationOptionsTab;

public class ConsoleConfigurationTabGroup
extends AbstractLaunchConfigurationTabGroup {
    public void createTabs(ILaunchConfigurationDialog dialog, String mode) {
        ILaunchConfigurationTab[] tabs = new ILaunchConfigurationTab[]{new ConsoleConfigurationMainTab(), new ConsoleConfigurationOptionsTab(), new JavaClasspathTab(){

            public boolean isShowBootpath() {
                return false;
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public boolean isValid(ILaunchConfiguration launchConfig) {
                if (!super.isValid(launchConfig)) {
                    return false;
                }
                this.setErrorMessage(null);
                this.setMessage(null);
                try {
                    IRuntimeClasspathEntry[] entries = JavaRuntime.computeUnresolvedRuntimeClasspath((ILaunchConfiguration)launchConfig);
                    int i = 0;
                    while (i < entries.length) {
                        IRuntimeClasspathEntry entry = entries[i];
                        if (entry.getClasspathProperty() == 3) {
                            return true;
                        }
                        ++i;
                    }
                }
                catch (CoreException e) {
                    HibernateConsolePlugin.getDefault().log(e);
                }
                this.setErrorMessage("Classpath must be set or restored to default");
                return false;
            }

            public void initializeFrom(ILaunchConfiguration configuration) {
                super.initializeFrom(configuration);
            }

            public boolean canSave() {
                return super.canSave();
            }
        }, new ConsoleConfigurationMappingsTab(), new CommonTab()};
        this.setTabs(tabs);
    }
}

