/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.eclipse.launch;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.WizardNewFileCreationPage;
import org.hibernate.console.preferences.ConsoleConfigurationPreferences;
import org.hibernate.eclipse.console.HibernateConsolePlugin;
import org.hibernate.eclipse.console.utils.DialogSelectionHelper;
import org.hibernate.eclipse.console.utils.EclipseImages;
import org.hibernate.eclipse.console.utils.ProjectUtils;
import org.hibernate.eclipse.console.wizards.NewConfigurationWizard;
import org.hibernate.eclipse.console.wizards.NewConfigurationWizardPage;
import org.hibernate.eclipse.launch.ConsoleConfigurationTab;
import org.hibernate.util.StringHelper;

public class ConsoleConfigurationMainTab
extends ConsoleConfigurationTab {
    private Button coreMode;
    private Button jpaMode;
    private Button annotationsMode;
    private Button confbutton;
    private Text propertyFileText;
    private Text configurationFileText;
    private Text projectNameText;
    private Text persistenceUnitNameText;

    public String getName() {
        return "Main";
    }

    public void createControl(Composite parent) {
        Font font = parent.getFont();
        Composite comp = new Composite(parent, 0);
        this.setControl((Control)comp);
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 0;
        comp.setLayout((Layout)layout);
        comp.setFont(font);
        this.createConfigurationMode(comp);
        this.createProjectEditor(comp);
        this.createPropertyFileEditor(comp);
        this.createConfigurationFileEditor(comp);
        this.createPersistenceUnitEditor(comp);
    }

    private void createConfigurationMode(Composite container) {
        Group group = this.createGroup(container, "Type:");
        group.setLayout((Layout)new RowLayout(256));
        this.coreMode = new Button((Composite)group, 16);
        this.coreMode.setText("Core");
        this.coreMode.addSelectionListener((SelectionListener)this.getChangeListener());
        this.coreMode.setSelection(true);
        this.annotationsMode = new Button((Composite)group, 16);
        this.annotationsMode.setText("Annotations (jdk 1.5+)");
        this.annotationsMode.addSelectionListener((SelectionListener)this.getChangeListener());
        this.jpaMode = new Button((Composite)group, 16);
        this.jpaMode.setText("JPA (jdk 1.5+)");
        this.jpaMode.addSelectionListener((SelectionListener)this.getChangeListener());
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        group.setLayoutData((Object)gd);
    }

    protected void createProjectEditor(Composite parent) {
        Group group = this.createGroup(parent, "Project:");
        this.projectNameText = this.createBrowseEditor(parent, group);
        this.createBrowseButton(group, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ConsoleConfigurationMainTab.this.handleProjectBrowse();
            }
        });
    }

    private void createPropertyFileEditor(Composite parent) {
        Group group = this.createGroup(parent, "Property file:");
        this.propertyFileText = this.createBrowseEditor(parent, group);
        this.createSetupButton(group, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ConsoleConfigurationMainTab.this.handlePropertyFileSetup();
            }
        });
    }

    private void createConfigurationFileEditor(Composite parent) {
        Group group = this.createGroup(parent, "Configuration file:");
        this.configurationFileText = this.createBrowseEditor(parent, group);
        this.confbutton = this.createSetupButton(group, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ConsoleConfigurationMainTab.this.handleConfigurationFileSetup();
            }
        });
    }

    private void createPersistenceUnitEditor(Composite parent) {
        Group group = this.createGroup(parent, "Persistence unit:");
        this.persistenceUnitNameText = new Text((Composite)group, 2052);
        GridData gd = new GridData(768);
        this.persistenceUnitNameText.setFont(parent.getFont());
        this.persistenceUnitNameText.setLayoutData((Object)gd);
        this.persistenceUnitNameText.addModifyListener((ModifyListener)this.getChangeListener());
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("org.hibernate.eclipse.launch.CONFIGURATION_FACTORY", this.getConfigurationMode().toString());
        configuration.setAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, this.nonEmptyTrimOrNull(this.projectNameText));
        configuration.setAttribute("org.hibernate.eclipse.launch.PROPERTY_FILE", this.nonEmptyTrimOrNull(this.propertyFileText));
        configuration.setAttribute("org.hibernate.eclipse.launch.CFG_XML_FILE", this.nonEmptyTrimOrNull(this.configurationFileText));
        configuration.setAttribute("org.hibernate.eclipse.launch.PERSISTENCE_UNIT_NAME", this.nonEmptyTrimOrNull(this.persistenceUnitNameText));
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        try {
            ConsoleConfigurationPreferences.ConfigurationMode cm = ConsoleConfigurationPreferences.ConfigurationMode.parse((String)configuration.getAttribute("org.hibernate.eclipse.launch.CONFIGURATION_FACTORY", ""));
            this.coreMode.setSelection(cm.equals(ConsoleConfigurationPreferences.ConfigurationMode.CORE));
            this.annotationsMode.setSelection(cm.equals(ConsoleConfigurationPreferences.ConfigurationMode.ANNOTATIONS));
            this.jpaMode.setSelection(cm.equals(ConsoleConfigurationPreferences.ConfigurationMode.JPA));
            this.projectNameText.setText(configuration.getAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, ""));
            this.propertyFileText.setText(configuration.getAttribute("org.hibernate.eclipse.launch.PROPERTY_FILE", ""));
            this.configurationFileText.setText(configuration.getAttribute("org.hibernate.eclipse.launch.CFG_XML_FILE", ""));
            this.persistenceUnitNameText.setText(configuration.getAttribute("org.hibernate.eclipse.launch.PERSISTENCE_UNIT_NAME", ""));
        }
        catch (CoreException e) {
            HibernateConsolePlugin.getDefault().log(e);
        }
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
    }

    private void handlePropertyFileSetup() {
        MessageDialog dialog;
        int answer;
        Path initialPath;
        int defaultChoice = 0;
        Path path = initialPath = this.getPropertyFilePath() != null ? this.getPropertyFilePath() : null;
        if (initialPath != null) {
            defaultChoice = 1;
        }
        if ((answer = (dialog = this.createSetupDialog("Setup property file", "Do you want to create a new property file or use an existing one ?", defaultChoice)).open()) == 0) {
            this.handlePropertyFileCreate();
        } else if (answer == 1) {
            this.handlePropertyFileBrowse();
        }
    }

    private void handlePropertyFileBrowse() {
        Path initialPath = this.getPropertyFilePath() != null ? this.getPropertyFilePath() : new Path(this.getProjectName());
        IPath[] paths = org.hibernate.eclipse.console.utils.xpl.DialogSelectionHelper.chooseFileEntries(this.getShell(), (IPath)initialPath, new IPath[0], "Select property file", "Choose file to use as hibernate.properties", new String[]{"properties"}, false, false, true);
        if (paths != null && paths.length == 1) {
            this.propertyFileText.setText(paths[0].toOSString());
        }
    }

    private void handleProjectBrowse() {
        IJavaProject paths = DialogSelectionHelper.chooseJavaProject(this.getShell(), this.findJavaProject(), "Select java project", "The (optional) java project is used to determine the default classpath");
        if (paths != null) {
            this.projectNameText.setText(paths.getProject().getName());
        } else {
            this.projectNameText.setText("");
        }
    }

    private IJavaProject findJavaProject() {
        Path path = this.pathOrNull(this.getProjectName());
        if (path != null && path.segmentCount() >= 1) {
            String projectName = path.segment(0);
            return ProjectUtils.findJavaProject(projectName);
        }
        return null;
    }

    private void handlePropertyFileCreate() {
        Wizard wizard = new Wizard(){
            String pageName = "Create Property File";
            WizardNewFileCreationPage cPage = null;

            public void addPages() {
                StructuredSelection selection = null;
                IJavaProject project = ConsoleConfigurationMainTab.this.findJavaProject();
                selection = project != null ? new StructuredSelection((Object)project) : StructuredSelection.EMPTY;
                this.cPage = new WizardNewFileCreationPage(this.pageName, (IStructuredSelection)selection);
                this.cPage.setTitle("Create Hibernate Properties file (.properties)");
                this.cPage.setDescription("Create a new properties file");
                this.cPage.setFileName("hibernate.properties");
                this.addPage((IWizardPage)this.cPage);
            }

            public boolean performFinish() {
                IFile file = this.cPage.createNewFile();
                ConsoleConfigurationMainTab.this.propertyFileText.setText(file.getFullPath().toOSString());
                return true;
            }
        };
        IWorkbenchWindow win = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        WizardDialog wdialog = new WizardDialog(win.getShell(), (IWizard)wizard);
        wdialog.open();
    }

    private MessageDialog createSetupDialog(String title, String question, int defaultChoice) {
        return new MessageDialog(this.getShell(), title, null, question, 3, new String[]{"Create &new...", "Use &existing...", IDialogConstants.CANCEL_LABEL}, defaultChoice);
    }

    private void handleConfigurationFileSetup() {
        MessageDialog dialog;
        int answer;
        Path initialPath;
        int defaultChoice = 0;
        Path path = initialPath = this.getConfigurationFilePath() != null ? this.getConfigurationFilePath() : null;
        if (initialPath != null) {
            defaultChoice = 1;
        }
        if ((answer = (dialog = this.createSetupDialog("Setup configuration file", "Do you want to create a new *.cfg.xml or use an existing one ?", defaultChoice)).open()) == 0) {
            this.handleConfigurationFileCreate();
        } else if (answer == 1) {
            this.handleConfigurationFileBrowse();
        }
    }

    private void handleConfigurationFileBrowse() {
        Path initialPath = this.getConfigurationFilePath() != null ? this.getConfigurationFilePath() : new Path(this.getProjectName());
        IPath[] paths = DialogSelectionHelper.chooseFileEntries(this.getShell(), (IPath)initialPath, new IPath[0], "Select hibernate.cfg.xml file", "Choose file to use as hibernate.cfg.xml", new String[]{"cfg.xml"}, false, false, true);
        if (paths != null && paths.length == 1) {
            this.configurationFileText.setText(paths[0].toOSString());
        }
    }

    private void handleConfigurationFileCreate() {
        WizardNewFileCreationPage createdFilePath;
        StructuredSelection selection = null;
        IJavaProject project = this.findJavaProject();
        selection = project != null ? new StructuredSelection((Object)project) : StructuredSelection.EMPTY;
        NewConfigurationWizard wizard = new NewConfigurationWizard();
        wizard.init(PlatformUI.getWorkbench(), (IStructuredSelection)selection);
        IWorkbenchWindow win = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        WizardDialog wdialog = new WizardDialog(win.getShell(), (IWizard)wizard);
        wdialog.create();
        IWizardPage configPage = wizard.getPage("wizardPage");
        if (configPage != null && configPage instanceof NewConfigurationWizardPage) {
            ((NewConfigurationWizardPage)configPage).setCreateConsoleConfigurationVisible(false);
        }
        if (wdialog.open() == 0 && (createdFilePath = (WizardNewFileCreationPage)wizard.getStartingPage()) != null) {
            this.configurationFileText.setText(createdFilePath.createNewFile().getFullPath().toOSString());
        }
    }

    private Path pathOrNull(String p) {
        if (p == null || p.trim().length() == 0) {
            return null;
        }
        return new Path(p);
    }

    public Path getConfigurationFilePath() {
        return this.pathOrNull(this.configurationFileText.getText());
    }

    public Path getPropertyFilePath() {
        String p = this.propertyFileText.getText();
        return this.pathOrNull(p);
    }

    public boolean isValid(ILaunchConfiguration launchConfig) {
        IResource resource;
        String msg;
        this.setErrorMessage(null);
        this.setMessage(null);
        String propertyFilename = this.propertyFileText.getText();
        String configurationFilename = this.configurationFileText.getText();
        this.configurationFileText.setEnabled(!this.getConfigurationMode().equals(ConsoleConfigurationPreferences.ConfigurationMode.JPA));
        this.confbutton.setEnabled(!this.getConfigurationMode().equals(ConsoleConfigurationPreferences.ConfigurationMode.JPA));
        this.persistenceUnitNameText.setEnabled(this.getConfigurationMode().equals(ConsoleConfigurationPreferences.ConfigurationMode.JPA));
        if (this.getProjectName() != null && StringHelper.isNotEmpty((String)this.getProjectName().trim())) {
            Path projectPath = new Path(this.getProjectName());
            if (projectPath.segmentCount() > 1) {
                this.setErrorMessage("Path for project must have only one segment.");
                return false;
            }
            IJavaProject findJavaProject = ProjectUtils.findJavaProject(this.getProjectName());
            if (findJavaProject == null || !findJavaProject.exists()) {
                this.setErrorMessage("The Java project " + this.getProjectName() + " does not exist.");
                return false;
            }
        }
        if (propertyFilename.length() > 0 && (msg = this.checkForFile("Property file", resource = ResourcesPlugin.getWorkspace().getRoot().findMember(propertyFilename))) != null) {
            this.setErrorMessage(msg);
            return false;
        }
        if (configurationFilename.length() > 0 && (msg = this.checkForFile("Configuration file", resource = ResourcesPlugin.getWorkspace().getRoot().findMember(configurationFilename))) != null) {
            this.setErrorMessage(msg);
            return false;
        }
        return true;
    }

    private ConsoleConfigurationPreferences.ConfigurationMode getConfigurationMode() {
        if (this.annotationsMode.getSelection()) {
            return ConsoleConfigurationPreferences.ConfigurationMode.ANNOTATIONS;
        }
        if (this.jpaMode.getSelection()) {
            return ConsoleConfigurationPreferences.ConfigurationMode.JPA;
        }
        return ConsoleConfigurationPreferences.ConfigurationMode.CORE;
    }

    String getProjectName() {
        return this.projectNameText.getText();
    }

    private String checkForFile(String msgPrefix, IResource resource) {
        if (resource != null) {
            if (resource instanceof IFile) {
                return null;
            }
            return String.valueOf(msgPrefix) + " is not a file";
        }
        return String.valueOf(msgPrefix) + " does not exist";
    }

    public Image getImage() {
        return EclipseImages.getImage("images/hicon.gif");
    }
}

