/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.eclipse.launch;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.variables.IStringVariableManager;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.ComboDialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.IStringButtonAdapter;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.SelectionButtonDialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.StringButtonDialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.StringDialogField;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.hibernate.cfg.reveng.ReverseEngineeringStrategy;
import org.hibernate.console.ConsoleConfiguration;
import org.hibernate.console.KnownConfigurations;
import org.hibernate.eclipse.console.HibernateConsolePlugin;
import org.hibernate.eclipse.console.utils.DialogSelectionHelper;
import org.hibernate.eclipse.console.utils.EclipseImages;
import org.hibernate.eclipse.console.wizards.NewReverseEngineeringFileWizard;
import org.hibernate.eclipse.launch.DirectoryBrowseField;
import org.hibernate.eclipse.launch.ExporterAttributes;
import org.hibernate.eclipse.launch.PathHelper;

public class CodeGenerationSettingsTab
extends AbstractLaunchConfigurationTab {
    private ComboDialogField consoleConfigurationName;
    private IStructuredSelection selection;
    private SelectionButtonDialogField reverseengineer;
    private StringButtonDialogField outputdir;
    private StringButtonDialogField reverseEngineeringSettings;
    private StringButtonDialogField reverseEngineeringStrategy;
    private StringDialogField packageName;
    private SelectionButtonDialogField preferRawCompositeIds;
    private SelectionButtonDialogField autoVersioning;
    private SelectionButtonDialogField autoManyToMany;
    private SelectionButtonDialogField useOwnTemplates;
    private DirectoryBrowseField templatedir;

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        container.setLayout((Layout)layout);
        layout.numColumns = 4;
        layout.verticalSpacing = 10;
        this.consoleConfigurationName = new ComboDialogField(8);
        this.consoleConfigurationName.setLabelText("Console &configuration:");
        ConsoleConfiguration[] cfg = KnownConfigurations.getInstance().getConfigurationsSortedByName();
        String[] names = new String[cfg.length];
        int i = 0;
        while (i < cfg.length) {
            ConsoleConfiguration configuration = cfg[i];
            names[i] = configuration.getName();
            ++i;
        }
        this.consoleConfigurationName.setItems(names);
        IDialogFieldListener fieldlistener = new IDialogFieldListener(){

            public void dialogFieldChanged(DialogField field) {
                CodeGenerationSettingsTab.this.dialogChanged();
            }
        };
        this.consoleConfigurationName.setDialogFieldListener(fieldlistener);
        this.outputdir = new StringButtonDialogField(new IStringButtonAdapter(){

            public void changeControlPressed(DialogField field) {
                IPath[] paths = DialogSelectionHelper.chooseFolderEntries(CodeGenerationSettingsTab.this.getShell(), (IPath)PathHelper.pathOrNull(CodeGenerationSettingsTab.this.outputdir.getText()), "Select output directory", "Choose directory in which the generated files will be stored", false);
                if (paths != null && paths.length == 1) {
                    CodeGenerationSettingsTab.this.outputdir.setText(paths[0].toOSString());
                }
            }
        });
        this.outputdir.setDialogFieldListener(fieldlistener);
        this.outputdir.setLabelText("Output &directory:");
        this.outputdir.setButtonLabel("&Browse...");
        this.templatedir = new DirectoryBrowseField(null, null, "Select template directory", "Choose directory containing custom templates");
        this.templatedir.setDialogFieldListener(fieldlistener);
        this.templatedir.setLabelText("Template &directory:");
        this.templatedir.setFilesystemBrowseLabel("&Filesystem...");
        this.templatedir.setWorkspaceBrowseLabel("&Workspace...");
        this.packageName = new StringDialogField();
        this.packageName.setDialogFieldListener(fieldlistener);
        this.packageName.setLabelText("&Package:");
        this.reverseEngineeringStrategy = new StringButtonDialogField(new IStringButtonAdapter(){

            public void changeControlPressed(DialogField field) {
                String string = DialogSelectionHelper.chooseImplementation(ReverseEngineeringStrategy.class.getName(), CodeGenerationSettingsTab.this.reverseEngineeringStrategy.getText(), "Choose a reverse engineering strategy", CodeGenerationSettingsTab.this.getShell());
                if (string != null) {
                    CodeGenerationSettingsTab.this.reverseEngineeringStrategy.setText(string);
                }
            }
        });
        this.reverseEngineeringStrategy.setDialogFieldListener(fieldlistener);
        this.reverseEngineeringStrategy.setLabelText("reveng. s&trategy:");
        this.reverseEngineeringStrategy.setButtonLabel("&Browse...");
        this.reverseEngineeringSettings = new StringButtonDialogField(new IStringButtonAdapter(){

            public void changeControlPressed(DialogField field) {
                IPath[] paths;
                int defaultChoice = 0;
                IPath reverseEngineeringSettingsFile = CodeGenerationSettingsTab.this.getReverseEngineeringSettingsFile();
                defaultChoice = reverseEngineeringSettingsFile == null ? 0 : 1;
                MessageDialog dialog = new MessageDialog(CodeGenerationSettingsTab.this.getShell(), "Setup reverse engineering", null, "Do you want to create a new reveng.xml or use an existing file ?", 3, new String[]{"Create &new...", "Use &existing...", IDialogConstants.CANCEL_LABEL}, defaultChoice);
                int answer = dialog.open();
                if (answer == 0) {
                    NewReverseEngineeringFileWizard wizard = new NewReverseEngineeringFileWizard();
                    wizard.init(PlatformUI.getWorkbench(), CodeGenerationSettingsTab.this.selection);
                    wizard.setSelectConfiguration(CodeGenerationSettingsTab.this.getConfigurationName());
                    IWorkbenchWindow win = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                    WizardDialog wdialog = new WizardDialog(win.getShell(), (IWizard)wizard);
                    wdialog.open();
                    IPath createdFilePath = wizard.getCreatedFilePath();
                    if (createdFilePath != null) {
                        CodeGenerationSettingsTab.this.reverseEngineeringSettings.setText(createdFilePath.toOSString());
                    }
                } else if (answer == 1 && (paths = DialogSelectionHelper.chooseFileEntries(CodeGenerationSettingsTab.this.getShell(), reverseEngineeringSettingsFile, new IPath[0], "Select reverse engineering settings file", "Choose file from which settings for the reverse engineering will be read", new String[]{"reveng.xml"}, false, false, true)) != null && paths.length == 1) {
                    CodeGenerationSettingsTab.this.reverseEngineeringSettings.setText(paths[0].toOSString());
                }
            }
        });
        this.reverseEngineeringSettings.setDialogFieldListener(fieldlistener);
        this.reverseEngineeringSettings.setLabelText("reveng.&xml:");
        this.reverseEngineeringSettings.setButtonLabel("&Setup...");
        this.reverseengineer = new SelectionButtonDialogField(32);
        this.reverseengineer.setLabelText("Reverse engineer from JDBC Connection");
        this.reverseengineer.setDialogFieldListener(fieldlistener);
        this.useOwnTemplates = new SelectionButtonDialogField(32);
        this.useOwnTemplates.setDialogFieldListener(fieldlistener);
        this.useOwnTemplates.setLabelText("Use custom templates (for custom file generation)");
        this.preferRawCompositeIds = new SelectionButtonDialogField(32);
        this.preferRawCompositeIds.setLabelText("Generate basic typed composite ids");
        this.preferRawCompositeIds.setSelection(true);
        this.preferRawCompositeIds.setDialogFieldListener(fieldlistener);
        this.autoManyToMany = new SelectionButtonDialogField(32);
        this.autoManyToMany.setLabelText("Detect many-to-many tables");
        this.autoManyToMany.setSelection(true);
        this.autoManyToMany.setDialogFieldListener(fieldlistener);
        this.autoVersioning = new SelectionButtonDialogField(32);
        this.autoVersioning.setLabelText("Detect optimistic lock columns");
        this.autoVersioning.setSelection(true);
        this.autoVersioning.setDialogFieldListener(fieldlistener);
        this.useOwnTemplates.attachDialogField((DialogField)this.templatedir);
        this.reverseengineer.attachDialogFields(new DialogField[]{this.packageName, this.preferRawCompositeIds, this.reverseEngineeringSettings, this.reverseEngineeringStrategy, this.autoManyToMany, this.autoVersioning});
        this.consoleConfigurationName.doFillIntoGrid(container, 4);
        Control[] controls = this.outputdir.doFillIntoGrid(container, 4);
        ((GridData)controls[1].getLayoutData()).grabExcessHorizontalSpace = true;
        this.reverseengineer.doFillIntoGrid(container, 4);
        this.packageName.doFillIntoGrid(container, 4);
        this.reverseEngineeringSettings.doFillIntoGrid(container, 4);
        this.reverseEngineeringStrategy.doFillIntoGrid(container, 4);
        this.fillLabel(container);
        this.preferRawCompositeIds.doFillIntoGrid(container, 3);
        this.fillLabel(container);
        this.autoVersioning.doFillIntoGrid(container, 3);
        this.fillLabel(container);
        this.autoManyToMany.doFillIntoGrid(container, 3);
        this.useOwnTemplates.doFillIntoGrid(container, 4);
        controls = this.templatedir.doFillIntoGrid(container, 4);
        ((GridData)controls[1].getLayoutData()).grabExcessHorizontalSpace = true;
        this.dialogChanged();
        this.setControl((Control)container);
    }

    private void fillLabel(Composite container) {
        new Label(container, 0);
    }

    private void dialogChanged() {
        IStatus val;
        boolean configSelected = this.getConfigurationName().length() == 0;
        this.outputdir.setEnabled(!configSelected);
        this.reverseengineer.setEnabled(!configSelected);
        this.useOwnTemplates.setEnabled(!configSelected);
        if (configSelected) {
            this.updateStatus("Console configuration must be specified");
            return;
        }
        String msg = PathHelper.checkDirectory(this.outputdir.getText(), "Output directory", false);
        if (msg != null) {
            this.updateStatus(msg);
            return;
        }
        if (this.packageName.isEnabled() && this.getOutputPackage().length() > 0 && ((val = JavaConventions.validatePackageName((String)this.getOutputPackage())).getSeverity() == 4 || val.getSeverity() == 2)) {
            this.updateStatus(val.getMessage());
            return;
        }
        if (this.reverseEngineeringSettings.getText().trim().length() > 0 && (msg = this.checkFile(this.getReverseEngineeringSettingsFile(), "reveng.xml")) != null) {
            this.updateStatus(msg);
            return;
        }
        if (this.useOwnTemplates.isSelected()) {
            msg = PathHelper.checkDirectory(this.templatedir.getText(), "template directory", true);
            if (msg != null) {
                this.updateStatus(msg);
                return;
            }
        } else {
            this.setMessage(null);
        }
        this.updateStatus(null);
    }

    protected String checkFile(IPath path, String name) {
        IResource res = ResourcesPlugin.getWorkspace().getRoot().findMember(path);
        if (res != null) {
            int resType = res.getType();
            if (resType == 1) {
                return null;
            }
            return String.valueOf(name) + " must be a file";
        }
        return String.valueOf(name) + " does not exist";
    }

    private void updateStatus(String message) {
        this.setErrorMessage(message);
        this.updateLaunchConfigurationDialog();
    }

    public String getConfigurationName() {
        return this.consoleConfigurationName.getText();
    }

    public boolean isReverseEngineerEnabled() {
        return this.reverseengineer.isSelected();
    }

    private String resolve(String expression) {
        if (expression == null) {
            return null;
        }
        IStringVariableManager variableManager = VariablesPlugin.getDefault().getStringVariableManager();
        try {
            return variableManager.performStringSubstitution(expression, false);
        }
        catch (CoreException coreException) {
            return expression;
        }
    }

    String getOutputPackage() {
        return this.packageName.getText();
    }

    private IPath getReverseEngineeringSettingsFile() {
        return PathHelper.pathOrNull(this.reverseEngineeringSettings.getText());
    }

    private String getReverseEngineeringStrategy() {
        return this.reverseEngineeringStrategy.getText();
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        try {
            ExporterAttributes attributes = new ExporterAttributes(configuration);
            this.consoleConfigurationName.setText(attributes.getConsoleConfigurationName());
            this.preferRawCompositeIds.setSelection(attributes.isPreferBasicCompositeIds());
            this.autoManyToMany.setSelection(attributes.detectManyToMany());
            this.autoVersioning.setSelection(attributes.detectOptimisticLock());
            this.outputdir.setText(this.safeText(attributes.getOutputPath()));
            this.reverseengineer.setSelection(attributes.isReverseEngineer());
            this.reverseEngineeringSettings.setText(this.safeText(attributes.getRevengSettings()));
            this.reverseEngineeringStrategy.setText(this.safeText(attributes.getRevengStrategy()));
            this.useOwnTemplates.setSelection(attributes.isUseOwnTemplates());
            this.packageName.setText(this.safeText(attributes.getPackageName()));
            this.templatedir.setText(this.safeText(attributes.getTemplatePath()));
        }
        catch (CoreException ce) {
            HibernateConsolePlugin.getDefault().logErrorMessage("Problem when reading hibernate tools launch configuration", ce);
        }
    }

    private String safeText(String text) {
        return text == null ? "" : text;
    }

    private String strOrNull(String text) {
        if (text == null || text.trim().length() == 0) {
            return null;
        }
        return text;
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("org.hibernate.tools.outputdir", this.strOrNull(this.outputdir.getText()));
        configuration.setAttribute("org.hibernate.tools.prefercompositeids", this.preferRawCompositeIds.isSelected());
        configuration.setAttribute("org.hibernate.tools.reveng.detect_many_to_many", this.autoManyToMany.isSelected());
        configuration.setAttribute("org.hibernate.tools.reveng.detect_optimistc_lock", this.autoVersioning.isSelected());
        configuration.setAttribute("org.hibernate.tools.schema2hbm", this.isReverseEngineerEnabled());
        configuration.setAttribute("org.hibernate.tools.revengstrategy", this.strOrNull(this.reverseEngineeringStrategy.getText()));
        configuration.setAttribute("org.hibernate.tools.revengfile", this.strOrNull(this.reverseEngineeringSettings.getText()));
        configuration.setAttribute("org.hibernate.tools.useOwnTemplates", this.useOwnTemplates.isSelected());
        configuration.setAttribute("org.hibernate.tools.templatepath", this.strOrNull(this.templatedir.getText()));
        configuration.setAttribute("org.hibernate.tools.configurationname", this.getConfigurationName());
        configuration.setAttribute("org.hibernate.tools.package", this.getOutputPackage());
    }

    public String getName() {
        return "Main";
    }

    public Image getImage() {
        return EclipseImages.getImage("images/hicon.gif");
    }
}

