/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.eclipse.launch;

import java.io.File;
import java.lang.reflect.Constructor;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.IFileBufferManager;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.manipulation.FileBufferOperationRunner;
import org.eclipse.core.filebuffers.manipulation.IFileBufferOperation;
import org.eclipse.core.filebuffers.manipulation.MultiTextEditWithProgress;
import org.eclipse.core.filebuffers.manipulation.TextFileBufferOperation;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.LaunchConfigurationDelegate;
import org.eclipse.debug.ui.RefreshTab;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.ToolFactory;
import org.eclipse.jdt.core.formatter.CodeFormatter;
import org.eclipse.jface.text.DocumentRewriteSessionType;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.util.Assert;
import org.eclipse.text.edits.TextEdit;
import org.hibernate.HibernateException;
import org.hibernate.cfg.Configuration;
import org.hibernate.cfg.JDBCMetaDataConfiguration;
import org.hibernate.cfg.reveng.DefaultReverseEngineeringStrategy;
import org.hibernate.cfg.reveng.OverrideRepository;
import org.hibernate.cfg.reveng.ReverseEngineeringSettings;
import org.hibernate.cfg.reveng.ReverseEngineeringStrategy;
import org.hibernate.console.ConsoleConfiguration;
import org.hibernate.console.HibernateConsoleRuntimeException;
import org.hibernate.console.KnownConfigurations;
import org.hibernate.console.execution.ExecutionContext;
import org.hibernate.eclipse.console.HibernateConsolePlugin;
import org.hibernate.eclipse.console.model.impl.ExporterFactory;
import org.hibernate.eclipse.launch.ExporterAttributes;
import org.hibernate.eclipse.launch.PathHelper;
import org.hibernate.tool.hbm2x.ArtifactCollector;
import org.hibernate.tool.hbm2x.Exporter;
import org.hibernate.util.ReflectHelper;
import org.hibernate.util.StringHelper;

public class CodeGenerationLaunchDelegate
extends LaunchConfigurationDelegate {
    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        Assert.isNotNull((Object)configuration);
        Assert.isNotNull((Object)monitor);
        try {
            try {
                ExporterAttributes attributes = new ExporterAttributes(configuration);
                List exporterFactories = attributes.getExporterFactories();
                Iterator iter = exporterFactories.iterator();
                while (iter.hasNext()) {
                    ExporterFactory exFactory = (ExporterFactory)iter.next();
                    if (exFactory.isEnabled(configuration)) continue;
                    iter.remove();
                }
                HashSet outputDirectories = new HashSet();
                ExporterFactory[] exporters = exporterFactories.toArray(new ExporterFactory[exporterFactories.size()]);
                ArtifactCollector collector = this.runExporters(attributes, exporters, outputDirectories, monitor);
                for (String path : outputDirectories) {
                    this.refreshOutputDir(path);
                }
                RefreshTab.refreshResources((ILaunchConfiguration)configuration, (IProgressMonitor)monitor);
                if (collector != null) {
                    this.formatGeneratedCode(monitor, collector);
                }
            }
            catch (Exception e) {
                throw new CoreException(HibernateConsolePlugin.throwableToStatus(e, 666));
            }
            catch (NoClassDefFoundError e) {
                throw new CoreException(HibernateConsolePlugin.throwableToStatus(new HibernateConsoleRuntimeException("Received a NoClassDefFoundError, probably the console configuration classpath is incomplete or contains conflicting versions of the same class", (Throwable)e), 666));
            }
        }
        finally {
            monitor.done();
        }
    }

    private void formatGeneratedCode(IProgressMonitor monitor, ArtifactCollector collector) {
        FormatGeneratedCode operation = new FormatGeneratedCode("Formate generated code");
        File[] javaFiles = collector.getFiles("java");
        if (javaFiles.length > 0) {
            IPath[] locations = new IPath[javaFiles.length];
            int i = 0;
            while (i < javaFiles.length) {
                File file = javaFiles[i];
                locations[i] = new Path(file.getPath());
                ++i;
            }
            FileBufferOperationRunner runner = new FileBufferOperationRunner((IFileBufferManager)FileBuffers.getTextFileBufferManager(), (Object)HibernateConsolePlugin.getShell());
            try {
                runner.execute(locations, (IFileBufferOperation)operation, monitor);
            }
            catch (OperationCanceledException e) {
                HibernateConsolePlugin.getDefault().logErrorMessage("java format cancelled", e);
            }
            catch (CoreException e) {
                HibernateConsolePlugin.getDefault().logErrorMessage("exception during java format", e);
            }
            catch (Throwable e) {
                HibernateConsolePlugin.getDefault().logErrorMessage("exception during java format", e);
            }
        }
    }

    private void refreshOutputDir(String outputdir) {
        IResource bufferRes = PathHelper.findMember(ResourcesPlugin.getWorkspace().getRoot(), outputdir);
        if (bufferRes != null && bufferRes.isAccessible()) {
            try {
                bufferRes.refreshLocal(2, null);
            }
            catch (CoreException coreException) {}
        }
    }

    private ArtifactCollector runExporters(final ExporterAttributes attributes, final ExporterFactory[] exporterFactories, final Set outputDirectories, final IProgressMonitor monitor) throws CoreException {
        monitor.beginTask("Generating code for " + attributes.getConsoleConfigurationName(), exporterFactories.length + 1);
        if (monitor.isCanceled()) {
            return null;
        }
        ConsoleConfiguration cc = KnownConfigurations.getInstance().find(attributes.getConsoleConfigurationName());
        if (attributes.isReverseEngineer()) {
            monitor.subTask("reading jdbc metadata");
        }
        final Configuration cfg = this.buildConfiguration(attributes, cc, ResourcesPlugin.getWorkspace().getRoot());
        monitor.worked(1);
        if (monitor.isCanceled()) {
            return null;
        }
        return (ArtifactCollector)cc.execute(new ExecutionContext.Command(){

            public Object execute() {
                ArtifactCollector artifactCollector = new ArtifactCollector();
                Properties props = new Properties();
                props.put("ejb3", "" + attributes.isEJB3Enabled());
                props.put("jdk5", "" + attributes.isJDK5Enabled());
                int i = 0;
                while (i < exporterFactories.length) {
                    Exporter exporter;
                    monitor.subTask(exporterFactories[i].getExporterDefinition().getDescription());
                    Properties globalProperties = new Properties();
                    globalProperties.putAll((Map<?, ?>)props);
                    try {
                        exporter = exporterFactories[i].createConfiguredExporter(cfg, attributes.getOutputPath(), attributes.getTemplatePath(), globalProperties, outputDirectories, artifactCollector);
                    }
                    catch (CoreException e) {
                        throw new HibernateConsoleRuntimeException("Error while setting up " + exporterFactories[i].getExporterDefinition(), (Throwable)e);
                    }
                    try {
                        exporter.start();
                    }
                    catch (HibernateException he) {
                        throw new HibernateConsoleRuntimeException("Error while running  " + exporterFactories[i].getExporterDefinition().getDescription(), (Throwable)he);
                    }
                    monitor.worked(1);
                    ++i;
                }
                return artifactCollector;
            }
        });
    }

    private Configuration buildConfiguration(final ExporterAttributes attributes, ConsoleConfiguration cc, IWorkspaceRoot root) {
        boolean reveng = attributes.isReverseEngineer();
        final String reverseEngineeringStrategy = attributes.getRevengStrategy();
        boolean preferBasicCompositeids = attributes.isPreferBasicCompositeIds();
        final IResource revengres = PathHelper.findMember(root, attributes.getRevengSettings());
        if (reveng) {
            Configuration configuration = null;
            configuration = cc.hasConfiguration() ? cc.getConfiguration() : cc.buildWith(null, false);
            final JDBCMetaDataConfiguration cfg = new JDBCMetaDataConfiguration();
            Properties properties = configuration.getProperties();
            cfg.setProperties(properties);
            cc.buildWith((Configuration)cfg, false);
            cfg.setPreferBasicCompositeIds(preferBasicCompositeids);
            cc.execute(new ExecutionContext.Command(){

                public Object execute() {
                    DefaultReverseEngineeringStrategy configurableNamingStrategy;
                    DefaultReverseEngineeringStrategy res = configurableNamingStrategy = new DefaultReverseEngineeringStrategy();
                    if (revengres != null) {
                        File file = PathHelper.getLocation(revengres).toFile();
                        OverrideRepository repository = new OverrideRepository();
                        repository.addFile(file);
                        res = repository.getReverseEngineeringStrategy((ReverseEngineeringStrategy)res);
                    }
                    if (reverseEngineeringStrategy != null && reverseEngineeringStrategy.trim().length() > 0) {
                        res = CodeGenerationLaunchDelegate.this.loadreverseEngineeringStrategy(reverseEngineeringStrategy, (ReverseEngineeringStrategy)res);
                    }
                    ReverseEngineeringSettings qqsettings = new ReverseEngineeringSettings((ReverseEngineeringStrategy)res).setDefaultPackageName(attributes.getPackageName()).setDetectManyToMany(attributes.detectManyToMany()).setDetectOptimisticLock(attributes.detectOptimisticLock());
                    configurableNamingStrategy.setSettings(qqsettings);
                    res.setSettings(qqsettings);
                    cfg.setReverseEngineeringStrategy((ReverseEngineeringStrategy)res);
                    cfg.readFromJDBC();
                    cfg.buildMappings();
                    return null;
                }
            });
            return cfg;
        }
        cc.build();
        final Configuration configuration = cc.getConfiguration();
        cc.execute(new ExecutionContext.Command(){

            public Object execute() {
                configuration.buildMappings();
                return configuration;
            }
        });
        return configuration;
    }

    private ReverseEngineeringStrategy loadreverseEngineeringStrategy(String className, ReverseEngineeringStrategy delegate) {
        try {
            Class clazz = ReflectHelper.classForName((String)className);
            Constructor constructor = clazz.getConstructor(ReverseEngineeringStrategy.class);
            return (ReverseEngineeringStrategy)constructor.newInstance(delegate);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            try {
                Class clazz = ReflectHelper.classForName((String)className);
                ReverseEngineeringStrategy rev = (ReverseEngineeringStrategy)clazz.newInstance();
                return rev;
            }
            catch (Exception eq) {
                throw new HibernateConsoleRuntimeException("Could not create or find " + className + " with default no-arg constructor", (Throwable)eq);
            }
        }
        catch (Exception e) {
            throw new HibernateConsoleRuntimeException("Could not create or find " + className + " with one argument delegate constructor", (Throwable)e);
        }
    }

    public boolean preLaunchCheck(ILaunchConfiguration configuration, String mode, IProgressMonitor monitor) throws CoreException {
        ExporterAttributes attributes = new ExporterAttributes(configuration);
        String configName = attributes.getConsoleConfigurationName();
        if (StringHelper.isEmpty((String)configName)) {
            this.abort("Console configuration name is empty in " + configuration.getName(), null, 1000);
        }
        if (KnownConfigurations.getInstance().find(configName) == null) {
            this.abort("Console configuration " + configName + " not found in " + configuration.getName(), null, 1001);
        }
        if (StringHelper.isEmpty((String)attributes.getOutputPath())) {
            this.abort("Output has to be specified in " + configuration.getName(), null, 1002);
        }
        return super.preLaunchCheck(configuration, mode, monitor);
    }

    protected void abort(String message, Throwable exception, int code) throws CoreException {
        HibernateConsolePlugin.getDefault();
        throw new CoreException((IStatus)new Status(4, "org.hibernate.eclipse.console", code, message, exception));
    }

    private static final class FormatGeneratedCode
    extends TextFileBufferOperation {
        private FormatGeneratedCode(String name) {
            super(name);
        }

        protected DocumentRewriteSessionType getDocumentRewriteSessionType() {
            return DocumentRewriteSessionType.SEQUENTIAL;
        }

        protected MultiTextEditWithProgress computeTextEdit(ITextFileBuffer textFileBuffer, IProgressMonitor progressMonitor) throws CoreException, OperationCanceledException {
            IResource bufferRes = ResourcesPlugin.getWorkspace().getRoot().findMember(textFileBuffer.getLocation());
            Map options = null;
            if (bufferRes != null) {
                IJavaProject project = JavaCore.create((IProject)bufferRes.getProject());
                options = project.getOptions(true);
            }
            CodeFormatter codeFormatter = ToolFactory.createCodeFormatter(options);
            IDocument document = textFileBuffer.getDocument();
            String string = document.get();
            TextEdit edit = codeFormatter.format(8, string, 0, string.length(), 0, null);
            MultiTextEditWithProgress multiTextEditWithProgress = new MultiTextEditWithProgress(this.getOperationName());
            if (edit != null) {
                multiTextEditWithProgress.addChild(edit);
            }
            return multiTextEditWithProgress;
        }
    }
}

