/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.eclipse.hqleditor;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.graphics.Image;
import org.hibernate.eclipse.console.utils.EclipseImages;
import org.hibernate.eclipse.console.workbench.HibernateWorkbenchHelper;
import org.hibernate.eclipse.hqleditor.CompletionProposal;
import org.hibernate.tool.ide.completion.HQLCompletionProposal;
import org.hibernate.tool.ide.completion.IHQLCompletionRequestor;
import org.hibernate.util.StringHelper;

public class EclipseHQLCompletionRequestor
implements IHQLCompletionRequestor {
    private final List result = new ArrayList();
    private String lastErrorMessage;
    private final int virtualOffset;

    public EclipseHQLCompletionRequestor() {
        this.virtualOffset = 0;
    }

    public EclipseHQLCompletionRequestor(int virtualOffset) {
        this.virtualOffset = virtualOffset;
    }

    public List getCompletionProposals() {
        return this.result;
    }

    public boolean accept(HQLCompletionProposal proposal) {
        this.result.add(new CompletionProposal(proposal.getCompletion(), proposal.getReplaceStart() + this.virtualOffset, proposal.getReplaceEnd() - proposal.getReplaceStart(), proposal.getCompletion().length(), this.getImage(proposal), this.getDisplayString(proposal), null, null));
        return true;
    }

    private String getDisplayString(HQLCompletionProposal proposal) {
        StringBuffer buf = new StringBuffer(proposal.getSimpleName());
        switch (proposal.getCompletionKind()) {
            case 1: {
                if (proposal.getEntityName() != null && !proposal.getSimpleName().equals(proposal.getEntityName())) {
                    buf.append(" - ");
                    buf.append(StringHelper.qualifier((String)proposal.getEntityName()));
                    break;
                }
                if (proposal.getShortEntityName() == null || proposal.getSimpleName().equals(proposal.getEntityName())) break;
                buf.append(" - " + proposal.getShortEntityName());
                break;
            }
            case 5: {
                if (proposal.getShortEntityName() != null) {
                    buf.append(" - " + proposal.getShortEntityName());
                    break;
                }
                if (proposal.getEntityName() == null) break;
                buf.append(" - " + proposal.getEntityName());
                break;
            }
            case 2: {
                if (proposal.getShortEntityName() != null) {
                    buf.append(" - " + proposal.getShortEntityName());
                    break;
                }
                if (proposal.getEntityName() == null) break;
                if (proposal.getEntityName().indexOf(".") >= 0) {
                    buf.append(" - " + StringHelper.unqualify((String)proposal.getEntityName()));
                    break;
                }
                buf.append(" - " + proposal.getEntityName());
                break;
            }
            case 3: {
                break;
            }
        }
        return buf.toString();
    }

    private Image getImage(HQLCompletionProposal proposal) {
        String key = null;
        switch (proposal.getCompletionKind()) {
            case 1: 
            case 5: {
                key = "MAPPEDCLASS";
                break;
            }
            case 2: {
                if (proposal.getProperty() != null) {
                    return HibernateWorkbenchHelper.getImage(proposal.getProperty());
                }
                key = "PROPERTY";
                break;
            }
            case 3: {
                key = null;
                break;
            }
            case 4: {
                key = "FUNCTION";
                break;
            }
            default: {
                key = null;
            }
        }
        return key == null ? null : EclipseImages.getImage(key);
    }

    public void completionFailure(String errorMessage) {
        this.lastErrorMessage = errorMessage;
    }

    public String getLastErrorMessage() {
        return this.lastErrorMessage;
    }

    public void clear() {
        this.result.clear();
        this.lastErrorMessage = null;
    }
}

