/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.eclipse.graph.parts;

import java.util.List;
import java.util.Observable;
import java.util.Observer;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.FreeformLayer;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.LineBorder;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.hibernate.eclipse.graph.layout.DelegatingLayoutManager;
import org.hibernate.eclipse.graph.layout.GraphXYLayout;
import org.hibernate.eclipse.graph.model.ConfigurationViewAdapter;
import org.hibernate.eclipse.graph.model.GraphNode;
import org.hibernate.eclipse.graph.parts.GraphNodeEditPart;
import org.hibernate.eclipse.graph.policy.ConfigurationLayoutEditPolicy;

public class ConfigurationEditPart
extends AbstractGraphicalEditPart
implements Observer {
    private DelegatingLayoutManager delegatingLayoutManager;
    private boolean manualLayoutActive = true;

    public void activate() {
        super.activate();
        this.getConfigurationViewAdapter().addObserver(this);
    }

    public void deactivate() {
        super.deactivate();
        this.getConfigurationViewAdapter().deleteObserver(this);
    }

    public ConfigurationEditPart(ConfigurationViewAdapter configuration) {
        this.setModel(configuration);
    }

    protected List getModelChildren() {
        if (this.getConfigurationViewAdapter() == null) {
            return super.getModelChildren();
        }
        return this.getConfigurationViewAdapter().getPersistentClasses();
    }

    protected IFigure createFigure() {
        FreeformLayer layer = new FreeformLayer();
        this.delegatingLayoutManager = new DelegatingLayoutManager(this);
        layer.setLayoutManager((LayoutManager)this.delegatingLayoutManager);
        layer.setBorder((Border)new LineBorder(1));
        return layer;
    }

    public ConfigurationViewAdapter getConfigurationViewAdapter() {
        return (ConfigurationViewAdapter)this.getModel();
    }

    protected void createEditPolicies() {
        this.installEditPolicy("LayoutEditPolicy", (EditPolicy)new ConfigurationLayoutEditPolicy());
    }

    public boolean resetFigureBounds(boolean updateConstraint) {
        List tableParts = this.getChildren();
        for (GraphicalEditPart nodePart : tableParts) {
            Rectangle bounds = nodePart.getFigure().getBounds();
            if (bounds == null) {
                return false;
            }
            Figure tableFigure = (Figure)nodePart.getFigure();
            if (tableFigure == null) {
                return false;
            }
            if (!updateConstraint) continue;
            this.delegatingLayoutManager.setXYLayoutConstraint((IFigure)tableFigure, new Rectangle(bounds.x, bounds.y, -1, -1));
        }
        return true;
    }

    public boolean resetModelBounds(GraphXYLayout layout) {
        List tableParts = this.getChildren();
        for (GraphNodeEditPart classPart : tableParts) {
            IFigure persistentClassFigure = classPart.getFigure();
            if (persistentClassFigure == null) continue;
            Rectangle bounds = persistentClassFigure.getBounds().getCopy();
            GraphNode node = classPart.getGraphNode();
            node.setBounds(bounds);
            if (layout == null) continue;
            layout.setConstraint(persistentClassFigure, bounds);
        }
        return true;
    }

    public void update(Observable o, Object arg) {
        this.getFigure().setLayoutManager((LayoutManager)this.delegatingLayoutManager);
        this.refresh();
    }

    public boolean isManualLayoutActive() {
        return this.manualLayoutActive;
    }

    public void setManualLayoutActive(boolean manualLayoutActive) {
        this.manualLayoutActive = manualLayoutActive;
        this.getFigure().setLayoutManager((LayoutManager)this.delegatingLayoutManager);
        this.refresh();
    }
}

