/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.eclipse.criteriaeditor;

import java.util.Arrays;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.CompletionContext;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.ui.text.java.CompletionProposalCollector;
import org.eclipse.jdt.ui.text.java.CompletionProposalComparator;
import org.eclipse.jdt.ui.text.java.IJavaCompletionProposal;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.eclipse.swt.widgets.Shell;
import org.hibernate.eclipse.console.HibernateConsolePlugin;
import org.hibernate.eclipse.console.utils.ProjectUtils;
import org.hibernate.eclipse.criteriaeditor.CriteriaEditor;
import org.hibernate.eclipse.hqleditor.CompletionHelper;
import org.hibernate.util.StringHelper;

public class JavaCompletionProcessor
implements IContentAssistProcessor {
    private CompletionProposalCollector collector;
    private CriteriaEditor editor;
    private CompletionProposalComparator comparator;
    private String lastErrorMessage;
    private char[] proposalAutoActivationSet;

    public JavaCompletionProcessor(CriteriaEditor editor) {
        this.editor = editor;
        this.comparator = new CompletionProposalComparator();
    }

    public String getErrorMessage() {
        return this.lastErrorMessage;
    }

    protected void setErrorMessage(String message) {
        if (StringHelper.isEmpty((String)message)) {
            message = null;
        }
        this.lastErrorMessage = message;
    }

    public IContextInformationValidator getContextInformationValidator() {
        return null;
    }

    public char[] getContextInformationAutoActivationCharacters() {
        return null;
    }

    public IContextInformation[] computeContextInformation(ITextViewer viewer, int offset) {
        return null;
    }

    public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int position) {
        try {
            this.setErrorMessage(null);
            if (this.editor.getConsoleConfiguration() == null) {
                this.setErrorMessage("No console configuration found");
                ICompletionProposal[] iCompletionProposalArray = new ICompletionProposal[]{};
                return iCompletionProposalArray;
            }
            String prefix = "Session session;";
            try {
                IJavaProject javaProject = ProjectUtils.findJavaProject(this.editor.getConsoleConfiguration());
                this.collector = new CompletionProposalCollector(javaProject);
                this.collector.acceptContext(new CompletionContext());
                this.editor.codeComplete(prefix, this.collector, position, javaProject);
            }
            catch (JavaModelException x) {
                Shell shell = viewer.getTextWidget().getShell();
                ErrorDialog.openError((Shell)shell, (String)"Error", (String)"Error while performing code completion", (IStatus)x.getStatus());
                HibernateConsolePlugin.getDefault().log(x);
            }
            IJavaCompletionProposal[] results = this.collector.getJavaCompletionProposals();
            Arrays.sort(results, this.comparator);
            CompletionHelper.transpose(null, -prefix.length(), results);
            IJavaCompletionProposal[] iJavaCompletionProposalArray = results;
            return iJavaCompletionProposalArray;
        }
        finally {
            if (this.collector != null) {
                this.setErrorMessage(this.collector.getErrorMessage());
                this.collector = null;
            }
        }
    }

    public char[] getCompletionProposalAutoActivationCharacters() {
        return this.proposalAutoActivationSet;
    }

    public void setCompletionProposalAutoActivationCharacters(char[] activationSet) {
        this.proposalAutoActivationSet = activationSet;
    }

    public void orderProposalsAlphabetically(boolean order) {
        this.comparator.setOrderAlphabetically(order);
    }
}

