/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.eclipse.console.workbench;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.util.HashMap;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource2;
import org.hibernate.eclipse.console.workbench.BeanPropertyDescriptor;

public class GenericPropertySource
implements IPropertySource2 {
    private final Object real;
    private IPropertyDescriptor[] descriptors;
    private HashMap map;

    public GenericPropertySource(Object real) {
        this.real = real;
        this.descriptors = this.buildPropertyDescriptors();
        this.map = new HashMap();
        int i = 0;
        while (i < this.descriptors.length) {
            IPropertyDescriptor desc = this.descriptors[i];
            this.map.put(desc.getId(), desc);
            ++i;
        }
    }

    public boolean isPropertyResettable(Object id) {
        return false;
    }

    public boolean isPropertySet(Object id) {
        return false;
    }

    public Object getEditableValue() {
        return this.real;
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        return this.descriptors;
    }

    private IPropertyDescriptor[] buildPropertyDescriptors() {
        if (this.real == null) {
            return new IPropertyDescriptor[0];
        }
        try {
            BeanInfo beanInfo = Introspector.getBeanInfo(this.real.getClass(), Object.class);
            PropertyDescriptor[] propertyDescriptors = beanInfo.getPropertyDescriptors();
            IPropertyDescriptor[] result = new IPropertyDescriptor[propertyDescriptors.length];
            int i = 0;
            while (i < propertyDescriptors.length) {
                PropertyDescriptor descriptor = propertyDescriptors[i];
                result[i] = new BeanPropertyDescriptor(descriptor);
                ++i;
            }
            return result;
        }
        catch (IntrospectionException introspectionException) {
            return new IPropertyDescriptor[0];
        }
    }

    public Object getPropertyValue(Object id) {
        BeanPropertyDescriptor desc = (BeanPropertyDescriptor)this.map.get(id);
        Object value = desc.getValue(this.real);
        return value;
    }

    public void resetPropertyValue(Object id) {
    }

    public void setPropertyValue(Object id, Object value) {
    }
}

