/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.eclipse.console.workbench;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.ui.progress.IDeferredWorkbenchAdapter;
import org.eclipse.ui.progress.IElementCollector;
import org.hibernate.eclipse.console.HibernateConsolePlugin;

public abstract class BasicWorkbenchAdapter
implements IDeferredWorkbenchAdapter {
    static final Object[] NO_CHILDREN = new Object[0];

    protected Object[] toArray(Iterator iterator, Class clazz, Comparator comparator) {
        List obj = this.toList(iterator);
        Object[] array = obj.toArray((Object[])Array.newInstance(clazz, obj.size()));
        if (comparator != null) {
            Arrays.sort(array, comparator);
        }
        return array;
    }

    private List toList(Iterator iterator) {
        ArrayList obj = new ArrayList();
        while (iterator.hasNext()) {
            obj.add(iterator.next());
        }
        return obj;
    }

    protected Object[] toArray(Enumeration enumeration, Class clazz) {
        ArrayList obj = new ArrayList();
        while (enumeration.hasMoreElements()) {
            obj.add(enumeration.nextElement());
        }
        return obj.toArray((Object[])Array.newInstance(clazz, obj.size()));
    }

    public Object[] getChildren(Object o, IProgressMonitor monitor) {
        return this.getChildren(o);
    }

    public void fetchDeferredChildren(Object object, IElementCollector collector, IProgressMonitor monitor) {
        try {
            try {
                collector.add(this.getChildren(object, monitor), monitor);
                collector.done();
            }
            catch (Exception e) {
                this.handleError(collector, object, e);
                collector.done();
                monitor.done();
            }
        }
        finally {
            collector.done();
            monitor.done();
        }
    }

    protected void handleError(IElementCollector collector, Object object, Exception e) {
        HibernateConsolePlugin.getDefault().logMessage(2, e.toString(), e);
        HibernateConsolePlugin.openError(null, this.getDefaultErrorTitle(), this.getDefaultErrorMessage(object), e, 1);
    }

    private String getDefaultErrorMessage(Object object) {
        return "Error while expanding " + this.getLabel(object);
    }

    private String getDefaultErrorTitle() {
        return "Hibernate Configuration error";
    }

    public boolean isContainer() {
        return true;
    }

    public final ISchedulingRule getRule(Object object) {
        return null;
    }

    static class MutexRule
    implements ISchedulingRule {
        private final Object mutex;

        public MutexRule(Object mutex) {
            this.mutex = mutex;
        }

        public boolean contains(ISchedulingRule rule) {
            if (rule instanceof MutexRule) {
                return this.mutex == ((MutexRule)rule).mutex;
            }
            return false;
        }

        public boolean isConflicting(ISchedulingRule rule) {
            if (rule instanceof MutexRule) {
                return this.mutex == ((MutexRule)rule).mutex;
            }
            return false;
        }
    }
}

