/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.eclipse.console.wizards;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.ComboDialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.hibernate.console.ConsoleConfiguration;
import org.hibernate.console.KnownConfigurations;
import org.hibernate.eclipse.console.model.ITableFilter;
import org.hibernate.eclipse.console.model.impl.ReverseEngineeringDefinitionImpl;
import org.hibernate.eclipse.console.wizards.TableFilterView;
import org.hibernate.eclipse.console.wizards.TreeToTableComposite;

public class TableFilterWizardPage
extends WizardPage {
    ComboDialogField consoleConfigurationName;
    private TableFilterView tfc;
    private final String selectedConfiguratonName;

    protected TableFilterWizardPage(String pageName, String selectedConfiguratonName) {
        super(pageName);
        this.selectedConfiguratonName = selectedConfiguratonName;
        this.setTitle("Configure Table filters");
        this.setDescription("Specify which catalog/schema/tables should be included or excluded from the reverse engineering.");
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        container.setLayout((Layout)layout);
        layout.numColumns = 3;
        layout.verticalSpacing = 10;
        this.consoleConfigurationName = new ComboDialogField(8);
        this.consoleConfigurationName.setLabelText("Console &configuration:");
        ConsoleConfiguration[] cfg = KnownConfigurations.getInstance().getConfigurationsSortedByName();
        String[] names = new String[cfg.length];
        int i = 0;
        while (i < cfg.length) {
            ConsoleConfiguration configuration = cfg[i];
            names[i] = configuration.getName();
            ++i;
        }
        this.consoleConfigurationName.setItems(names);
        this.consoleConfigurationName.doFillIntoGrid(container, 3);
        IDialogFieldListener fieldlistener = new IDialogFieldListener(){

            public void dialogFieldChanged(DialogField field) {
                TableFilterWizardPage.this.dialogChanged();
            }
        };
        this.consoleConfigurationName.setDialogFieldListener(fieldlistener);
        TreeToTableComposite tfc = this.createTableFilterPart(container);
        GridData gd = new GridData(4, 4, true, true);
        gd.horizontalSpan = 3;
        tfc.setLayoutData(gd);
        this.setControl((Control)container);
        if (this.selectedConfiguratonName != null) {
            this.consoleConfigurationName.setText(this.selectedConfiguratonName);
        }
        this.dialogChanged();
    }

    private void updateWarningStatus(String message) {
        this.setMessage(message, 2);
    }

    private void dialogChanged() {
        if (this.hasDuplicates()) {
            this.updateWarningStatus("Table filters contains duplicates.");
            return;
        }
        this.updateWarningStatus(null);
    }

    protected boolean hasDuplicates() {
        boolean res = false;
        ITableFilter[] filters = this.getTableFilters();
        int i = 1;
        while (i < filters.length) {
            int j = 0;
            while (j < i) {
                if (filters[i].getExclude().equals(filters[j].getExclude()) && filters[i].getMatchCatalog().equals(filters[j].getMatchCatalog()) && filters[i].getMatchSchema().equals(filters[j].getMatchSchema()) && filters[i].getMatchName().equals(filters[j].getMatchName())) {
                    res = true;
                    break;
                }
                ++j;
            }
            ++i;
        }
        return res;
    }

    private TreeToTableComposite createTableFilterPart(Composite container) {
        this.tfc = new TableFilterView(container, 0){

            protected String getConsoleConfigurationName() {
                return TableFilterWizardPage.this.consoleConfigurationName.getText();
            }
        };
        ReverseEngineeringDefinitionImpl model = new ReverseEngineeringDefinitionImpl();
        model.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                TableFilterWizardPage.this.dialogChanged();
            }
        });
        this.tfc.setModel(model);
        return this.tfc;
    }

    public ITableFilter[] getTableFilters() {
        return this.tfc.getTableFilterList();
    }
}

