/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.eclipse.console.wizards;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.util.Properties;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.WizardNewFileCreationPage;
import org.eclipse.ui.ide.IDE;
import org.hibernate.eclipse.console.HibernateConsolePlugin;
import org.hibernate.eclipse.console.model.ITableFilter;
import org.hibernate.eclipse.console.utils.EclipseImages;
import org.hibernate.eclipse.console.wizards.TableFilterWizardPage;

public class NewReverseEngineeringFileWizard
extends Wizard
implements INewWizard {
    private IStructuredSelection selection;
    private WizardNewFileCreationPage cPage;
    private TableFilterWizardPage tableFilterWizardPage;
    private IPath createdFile;
    private String selectedConfiguratonName;

    public NewReverseEngineeringFileWizard() {
        this.setDefaultPageImageDescriptor(EclipseImages.getImageDescriptor("NEW_WIZARD"));
        this.setNeedsProgressMonitor(true);
    }

    public void addPages() {
        this.cPage = new ExtendedWizardNewFileCreationPage("Ccfgxml", this.selection);
        this.cPage.setTitle("Create Hibernate Reverse Engineering file (reveng.xml)");
        this.cPage.setDescription("Create a new hibernate.reveng.xml.");
        this.cPage.setFileName("hibernate.reveng.xml");
        this.addPage((IWizardPage)this.cPage);
        this.tableFilterWizardPage = new TableFilterWizardPage("revengtable", this.selectedConfiguratonName);
        this.addPage((IWizardPage)this.tableFilterWizardPage);
    }

    public boolean performFinish() {
        this.createdFile = this.cPage.getContainerFullPath().append(this.cPage.getFileName());
        final IFile file = this.cPage.createNewFile();
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException {
                try {
                    try {
                        NewReverseEngineeringFileWizard.this.doFinish(file, monitor);
                    }
                    catch (CoreException e) {
                        throw new InvocationTargetException(e);
                    }
                }
                finally {
                    monitor.done();
                }
            }
        };
        try {
            this.getContainer().run(true, false, op);
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        catch (InvocationTargetException e) {
            Throwable realException = e.getTargetException();
            HibernateConsolePlugin.getDefault().showError(this.getShell(), "Error", realException);
            return false;
        }
        return true;
    }

    private void putIfNotNull(Properties props, String key, String value) {
        if (value != null) {
            props.put(key, value);
        }
    }

    private void doFinish(final IFile file, IProgressMonitor monitor) throws CoreException {
        monitor.beginTask("Creating " + file.getName(), 2);
        try {
            InputStream stream = this.openContentStream();
            if (file.exists()) {
                file.setContents(stream, true, true, monitor);
            } else {
                file.create(stream, true, monitor);
            }
            stream.close();
        }
        catch (IOException iOException) {}
        monitor.worked(1);
        monitor.setTaskName("Opening file for editing...");
        this.getShell().getDisplay().asyncExec(new Runnable(){

            public void run() {
                IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                try {
                    IDE.openEditor((IWorkbenchPage)page, (IFile)file, (boolean)true);
                }
                catch (PartInitException partInitException) {}
            }
        });
        monitor.worked(1);
    }

    private InputStream openContentStream() {
        StringWriter sw = new StringWriter();
        sw.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<!DOCTYPE hibernate-reverse-engineering PUBLIC \"-//Hibernate/Hibernate Reverse Engineering DTD 3.0//EN\" \"http://hibernate.sourceforge.net/hibernate-reverse-engineering-3.0.dtd\" >\r\n\r\n<hibernate-reverse-engineering>\r\n");
        ITableFilter[] filters = this.tableFilterWizardPage.getTableFilters();
        int i = 0;
        while (i < filters.length) {
            ITableFilter filter = filters[i];
            sw.write("  <table-filter");
            if (!".*".equals(filter.getMatchCatalog())) {
                sw.write(" match-catalog=\"" + filter.getMatchCatalog() + "\"");
            }
            if (!".*".equals(filter.getMatchSchema())) {
                sw.write(" match-schema=\"" + filter.getMatchSchema() + "\"");
            }
            sw.write(" match-name=\"" + filter.getMatchName() + "\"");
            if (filter.getExclude().booleanValue()) {
                sw.write(" exclude=\"" + filter.getExclude() + "\"");
            }
            sw.write("/>\r\n");
            ++i;
        }
        sw.write("</hibernate-reverse-engineering>");
        try {
            return new ByteArrayInputStream(sw.toString().getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException uec) {
            HibernateConsolePlugin.getDefault().logErrorMessage("Problems converting to UTF-8", uec);
            return new ByteArrayInputStream(sw.toString().getBytes());
        }
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.selection = selection;
    }

    public IPath getCreatedFilePath() {
        return this.createdFile;
    }

    public void setSelectConfiguration(String configurationName) {
        this.selectedConfiguratonName = configurationName;
    }

    static class ExtendedWizardNewFileCreationPage
    extends WizardNewFileCreationPage {
        boolean firstTime = true;

        public ExtendedWizardNewFileCreationPage(String pageName, IStructuredSelection selection) {
            super(pageName, selection);
            this.setContainerFullPath((IPath)new Path("/"));
        }

        public void setVisible(boolean visible) {
            super.setVisible(visible);
            if (this.firstTime) {
                this.validatePage();
                this.firstTime = false;
            }
        }
    }
}

