/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.eclipse.console.wizards;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ContainerSelectionDialog;
import org.eclipse.ui.dialogs.SelectionDialog;
import org.eclipse.ui.dialogs.WizardNewFileCreationPage;
import org.hibernate.eclipse.console.HibernateConsolePlugin;
import org.hibernate.eclipse.console.utils.xpl.SelectionHelper;

public class NewHibernateMappingFilePage
extends WizardPage {
    private Label containerText;
    private Label fileText;
    private ISelection selection;
    private Text classToMap;
    private WizardNewFileCreationPage fileCreation;
    private boolean beenShown;

    public NewHibernateMappingFilePage(ISelection selection, WizardNewFileCreationPage page) {
        super("wizardPage");
        this.fileCreation = page;
        this.setTitle("Hibernate XML Mapping file");
        this.setDescription("This wizard creates a new Hibernate XML Mapping file");
        this.selection = selection;
    }

    public void setVisible(boolean visible) {
        this.containerText.setText(this.fileCreation.getContainerFullPath().toPortableString());
        this.fileText.setText(this.fileCreation.getFileName());
        super.setVisible(visible);
        if (visible) {
            this.classToMap.setFocus();
        }
        this.beenShown = true;
        this.dialogChanged();
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        container.setLayout((Layout)layout);
        layout.numColumns = 3;
        layout.verticalSpacing = 9;
        Label label = new Label(container, 0);
        label.setText("&Container:");
        this.containerText = new Label(container, 2052);
        GridData gd = new GridData(768);
        this.containerText.setLayoutData((Object)gd);
        label = new Label(container, 0);
        label.setText("");
        label = new Label(container, 0);
        label.setText("&File name:");
        this.fileText = new Label(container, 2052);
        gd = new GridData(768);
        this.fileText.setLayoutData((Object)gd);
        label = new Label(container, 0);
        label.setText("");
        label = new Label(container, 0);
        label.setText("Class to &map:");
        this.classToMap = new Text(container, 2052);
        gd = new GridData(768);
        this.classToMap.setLayoutData((Object)gd);
        this.classToMap.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewHibernateMappingFilePage.this.dialogChanged();
            }
        });
        Button button = new Button(container, 8);
        button.setText("Browse...");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NewHibernateMappingFilePage.this.handleClassToMapBrowse();
            }
        });
        this.initialize();
        this.dialogChanged();
        this.setControl((Control)container);
    }

    private void initialize() {
        IType initialJavaElement = SelectionHelper.getClassFromElement(SelectionHelper.getInitialJavaElement(this.selection));
        if (initialJavaElement != null) {
            this.classToMap.setText(initialJavaElement.getFullyQualifiedName('.'));
        }
    }

    private void handleBrowse() {
        Object[] result;
        ContainerSelectionDialog dialog = new ContainerSelectionDialog(this.getShell(), (IContainer)ResourcesPlugin.getWorkspace().getRoot(), false, "Select new file container");
        if (dialog.open() == 0 && (result = dialog.getResult()).length == 1) {
            this.containerText.setText(((Path)result[0]).toString());
        }
    }

    private void handleClassToMapBrowse() {
        IType type = this.findClassToMap();
        if (type != null) {
            this.classToMap.setText(type.getFullyQualifiedName('.'));
        }
    }

    IType findClassToMap() {
        IJavaProject root = this.getRootJavaProject();
        if (root == null) {
            return null;
        }
        IJavaElement[] elements = new IJavaElement[]{root};
        IJavaSearchScope scope = SearchEngine.createJavaSearchScope((IJavaElement[])elements);
        try {
            Object[] resultArray;
            SelectionDialog dialog = JavaUI.createTypeDialog((Shell)this.getShell(), (IRunnableContext)this.getWizard().getContainer(), (IJavaSearchScope)scope, (int)2, (boolean)false, (String)this.getClassToMapText());
            dialog.setTitle("Select class to map");
            dialog.setMessage("The class will be used when generating the hbm.xml file");
            if (dialog.open() == 0 && (resultArray = dialog.getResult()) != null && resultArray.length > 0) {
                return (IType)resultArray[0];
            }
        }
        catch (JavaModelException e) {
            HibernateConsolePlugin.getDefault().log(e);
        }
        return null;
    }

    private IJavaProject getRootJavaProject() {
        IResource resource = ResourcesPlugin.getWorkspace().getRoot().findMember(this.containerText.getText());
        if (resource != null && resource.getProject() != null) {
            IJavaProject project = JavaCore.create((IProject)resource.getProject());
            return project;
        }
        return null;
    }

    String getClassToMapText() {
        return this.classToMap.getText();
    }

    private void dialogChanged() {
        IResource container = ResourcesPlugin.getWorkspace().getRoot().findMember((IPath)new Path(this.getContainerName()));
        String fileName = this.getFileName();
        if (this.getContainerName().length() == 0) {
            this.updateStatus("File container must be specified");
            return;
        }
        if (container == null || (container.getType() & 6) == 0) {
            this.updateStatus("File container must exist");
            return;
        }
        if (!container.isAccessible()) {
            this.updateStatus("Project must be writable");
            return;
        }
        if (fileName.length() == 0) {
            this.updateStatus("File name must be specified");
            return;
        }
        if (fileName.replace('\\', '/').indexOf(47, 1) > 0) {
            this.updateStatus("File name must be valid");
            return;
        }
        this.updateStatus(null);
    }

    private void updateStatus(String message) {
        this.setErrorMessage(message);
        this.setPageComplete(message == null);
    }

    public String getContainerName() {
        return this.containerText.getText();
    }

    public String getFileName() {
        return this.fileText.getText();
    }
}

