/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.eclipse.console.wizards;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.SearchMatch;
import org.eclipse.jdt.core.search.SearchParticipant;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.core.search.SearchRequestor;
import org.eclipse.jdt.ui.wizards.BuildPathDialogAccess;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.hibernate.cfg.NamingStrategy;
import org.hibernate.console.KnownConfigurations;
import org.hibernate.console.preferences.ConsoleConfigurationPreferences;
import org.hibernate.eclipse.console.EclipseConsoleConfiguration;
import org.hibernate.eclipse.console.EclipseConsoleConfigurationPreferences;
import org.hibernate.eclipse.console.HibernateConsolePlugin;
import org.hibernate.eclipse.console.utils.DialogSelectionHelper;
import org.hibernate.eclipse.console.utils.ProjectUtils;
import org.hibernate.eclipse.console.wizards.CollectingSearchRequestor;
import org.hibernate.eclipse.console.wizards.UpDownListComposite;
import org.hibernate.util.StringHelper;
import org.xml.sax.EntityResolver;

public class ConsoleConfigurationWizardPage
extends WizardPage {
    private Text propertyFileText;
    private Text configurationFileText;
    private Text configurationNameText;
    private Text projectNameText;
    private Text persistenceUnitNameText;
    private EclipseConsoleConfiguration oldConfiguaration = null;
    Button coreMode;
    Button jpaMode;
    Button annotationsMode;
    private Text entityResolverClassNameText;
    private Text namingStrategyClassNameText;
    private ISelection selection;
    private UpDownListComposite mappingFilesViewer;
    private UpDownListComposite classPathViewer;
    private boolean configurationFileWillBeCreated;
    private Button confbutton;
    private Button entbutton;
    private Button useProjectClassPath;
    private Button nambutton;

    public ConsoleConfigurationWizardPage(ISelection selection) {
        super("configurationPage");
        this.setTitle("Create Hibernate Console Configuration");
        this.setDescription("This wizard allows you to create a configuration for Hibernate Console.");
        this.selection = selection;
    }

    public void createControl(Composite parent) {
        TabFolder folder = new TabFolder(parent, 128);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        layout.verticalSpacing = 9;
        ModifyListener modifyListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ConsoleConfigurationWizardPage.this.dialogChanged();
            }
        };
        Composite general = this.createGeneral((Composite)folder, modifyListener);
        TabItem item = new TabItem(folder, 0);
        item.setControl((Control)general);
        item.setText("General");
        Composite composite = this.buildClassPathTable((Composite)folder);
        item = new TabItem(folder, 0);
        item.setControl((Control)composite);
        item.setText("Classpath");
        composite = this.buildMappingFileTable((Composite)folder);
        item = new TabItem(folder, 0);
        item.setControl((Control)composite);
        item.setText("Mappings");
        this.initialize(this.selection);
        this.dialogChanged();
        this.setControl((Control)folder);
    }

    private Composite createGeneral(Composite parent, ModifyListener modifyListener) {
        Composite container = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        gridLayout.verticalSpacing = 9;
        container.setLayout((Layout)gridLayout);
        Label label = new Label(container, 0);
        label.setText("&Name:");
        this.configurationNameText = new Text(container, 2052);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.configurationNameText.setLayoutData((Object)gd);
        this.configurationNameText.addModifyListener(modifyListener);
        label = new Label(container, 0);
        label.setText("Pro&ject:");
        this.projectNameText = new Text(container, 2052);
        gd = new GridData(768);
        this.projectNameText.setLayoutData((Object)gd);
        this.projectNameText.addModifyListener(modifyListener);
        Button button = new Button(container, 8);
        button.setText("Browse...");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ConsoleConfigurationWizardPage.this.handleProjectBrowse();
            }
        });
        this.createConfigurationMode(container);
        label = new Label(container, 0);
        label.setText("&Property file:");
        this.propertyFileText = new Text(container, 2052);
        gd = new GridData(768);
        this.propertyFileText.setLayoutData((Object)gd);
        this.propertyFileText.addModifyListener(modifyListener);
        button = new Button(container, 8);
        button.setText("Browse...");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ConsoleConfigurationWizardPage.this.handlePropertyFileBrowse();
            }
        });
        label = new Label(container, 0);
        label.setText("&Configuration file:");
        this.configurationFileText = new Text(container, 2052);
        gd = new GridData(768);
        this.configurationFileText.setLayoutData((Object)gd);
        this.configurationFileText.addModifyListener(modifyListener);
        this.confbutton = new Button(container, 8);
        this.confbutton.setText("Browse...");
        this.confbutton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ConsoleConfigurationWizardPage.this.handleConfigurationFileBrowse();
            }
        });
        label = new Label(container, 0);
        label.setText("&Persistence unit:");
        this.persistenceUnitNameText = new Text(container, 2052);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.persistenceUnitNameText.setLayoutData((Object)gd);
        this.persistenceUnitNameText.addModifyListener(modifyListener);
        label = new Label(container, 0);
        label.setText("&Naming strategy:");
        this.namingStrategyClassNameText = new Text(container, 2052);
        gd = new GridData(768);
        gd.horizontalSpan = 1;
        this.namingStrategyClassNameText.setLayoutData((Object)gd);
        this.namingStrategyClassNameText.addModifyListener(modifyListener);
        this.nambutton = new Button(container, 8);
        this.nambutton.setText("Browse...");
        this.nambutton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ConsoleConfigurationWizardPage.this.handleNamingStrategyBrowse();
            }
        });
        label = new Label(container, 0);
        label.setText("&Entity resolver:");
        this.entityResolverClassNameText = new Text(container, 2052);
        gd = new GridData(768);
        gd.horizontalSpan = 1;
        this.entityResolverClassNameText.setLayoutData((Object)gd);
        this.entityResolverClassNameText.addModifyListener(modifyListener);
        this.entbutton = new Button(container, 8);
        this.entbutton.setText("Browse...");
        this.entbutton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ConsoleConfigurationWizardPage.this.handleEntityResolverBrowse();
            }
        });
        return container;
    }

    private void createConfigurationMode(Composite container) {
        SelectionAdapter sl = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ConsoleConfigurationWizardPage.this.dialogChanged();
            }
        };
        new Label(container, 0).setText("Type:");
        Group group = new Group(container, 4);
        group.setLayout((Layout)new RowLayout(256));
        this.coreMode = new Button((Composite)group, 16);
        this.coreMode.setText("Core");
        this.coreMode.addSelectionListener((SelectionListener)sl);
        this.coreMode.setSelection(true);
        this.annotationsMode = new Button((Composite)group, 16);
        this.annotationsMode.setText("Annotations (jdk 1.5+)");
        this.annotationsMode.addSelectionListener((SelectionListener)sl);
        this.jpaMode = new Button((Composite)group, 16);
        this.jpaMode.setText("JPA (jdk 1.5+)");
        this.jpaMode.addSelectionListener((SelectionListener)sl);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        group.setLayoutData((Object)gd);
    }

    protected void handleEntityResolverBrowse() {
        String string = DialogSelectionHelper.chooseImplementation(EntityResolver.class.getName(), this.entityResolverClassNameText.getText(), "Select entity resolver class", this.getShell());
        if (string != null) {
            this.entityResolverClassNameText.setText(string);
        }
    }

    protected void handleNamingStrategyBrowse() {
        String string = DialogSelectionHelper.chooseImplementation(NamingStrategy.class.getName(), this.namingStrategyClassNameText.getText(), "Select naming strategy class", this.getShell());
        if (string != null) {
            this.namingStrategyClassNameText.setText(string);
        }
    }

    private Composite buildClassPathTable(Composite parent) {
        Composite c = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        gridLayout.verticalSpacing = 9;
        c.setLayout((Layout)gridLayout);
        this.classPathViewer = new UpDownListComposite(c, 0, "Additional classpath (Hibernate jars not necessary!)"){

            protected Object[] handleAdd(int idx) {
                TableItem[] items = this.getTable().getItems();
                IPath[] exclude = new IPath[items.length];
                int i = 0;
                while (i < items.length) {
                    TableItem item = items[i];
                    exclude[i] = (IPath)item.getData();
                    ++i;
                }
                switch (idx) {
                    case 0: {
                        return DialogSelectionHelper.chooseFileEntries(this.getShell(), null, exclude, "Add classpath entry", "Add a directory, .zip or .jar file", new String[]{".jar", ".zip"}, true, true, true);
                    }
                    case 1: {
                        return BuildPathDialogAccess.chooseExternalJAREntries((Shell)this.getShell());
                    }
                }
                return null;
            }

            protected String[] getAddButtonLabels() {
                return new String[]{"Add JAR/Dir...", "Add External JARS..."};
            }

            protected void listChanged() {
                ConsoleConfigurationWizardPage.this.dialogChanged();
            }
        };
        GridData gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        gd.verticalAlignment = 4;
        gd.horizontalAlignment = 4;
        this.classPathViewer.setLayoutData(gd);
        this.useProjectClassPath = new Button(c, 32);
        this.useProjectClassPath.setSelection(true);
        this.useProjectClassPath.setText("Include default classpath from project");
        this.useProjectClassPath.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                ConsoleConfigurationWizardPage.this.dialogChanged();
            }

            public void widgetSelected(SelectionEvent e) {
                ConsoleConfigurationWizardPage.this.dialogChanged();
            }
        });
        return c;
    }

    private UpDownListComposite buildMappingFileTable(Composite parent) {
        this.mappingFilesViewer = new UpDownListComposite(parent, 0, "Additional mapping files (not listed in cfg.xml)"){

            protected Object[] handleAdd(int idx) {
                TableItem[] items = this.getTable().getItems();
                IPath[] exclude = new IPath[items.length];
                int i = 0;
                while (i < items.length) {
                    TableItem item = items[i];
                    exclude[i] = (IPath)item.getData();
                    ++i;
                }
                return DialogSelectionHelper.chooseFileEntries(this.getShell(), null, exclude, "Add hbm.xml file", "Add a Hibernate Mapping file", new String[]{"hbm.xml"}, true, false, true);
            }

            protected void listChanged() {
                ConsoleConfigurationWizardPage.this.dialogChanged();
            }
        };
        GridData gd = new GridData(1808);
        gd.horizontalSpan = 3;
        gd.verticalSpan = 1;
        this.mappingFilesViewer.setLayoutData(gd);
        return this.mappingFilesViewer;
    }

    public void initialize(ISelection currentSelection) {
        try {
            Visitor v = new Visitor();
            if (currentSelection != null && !currentSelection.isEmpty() && currentSelection instanceof IStructuredSelection) {
                IStructuredSelection ssel = (IStructuredSelection)currentSelection;
                if (ssel.size() > 1) {
                    return;
                }
                Object obj = ssel.getFirstElement();
                IProject container = null;
                if (obj instanceof IJavaElement) {
                    v.javaProject = ((IJavaElement)obj).getJavaProject();
                    if (v.javaProject != null) {
                        container = v.javaProject.getProject();
                    }
                }
                if (obj instanceof IResource) {
                    IJavaProject project;
                    IResource res = (IResource)obj;
                    container = obj instanceof IContainer ? (IContainer)res : res.getParent();
                    if (res.getProject() != null && (project = JavaCore.create((IProject)res.getProject())).exists()) {
                        v.javaProject = project;
                    }
                }
                if (container != null) {
                    container.accept((IResourceProxyVisitor)v, 0);
                    if (v.javaProject == null) {
                        IProject project = container.getProject();
                        v.javaProject = JavaCore.create((IProject)project);
                    }
                    if (v.javaProject != null) {
                        this.configurationNameText.setText(v.javaProject.getElementName());
                        this.projectNameText.setText(v.javaProject.getElementName());
                    }
                    if (v.propertyFile != null) {
                        this.propertyFileText.setText(v.propertyFile.toOSString());
                    }
                    if (v.configFile != null) {
                        this.configurationFileText.setText(v.configFile.toOSString());
                    }
                    if (v.persistencexml != null) {
                        this.jpaMode.setSelection(true);
                        this.coreMode.setSelection(false);
                        this.annotationsMode.setSelection(false);
                    }
                    if (!v.mappings.isEmpty() && v.configFile == null && v.persistencexml == null) {
                        this.mappingFilesViewer.add(v.mappings.toArray(), false);
                    }
                    if (!v.classpath.isEmpty()) {
                        this.classPathViewer.add(v.classpath.toArray(), false);
                    }
                    this.useProjectClassPath.setSelection(true);
                } else if (obj instanceof EclipseConsoleConfiguration) {
                    EclipseConsoleConfiguration cc = (EclipseConsoleConfiguration)((Object)obj);
                    EclipseConsoleConfigurationPreferences prefs = (EclipseConsoleConfigurationPreferences)cc.getPreferences();
                    this.configurationNameText.setText(prefs.getName());
                    if (prefs.getProjectName() != null) {
                        this.projectNameText.setText(prefs.getProjectName());
                    }
                    this.useProjectClassPath.setSelection(prefs.useProjectClasspath());
                    if (prefs.getPropertyFilename() != null) {
                        this.propertyFileText.setText(prefs.getPropertyFilename().toOSString());
                    }
                    if (prefs.getCfgFile() != null) {
                        this.configurationFileText.setText(prefs.getCfgFile().toOSString());
                    }
                    if (prefs.getMappings() != null) {
                        this.mappingFilesViewer.add(prefs.getMappings(), false);
                    }
                    if (prefs.getCustomClasspath() != null) {
                        this.classPathViewer.add(prefs.getCustomClasspath(), false);
                    }
                    if (prefs.getEntityResolverName() != null) {
                        this.entityResolverClassNameText.setText(prefs.getEntityResolverName());
                    }
                    if (prefs.getNamingStrategy() != null) {
                        this.namingStrategyClassNameText.setText(prefs.getNamingStrategy());
                    }
                    if (prefs.getPersistenceUnitName() != null) {
                        this.persistenceUnitNameText.setText(prefs.getPersistenceUnitName());
                    }
                    this.jpaMode.setSelection(prefs.getConfigurationMode().equals(ConsoleConfigurationPreferences.ConfigurationMode.JPA));
                    this.coreMode.setSelection(prefs.getConfigurationMode().equals(ConsoleConfigurationPreferences.ConfigurationMode.CORE));
                    this.annotationsMode.setSelection(prefs.getConfigurationMode().equals(ConsoleConfigurationPreferences.ConfigurationMode.ANNOTATIONS));
                    this.oldConfiguaration = cc;
                }
            }
        }
        catch (CoreException ce) {
            HibernateConsolePlugin.getDefault().logErrorMessage("Problem while initializing ConsoleConfigurationWizardPage", ce);
        }
    }

    List locateTypes(IJavaProject javaProject) {
        try {
            String typeName = "java.sql.Driver";
            final SearchPattern pattern = SearchPattern.createPattern((String)typeName, (int)0, (int)1, (int)0);
            final IJavaSearchScope scope = SearchEngine.createJavaSearchScope((IJavaElement[])new IJavaElement[]{javaProject});
            final SearchEngine engine = new SearchEngine();
            final CollectingSearchRequestor sr = new CollectingSearchRequestor();
            final SearchParticipant[] participants = new SearchParticipant[]{SearchEngine.getDefaultSearchParticipant()};
            ProgressMonitorDialog dialog = new ProgressMonitorDialog(this.getShell());
            dialog.run(true, false, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) {
                    try {
                        engine.search(pattern, participants, scope, (SearchRequestor)sr, monitor);
                    }
                    catch (CoreException ce) {
                        HibernateConsolePlugin.getDefault().logErrorMessage("Problem while locating jdbc drivers", ce);
                    }
                }
            });
            ArrayList<IPath> resources = new ArrayList<IPath>();
            for (SearchMatch match : sr.getResults()) {
                if (!(match.getResource() instanceof IFile)) continue;
                resources.add(match.getResource().getFullPath());
            }
            return resources;
        }
        catch (InvocationTargetException e) {
            HibernateConsolePlugin.getDefault().logErrorMessage("Problem while locating jdbc drivers", e);
        }
        catch (InterruptedException e) {
            HibernateConsolePlugin.getDefault().logErrorMessage("Problem while locating jdbc drivers", e);
        }
        return Collections.EMPTY_LIST;
    }

    IPath[] getMappingFiles() {
        return this.tableItems2File(this.mappingFilesViewer.getTable());
    }

    IPath[] getClassPath() {
        return this.tableItems2File(this.classPathViewer.getTable());
    }

    private IPath[] tableItems2File(Table table) {
        TableItem[] items = table.getItems();
        IPath[] str = new IPath[items.length];
        int i = 0;
        while (i < items.length) {
            IPath path;
            TableItem item = items[i];
            str[i] = path = (IPath)item.getData();
            ++i;
        }
        return str;
    }

    private void handlePropertyFileBrowse() {
        IPath[] paths = org.hibernate.eclipse.console.utils.xpl.DialogSelectionHelper.chooseFileEntries(this.getShell(), (IPath)this.getPropertyFilePath(), new IPath[0], "Select property file", "Choose file to use as hibernate.properties", new String[]{"properties"}, false, false, true);
        if (paths != null && paths.length == 1) {
            this.propertyFileText.setText(paths[0].toOSString());
        }
    }

    private void handleProjectBrowse() {
        IJavaProject paths = DialogSelectionHelper.chooseJavaProject(this.getShell(), ProjectUtils.findJavaProject(this.propertyFileText.getText()), "Select java project", "The (optional) java project is used to determine the default classpath");
        if (paths != null) {
            this.projectNameText.setText(paths.getProject().getName());
        } else {
            this.projectNameText.setText("");
        }
    }

    private void handleConfigurationFileBrowse() {
        IPath[] paths = DialogSelectionHelper.chooseFileEntries(this.getShell(), (IPath)this.getConfigurationFilePath(), new IPath[0], "Select hibernate.cfg.xml file", "Choose file to use as hibernate.cfg.xml", new String[]{"cfg.xml"}, false, false, true);
        if (paths != null && paths.length == 1) {
            this.configurationFileText.setText(paths[0].toOSString());
        }
    }

    private void dialogChanged() {
        IResource resource;
        String msg;
        IJavaProject findJavaProject;
        String propertyFilename = this.propertyFileText.getText();
        String configurationFilename = this.configurationFileText.getText();
        this.configurationFileText.setEnabled(!this.configurationFileWillBeCreated && !this.getConfigurationMode().equals(ConsoleConfigurationPreferences.ConfigurationMode.JPA));
        this.confbutton.setEnabled(!this.getConfigurationMode().equals(ConsoleConfigurationPreferences.ConfigurationMode.JPA));
        this.persistenceUnitNameText.setEnabled(this.getConfigurationMode().equals(ConsoleConfigurationPreferences.ConfigurationMode.JPA));
        if (this.getConfigurationName() == null || this.getConfigurationName().trim().length() == 0) {
            this.updateStatus("A name must be specified");
            return;
        }
        if (this.oldConfiguaration == null && KnownConfigurations.getInstance().find(this.getConfigurationName()) != null) {
            this.updateStatus("A configuration with that name already exists!");
            return;
        }
        if (this.getProjectName() != null && StringHelper.isNotEmpty((String)this.getProjectName().trim()) && ((findJavaProject = ProjectUtils.findJavaProject(this.getProjectName())) == null || !findJavaProject.exists())) {
            this.updateStatus("The Java project " + this.getProjectName() + " does not exist.");
            return;
        }
        if (propertyFilename.length() > 0 && (msg = this.checkForFile("Property file", resource = ResourcesPlugin.getWorkspace().getRoot().findMember(propertyFilename))) != null) {
            this.updateStatus(msg);
            return;
        }
        if (!this.configurationFileWillBeCreated && configurationFilename.length() > 0) {
            resource = ResourcesPlugin.getWorkspace().getRoot().findMember(configurationFilename);
            msg = this.checkForFile("Configuration file", resource);
            if (msg != null) {
                this.updateStatus(msg);
                return;
            }
        } else {
            this.mappingFilesViewer.getTable().getItemCount();
        }
        if (this.useProjectClassPath() && StringHelper.isEmpty((String)this.getProjectName()) && this.classPathViewer.getTable().getItemCount() == 0) {
            this.updateStatus("Need to specify a project or setup a classpath");
            return;
        }
        if (!this.useProjectClassPath() && this.classPathViewer.getTable().getItemCount() == 0) {
            this.updateStatus("Need to specify a classpath when not using a project classpath");
            return;
        }
        this.updateStatus(null);
    }

    String getProjectName() {
        return this.projectNameText.getText();
    }

    String getConfigurationName() {
        return this.configurationNameText.getText();
    }

    private String checkForFile(String msgPrefix, IResource resource) {
        if (resource != null) {
            if (resource instanceof IFile) {
                return null;
            }
            return String.valueOf(msgPrefix) + " is not a file";
        }
        return String.valueOf(msgPrefix) + " does not exist";
    }

    private void updateStatus(String message) {
        this.setErrorMessage(message);
        this.setPageComplete(message == null);
    }

    public Path getPropertyFilePath() {
        String p = this.propertyFileText.getText();
        return this.pathOrNull(p);
    }

    private Path pathOrNull(String p) {
        if (p == null || p.trim().length() == 0) {
            return null;
        }
        return new Path(p);
    }

    public Path getConfigurationFilePath() {
        return this.pathOrNull(this.configurationFileText.getText());
    }

    public EclipseConsoleConfiguration getOldConfiguration() {
        return this.oldConfiguaration;
    }

    public void setConfigurationFilePath(IPath containerFullPath) {
        if (!this.configurationFileWillBeCreated) {
            this.initialize((ISelection)new StructuredSelection((Object)containerFullPath));
        }
        this.configurationFileText.setText(containerFullPath.toPortableString());
        this.configurationFileWillBeCreated = true;
        this.configurationFileText.setEnabled(false);
        this.confbutton.setEnabled(false);
    }

    public String getEntityResolverClassName() {
        return this.entityResolverClassNameText.getText();
    }

    public boolean useProjectClassPath() {
        return this.useProjectClassPath.getSelection();
    }

    public ConsoleConfigurationPreferences.ConfigurationMode getConfigurationMode() {
        if (this.annotationsMode.getSelection()) {
            return ConsoleConfigurationPreferences.ConfigurationMode.ANNOTATIONS;
        }
        if (this.jpaMode.getSelection()) {
            return ConsoleConfigurationPreferences.ConfigurationMode.JPA;
        }
        return ConsoleConfigurationPreferences.ConfigurationMode.CORE;
    }

    public String getNamingStrategy() {
        return this.namingStrategyClassNameText.getText();
    }

    public String getPersistenceUnitName() {
        return this.persistenceUnitNameText.getText();
    }

    static class Visitor
    implements IResourceProxyVisitor {
        public IPath propertyFile;
        public IPath configFile;
        public IPath persistencexml;
        public IJavaProject javaProject;
        public List classpath = new ArrayList();
        public List mappings = new ArrayList();

        Visitor() {
        }

        public boolean visit(IResourceProxy proxy) throws CoreException {
            IPath fullPath = proxy.requestFullPath();
            if (proxy.getType() == 1) {
                if ("hibernate.properties".equals(proxy.getName())) {
                    this.propertyFile = fullPath;
                    return false;
                }
                if ("hibernate.cfg.xml".equals(proxy.getName())) {
                    this.configFile = fullPath;
                    this.mappings.clear();
                    return false;
                }
                if ("persistence.xml".equals(proxy.getName()) && this.javaProject != null && this.javaProject.isOnClasspath(proxy.requestResource())) {
                    this.persistencexml = fullPath;
                    this.mappings.clear();
                    return false;
                }
                if ((this.configFile == null || this.persistencexml == null) && proxy.getName().endsWith(".hbm.xml")) {
                    this.mappings.add(fullPath);
                    return false;
                }
            } else if (proxy.getType() == 2 && this.javaProject != null && this.javaProject.getOutputLocation().isPrefixOf(fullPath)) {
                return false;
            }
            return true;
        }
    }
}

