/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.eclipse.console.views.properties;

import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource2;
import org.eclipse.ui.views.properties.TextPropertyDescriptor;
import org.hibernate.console.QueryPage;

public class QueryPagePropertySource
implements IPropertySource2 {
    private final QueryPage page;
    static IPropertyDescriptor[] descriptors;
    private static final String QUERY_TEXT = "QueryPage.queryString";
    private static final Object CONFIGURATION_TEXT;
    private static final String QUERY_SIZE = "QueryPage.size";
    private static final String QUERY_TIME = "QueryPage.time";

    static {
        CONFIGURATION_TEXT = "QueryPage.consoleConfiguration";
        descriptors = new IPropertyDescriptor[4];
        TextPropertyDescriptor descriptor = new TextPropertyDescriptor((Object)QUERY_TEXT, "Query string");
        descriptor.setAlwaysIncompatible(false);
        QueryPagePropertySource.descriptors[0] = descriptor;
        descriptor = new TextPropertyDescriptor(CONFIGURATION_TEXT, "Console configuration");
        descriptor.setAlwaysIncompatible(false);
        QueryPagePropertySource.descriptors[1] = descriptor;
        descriptor = new TextPropertyDescriptor((Object)QUERY_SIZE, "Query size");
        descriptor.setAlwaysIncompatible(false);
        QueryPagePropertySource.descriptors[2] = descriptor;
        descriptor = new TextPropertyDescriptor((Object)QUERY_TIME, "Query run time");
        descriptor.setAlwaysIncompatible(false);
        QueryPagePropertySource.descriptors[3] = descriptor;
    }

    public QueryPagePropertySource(QueryPage page) {
        this.page = page;
    }

    public boolean isPropertyResettable(Object id) {
        return false;
    }

    public Object getEditableValue() {
        return "";
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        return descriptors;
    }

    public Object getPropertyValue(Object id) {
        if (CONFIGURATION_TEXT.equals(id)) {
            return this.page.getConsoleConfiguration().getName();
        }
        if (QUERY_TEXT.equals(id)) {
            return this.page.getQueryString();
        }
        if (QUERY_SIZE.equals(id)) {
            int resultSize = this.page.getResultSize();
            return resultSize == -1 ? "(unknown)" : Integer.valueOf(resultSize);
        }
        if (QUERY_TIME.equals(id)) {
            long resultTime = this.page.getQueryTime();
            if (resultTime == -1L) {
                return "(unknown)";
            }
            if (resultTime > 1000L) {
                return String.valueOf(resultTime / 1000L) + "." + resultTime / 100L % 10L + " sec";
            }
            return String.valueOf(resultTime) + " millisec";
        }
        return null;
    }

    public boolean isPropertySet(Object id) {
        return false;
    }

    public void resetPropertyValue(Object id) {
    }

    public void setPropertyValue(Object id, Object value) {
    }
}

