/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.eclipse.console.views.properties;

import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.IPropertySourceProvider;
import org.hibernate.Session;
import org.hibernate.console.ConsoleConfiguration;
import org.hibernate.console.QueryPage;
import org.hibernate.console.execution.ExecutionContextHolder;
import org.hibernate.eclipse.console.views.QueryPageTabView;
import org.hibernate.eclipse.console.views.properties.CollectionPropertySource;
import org.hibernate.eclipse.console.views.properties.EntityPropertySource;
import org.hibernate.eclipse.console.views.properties.QueryPagePropertySource;
import org.hibernate.proxy.HibernateProxyHelper;

public class HibernatePropertySourceProvider
implements IPropertySourceProvider {
    private final QueryPageTabView view;

    public HibernatePropertySourceProvider(QueryPageTabView view) {
        this.view = view;
    }

    public IPropertySource getPropertySource(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof QueryPage) {
            return new QueryPagePropertySource((QueryPage)object);
        }
        if (object instanceof CollectionPropertySource) {
            return (IPropertySource)object;
        }
        Session currentSession = this.view.getSelectedQueryPage().getSession();
        ConsoleConfiguration currentConfiguration = this.view.getSelectedQueryPage().getConsoleConfiguration();
        if (currentSession.isOpen() && currentSession.contains(object) || this.hasMetaData(object, currentSession)) {
            return new EntityPropertySource(object, currentSession, (ExecutionContextHolder)currentConfiguration);
        }
        return null;
    }

    private boolean hasMetaData(Object object, Session currentSession) {
        return currentSession.getSessionFactory().getClassMetadata(HibernateProxyHelper.getClassWithoutInitializingProxy((Object)object)) != null;
    }
}

