/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.eclipse.console.views.properties;

import java.util.Collection;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource2;
import org.eclipse.ui.views.properties.PropertyDescriptor;
import org.hibernate.EntityMode;
import org.hibernate.Session;
import org.hibernate.console.execution.ExecutionContext;
import org.hibernate.console.execution.ExecutionContextHolder;
import org.hibernate.eclipse.console.views.properties.CollectionPropertySource;
import org.hibernate.metadata.ClassMetadata;
import org.hibernate.metadata.CollectionMetadata;
import org.hibernate.proxy.HibernateProxyHelper;

public class EntityPropertySource
implements IPropertySource2 {
    private Object reflectedObject;
    private IPropertyDescriptor[] propertyDescriptors;
    private final ExecutionContextHolder currentConfiguration;
    private final Session currentSession;
    private ClassMetadata classMetadata;

    public EntityPropertySource(Object object, Session currentSession, ExecutionContextHolder currentConfiguration) {
        this.currentSession = currentSession;
        this.currentConfiguration = currentConfiguration;
        this.reflectedObject = object;
        this.classMetadata = currentSession.isOpen() ? currentSession.getSessionFactory().getClassMetadata(currentSession.getEntityName(this.reflectedObject)) : currentSession.getSessionFactory().getClassMetadata(HibernateProxyHelper.getClassWithoutInitializingProxy((Object)this.reflectedObject));
    }

    public Object getEditableValue() {
        return "";
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        if (this.propertyDescriptors == null) {
            this.currentConfiguration.getExecutionContext().execute(new ExecutionContext.Command(){

                public Object execute() {
                    EntityPropertySource.this.propertyDescriptors = EntityPropertySource.initializePropertyDescriptors(EntityPropertySource.this.classMetadata);
                    return null;
                }
            });
        }
        return this.propertyDescriptors;
    }

    protected static IPropertyDescriptor[] initializePropertyDescriptors(ClassMetadata classMetadata) {
        String[] propertyNames = classMetadata.getPropertyNames();
        int length = propertyNames.length;
        PropertyDescriptor identifier = null;
        if (classMetadata.hasIdentifierProperty()) {
            identifier = new PropertyDescriptor((Object)classMetadata.getIdentifierPropertyName(), classMetadata.getIdentifierPropertyName());
            identifier.setCategory("Identifier");
            ++length;
        }
        PropertyDescriptor[] properties = new PropertyDescriptor[length];
        int idx = 0;
        if (identifier != null) {
            properties[idx++] = identifier;
        }
        int i = 0;
        while (i < propertyNames.length) {
            PropertyDescriptor prop = new PropertyDescriptor((Object)propertyNames[i], propertyNames[i]);
            prop.setCategory("Properties");
            properties[i + idx] = prop;
            ++i;
        }
        return properties;
    }

    public Object getPropertyValue(Object id) {
        CollectionMetadata collectionMetadata;
        Object propertyValue = id.equals(this.classMetadata.getIdentifierPropertyName()) ? this.classMetadata.getIdentifier(this.reflectedObject, EntityMode.POJO) : this.classMetadata.getPropertyValue(this.reflectedObject, (String)id, EntityMode.POJO);
        if (propertyValue instanceof Collection && (collectionMetadata = this.currentSession.getSessionFactory().getCollectionMetadata(String.valueOf(this.classMetadata.getEntityName()) + "." + id)) != null) {
            propertyValue = new CollectionPropertySource((Collection)propertyValue, this.currentSession, this.currentConfiguration, collectionMetadata);
        }
        return propertyValue;
    }

    public boolean isPropertySet(Object id) {
        return false;
    }

    public void resetPropertyValue(Object id) {
    }

    public void setPropertyValue(Object id, Object value) {
    }

    public boolean isPropertyResettable(Object id) {
        return false;
    }
}

