/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.eclipse.console.views;

import java.util.Iterator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.swt.widgets.Shell;
import org.hibernate.HibernateException;
import org.hibernate.console.ConsoleConfiguration;
import org.hibernate.console.execution.ExecutionContext;
import org.hibernate.eclipse.console.HibernateConsolePlugin;
import org.hibernate.eclipse.console.actions.ConsoleConfigurationBasedAction;
import org.hibernate.tool.hbm2ddl.SchemaExport;

public class SchemaExportAction
extends ConsoleConfigurationBasedAction {
    private StructuredViewer viewer;

    protected SchemaExportAction(String text) {
        super(text);
    }

    public SchemaExportAction(StructuredViewer selectionProvider) {
        super("Run SchemaExport");
        this.viewer = selectionProvider;
    }

    public void doRun() {
        Iterator i = this.getSelectedNonResources().iterator();
        while (i.hasNext()) {
            try {
                Object node = i.next();
                if (!(node instanceof ConsoleConfiguration)) continue;
                final ConsoleConfiguration config = (ConsoleConfiguration)node;
                config.execute(new ExecutionContext.Command(){

                    public Object execute() {
                        if (config.getConfiguration() != null && MessageDialog.openConfirm((Shell)SchemaExportAction.this.viewer.getControl().getShell(), (String)"Run SchemaExport", (String)("Are you sure you want to run SchemaExport on '" + config.getName() + "'?"))) {
                            SchemaExport export = new SchemaExport(config.getConfiguration());
                            export.create(false, true);
                            if (!export.getExceptions().isEmpty()) {
                                Iterator iterator = export.getExceptions().iterator();
                                int cnt = 1;
                                while (iterator.hasNext()) {
                                    Throwable element = (Throwable)iterator.next();
                                    HibernateConsolePlugin.getDefault().logErrorMessage("Error #" + cnt++ + " while performing SchemaExport", element);
                                }
                                HibernateConsolePlugin.getDefault().showError(SchemaExportAction.this.viewer.getControl().getShell(), String.valueOf(cnt - 1) + " error(s) while performing SchemaExport, see Error Log for details", (Throwable)null);
                            }
                        }
                        return null;
                    }
                });
                this.viewer.refresh(node);
            }
            catch (HibernateException he) {
                HibernateConsolePlugin.getDefault().showError(this.viewer.getControl().getShell(), "Exception while running SchemaExport", he);
            }
        }
    }

    protected boolean updateState(ConsoleConfiguration consoleConfiguration) {
        return consoleConfiguration.hasConfiguration();
    }
}

