/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.eclipse.console.views;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.model.IWorkbenchAdapter;
import org.hibernate.SessionFactory;
import org.hibernate.console.ConsoleConfiguration;
import org.hibernate.console.KnownConfigurations;
import org.hibernate.console.KnownConfigurationsListener;
import org.hibernate.eclipse.console.workbench.DeferredContentProvider;

class KnownConfigurationsProvider
extends DeferredContentProvider
implements KnownConfigurationsListener {
    private TreeViewer tv;

    public void inputChanged(Viewer v, Object oldInput, Object newInput) {
        KnownConfigurations newz;
        KnownConfigurations old;
        super.inputChanged(v, oldInput, newInput);
        this.tv = (TreeViewer)v;
        if (oldInput != null && oldInput instanceof KnownConfigurations && (old = (KnownConfigurations)oldInput) != null) {
            old.removeConfigurationListener((KnownConfigurationsListener)this);
        }
        if (newInput != null && newInput instanceof KnownConfigurations && (newz = (KnownConfigurations)newInput) != null) {
            newz.addConsoleConfigurationListener((KnownConfigurationsListener)this);
        }
    }

    public void dispose() {
    }

    public void configurationAdded(ConsoleConfiguration root) {
        this.refreshTree();
    }

    private void refreshTree() {
        Runnable runnable = new Runnable(){

            public void run() {
                KnownConfigurationsProvider.this.tv.refresh();
            }
        };
        this.tv.getControl().getDisplay().syncExec(runnable);
    }

    public void configurationRemoved(ConsoleConfiguration root, boolean forUpdate) {
        if (forUpdate) {
            this.refreshTree();
        }
    }

    protected IWorkbenchAdapter getAdapter(Object o) {
        if (o instanceof IAdaptable) {
            return (IWorkbenchAdapter)((IAdaptable)o).getAdapter(IWorkbenchAdapter.class);
        }
        return (IWorkbenchAdapter)Platform.getAdapterManager().getAdapter(o, IWorkbenchAdapter.class);
    }

    public void sessionFactoryBuilt(ConsoleConfiguration ccfg, SessionFactory builtFactory) {
    }

    public void sessionFactoryClosing(final ConsoleConfiguration configuration, SessionFactory closingFactory) {
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                KnownConfigurationsProvider.this.tv.collapseToLevel((Object)configuration, -1);
                KnownConfigurationsProvider.this.tv.refresh((Object)configuration);
            }
        });
    }
}

