/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.eclipse.console.views;

import java.util.Collections;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.reconciler.IReconcilingStrategy;
import org.eclipse.jface.text.reconciler.MonoReconciler;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.text.source.VerticalRuler;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IPartService;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;
import org.hibernate.SessionFactory;
import org.hibernate.console.ConsoleConfiguration;
import org.hibernate.console.execution.ExecutionContext;
import org.hibernate.eclipse.console.utils.QLFormatHelper;
import org.hibernate.eclipse.console.views.AbstractReconcilingStrategy;
import org.hibernate.eclipse.hqleditor.HQLEditor;
import org.hibernate.eclipse.hqleditor.HQLEditorDocumentSetupParticipant;
import org.hibernate.eclipse.hqleditor.HQLSourceViewer;
import org.hibernate.eclipse.hqleditor.HQLSourceViewerConfiguration;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.engine.query.HQLQueryPlan;
import org.hibernate.impl.SessionFactoryImpl;
import org.hibernate.util.StringHelper;

public class DynamicSQLPreviewView
extends ViewPart {
    private IPartListener2 partListener = new IPartListener2(){

        public void partInputChanged(IWorkbenchPartReference partRef) {
        }

        public void partVisible(IWorkbenchPartReference partRef) {
        }

        public void partHidden(IWorkbenchPartReference partRef) {
        }

        public void partOpened(IWorkbenchPartReference partRef) {
        }

        public void partDeactivated(IWorkbenchPartReference partRef) {
        }

        public void partClosed(IWorkbenchPartReference partRef) {
            if (partRef.getPart(false) == DynamicSQLPreviewView.this.currentEditor) {
                DynamicSQLPreviewView.this.setCurrentEditor(null);
            }
        }

        public void partBroughtToTop(IWorkbenchPartReference partRef) {
            DynamicSQLPreviewView.this.hookIntoEditor(partRef);
        }

        public void partActivated(IWorkbenchPartReference partRef) {
            DynamicSQLPreviewView.this.hookIntoEditor(partRef);
        }
    };
    private SourceViewer textViewer;
    private HQLEditor currentEditor;
    private MonoReconciler reconciler;
    private HQLEditorDocumentSetupParticipant docSetupParticipant = new HQLEditorDocumentSetupParticipant();

    private void hookIntoEditor(IWorkbenchPartReference partRef) {
        if (partRef == null) {
            this.setCurrentEditor(null);
            return;
        }
        IWorkbenchPart part = partRef.getPart(false);
        if (part != null && part instanceof HQLEditor) {
            this.setCurrentEditor((HQLEditor)part);
        }
    }

    private void setCurrentEditor(HQLEditor editor) {
        if (editor == this.currentEditor) {
            return;
        }
        if (this.currentEditor != null) {
            this.reconciler.uninstall();
        }
        this.currentEditor = editor;
        if (this.currentEditor != null) {
            ITextViewer editorViewer = this.currentEditor.getTextViewer();
            this.reconciler.install(editorViewer);
        }
        this.updateText(this.currentEditor);
    }

    private void updateText(HQLEditor editor) {
        if (this.textViewer != null && this.textViewer.getDocument() != null) {
            if (editor != null) {
                ConsoleConfiguration consoleConfiguration = editor.getConsoleConfiguration();
                if (StringHelper.isEmpty((String)editor.getQueryString())) {
                    this.textViewer.getDocument().set("Empty HQL query.");
                } else if (consoleConfiguration != null) {
                    if (consoleConfiguration.isSessionFactoryCreated()) {
                        String generateSQL = this.generateSQL(consoleConfiguration.getExecutionContext(), consoleConfiguration.getSessionFactory(), editor.getQueryString());
                        if (StringHelper.isEmpty((String)generateSQL)) {
                            this.textViewer.getDocument().set("HQL was valid, but no SQL generated. Your configuration most likely does not have any mappings defined.");
                        } else {
                            this.textViewer.getDocument().set(generateSQL);
                        }
                    } else {
                        this.textViewer.getDocument().set("Session factory not created for configuration: " + consoleConfiguration.getName());
                    }
                } else {
                    this.textViewer.getDocument().set("No Console configuration associated with HQL Editor");
                }
            } else {
                this.textViewer.getDocument().set("No HQL Query editor");
            }
        }
    }

    public String generateSQL(ExecutionContext context, final SessionFactory sf, final String query) {
        if (StringHelper.isEmpty((String)query)) {
            return "";
        }
        String result = (String)context.execute(new ExecutionContext.Command(){

            /*
             * Unable to fully structure code
             */
            public Object execute() {
                session = null;
                try {
                    sfimpl = (SessionFactoryImpl)sf;
                    str = new StringBuffer(256);
                    plan = new HQLQueryPlan(query, false, Collections.EMPTY_MAP, (SessionFactoryImplementor)sfimpl);
                    translators = plan.getTranslators();
                    i = 0;
                    while (i < translators.length) {
                        translator = translators[i];
                        if (translator.isManipulationStatement()) {
                            str.append("Manipulation of " + i + ":");
                            iterator = translator.getQuerySpaces().iterator();
                            while (iterator.hasNext()) {
                                qspace = iterator.next();
                                str.append(qspace);
                                if (!iterator.hasNext()) continue;
                                str.append(", ");
                            }
                        } else {
                            returnTypes = translator.getReturnTypes();
                            str.append(String.valueOf(i) + ": ");
                            j = 0;
                            while (j < returnTypes.length) {
                                returnType = returnTypes[j];
                                str.append(returnType.getName());
                                if (j < returnTypes.length - 1) {
                                    str.append(", ");
                                }
                                ++j;
                            }
                        }
                        str.append("\n-----------------\n");
                        for (String sql : translator.collectSqlStrings()) {
                            str.append(QLFormatHelper.formatForScreen(sql));
                            str.append("\n\n");
                        }
                        ++i;
                    }
                    return str.toString();
                }
                catch (Throwable t) {
                    if (session != null) {
                        session.close();
                    }
                    msgs = new StringBuffer();
                    cause = t;
                    ** while (cause != null)
                }
lbl-1000:
                // 1 sources

                {
                    msgs.append(t);
                    if (cause.getCause() == cause) {
                        cause = null;
                        continue;
                    }
                    if ((cause = cause.getCause()) == null) continue;
                    msgs.append("\nCaused by:\n");
                    continue;
                }
lbl63:
                // 1 sources

                return msgs.toString();
            }
        });
        return result;
    }

    public void createPartControl(Composite parent) {
        this.textViewer = new HQLSourceViewer(parent, (IVerticalRuler)new VerticalRuler(1), null, false, 776);
        Document doc = new Document();
        this.textViewer.setDocument((IDocument)doc);
        this.docSetupParticipant.setup((IDocument)doc);
        this.textViewer.getDocument().set("No HQL Query editor selected");
        this.textViewer.configure((SourceViewerConfiguration)new HQLSourceViewerConfiguration(null));
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        IPartService service = window.getPartService();
        this.hookIntoEditor(service.getActivePartReference());
    }

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        AbstractReconcilingStrategy strategy = new AbstractReconcilingStrategy(){

            protected void doReconcile(IDocument doc) {
                Display display = PlatformUI.getWorkbench().getDisplay();
                display.asyncExec(new Runnable(){

                    public void run() {
                        DynamicSQLPreviewView.this.updateText(DynamicSQLPreviewView.this.currentEditor);
                    }
                });
            }
        };
        this.reconciler = new MonoReconciler((IReconcilingStrategy)strategy, false);
        this.reconciler.setDelay(500);
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        IPartService service = window.getPartService();
        service.addPartListener(this.partListener);
        this.hookIntoEditor(service.getActivePartReference());
    }

    public void dispose() {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        IPartService service = window.getPartService();
        service.removePartListener(this.partListener);
        this.docSetupParticipant.unsetup();
        super.dispose();
    }

    public void setFocus() {
    }
}

