/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.eclipse.console.views;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.actions.ActionGroup;
import org.eclipse.ui.actions.SelectionListenerAction;
import org.hibernate.console.ConsoleConfiguration;
import org.hibernate.eclipse.console.actions.AddConfigurationAction;
import org.hibernate.eclipse.console.actions.CriteriaEditorAction;
import org.hibernate.eclipse.console.actions.DeleteConfigurationAction;
import org.hibernate.eclipse.console.actions.EditConsoleConfiguration;
import org.hibernate.eclipse.console.actions.HQLScratchpadAction;
import org.hibernate.eclipse.console.actions.OpenMappingAction;
import org.hibernate.eclipse.console.actions.OpenSourceAction;
import org.hibernate.eclipse.console.actions.RefreshAction;
import org.hibernate.eclipse.console.views.ReloadConfigurationAction;
import org.hibernate.eclipse.console.views.SchemaExportAction;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;

public class ConfigurationsViewActionGroup
extends ActionGroup {
    private Action addConfigurationAction;
    private SelectionListenerAction deleteConfigurationAction;
    private SelectionListenerAction refreshAction;
    private SelectionListenerAction reloadConfigurationAction;
    private SelectionListenerAction schemaExportAction;
    private EditConsoleConfiguration editConfigurationAction;
    private final StructuredViewer selectionProvider;
    private SelectionListenerAction hqlEditorAction;
    private CriteriaEditorAction criteriaEditorAction;
    private SelectionListenerAction openMappingAction;
    private SelectionListenerAction openSourceAction;

    public ConfigurationsViewActionGroup(IViewPart part, StructuredViewer selectionProvider) {
        this.selectionProvider = selectionProvider;
        this.addConfigurationAction = new AddConfigurationAction(part);
        this.deleteConfigurationAction = new DeleteConfigurationAction(selectionProvider);
        selectionProvider.addSelectionChangedListener((ISelectionChangedListener)this.deleteConfigurationAction);
        IActionBars actionBars = part.getViewSite().getActionBars();
        actionBars.setGlobalActionHandler(ActionFactory.DELETE.getId(), (IAction)this.deleteConfigurationAction);
        this.refreshAction = new RefreshAction(selectionProvider);
        selectionProvider.addSelectionChangedListener((ISelectionChangedListener)this.refreshAction);
        this.reloadConfigurationAction = new ReloadConfigurationAction(selectionProvider);
        selectionProvider.addSelectionChangedListener((ISelectionChangedListener)this.reloadConfigurationAction);
        this.schemaExportAction = new SchemaExportAction(selectionProvider);
        selectionProvider.addSelectionChangedListener((ISelectionChangedListener)this.schemaExportAction);
        this.editConfigurationAction = new EditConsoleConfiguration();
        selectionProvider.addSelectionChangedListener((ISelectionChangedListener)this.editConfigurationAction);
        this.hqlEditorAction = new HQLScratchpadAction();
        selectionProvider.addSelectionChangedListener((ISelectionChangedListener)this.hqlEditorAction);
        this.criteriaEditorAction = new CriteriaEditorAction();
        selectionProvider.addSelectionChangedListener((ISelectionChangedListener)this.criteriaEditorAction);
        this.openMappingAction = new OpenMappingAction();
        selectionProvider.addSelectionChangedListener((ISelectionChangedListener)this.openMappingAction);
        this.openSourceAction = new OpenSourceAction();
        selectionProvider.addSelectionChangedListener((ISelectionChangedListener)this.openSourceAction);
    }

    public void dispose() {
        super.dispose();
        this.selectionProvider.removeSelectionChangedListener((ISelectionChangedListener)this.deleteConfigurationAction);
        this.selectionProvider.removeSelectionChangedListener((ISelectionChangedListener)this.refreshAction);
        this.selectionProvider.removeSelectionChangedListener((ISelectionChangedListener)this.reloadConfigurationAction);
        this.selectionProvider.removeSelectionChangedListener((ISelectionChangedListener)this.schemaExportAction);
        this.selectionProvider.removeSelectionChangedListener((ISelectionChangedListener)this.editConfigurationAction);
        this.selectionProvider.removeSelectionChangedListener((ISelectionChangedListener)this.hqlEditorAction);
        this.selectionProvider.removeSelectionChangedListener((ISelectionChangedListener)this.criteriaEditorAction);
    }

    public void fillContextMenu(IMenuManager menu) {
        if (this.getContext() == null) {
            return;
        }
        IStructuredSelection selection = (IStructuredSelection)this.getContext().getSelection();
        if (selection == null) {
            return;
        }
        Object first = selection.getFirstElement();
        menu.add((IAction)this.hqlEditorAction);
        menu.add((IAction)this.criteriaEditorAction);
        menu.add((IContributionItem)new Separator());
        menu.add((IAction)this.addConfigurationAction);
        if (first instanceof ConsoleConfiguration) {
            menu.add((IAction)this.reloadConfigurationAction);
            menu.add((IAction)this.editConfigurationAction);
            menu.add((IAction)this.deleteConfigurationAction);
        }
        menu.add((IContributionItem)new Separator());
        menu.add((IAction)this.refreshAction);
        if (first instanceof ConsoleConfiguration) {
            menu.add((IAction)this.schemaExportAction);
        }
        menu.add((IContributionItem)new Separator());
        if (first != null && (first instanceof PersistentClass || first.getClass() == Property.class)) {
            menu.add((IAction)this.openSourceAction);
            menu.add((IAction)this.openMappingAction);
        }
    }

    public void fillActionBars(IActionBars actionBars) {
        actionBars.getToolBarManager().add((IAction)this.reloadConfigurationAction);
        actionBars.getToolBarManager().add((IAction)this.addConfigurationAction);
        actionBars.getToolBarManager().add((IAction)this.hqlEditorAction);
        actionBars.getToolBarManager().add((IAction)this.criteriaEditorAction);
    }
}

