/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.eclipse.console.viewers.xpl;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Widget;

public class MTreeViewer
extends TreeViewer {
    public MTreeViewer(Composite parent, int style) {
        super(parent, style);
    }

    public boolean isBusy() {
        Object obj = null;
        Class<ColumnViewer> clazz = ColumnViewer.class;
        try {
            Method hiddenMethod = clazz.getDeclaredMethod("isBusy", new Class[0]);
            if (hiddenMethod != null) {
                hiddenMethod.setAccessible(true);
                obj = hiddenMethod.invoke((Object)this, new Object[0]);
            }
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        if (obj instanceof Boolean) {
            return (Boolean)obj;
        }
        return false;
    }

    public void add(Object parentElementOrTreePath, Object[] childElements) {
        Assert.isNotNull((Object)parentElementOrTreePath);
        this.assertElementsNotNull(childElements);
        if (this.isBusy()) {
            return;
        }
        Widget[] widgets = this.internalFindItems2(parentElementOrTreePath);
        if (widgets.length == 0) {
            return;
        }
        int i = 0;
        while (i < widgets.length) {
            this.internalAdd(widgets[i], parentElementOrTreePath, childElements);
            ++i;
        }
    }

    protected Widget[] internalFindItems2(Object parentElementOrTreePath) {
        Widget[] widgets = parentElementOrTreePath instanceof TreePath ? this.internalFindItems(parentElementOrTreePath) : this.findItems2(parentElementOrTreePath);
        return widgets;
    }

    protected Widget[] findItems2(Object element) {
        Widget result = this.doFindInputItem(element);
        if (result != null) {
            return new Widget[]{result};
        }
        if (this.usingElementMap()) {
            return this.findItems2(element);
        }
        return this.doFindItems(element);
    }

    protected ArrayList internalFindItem(Item parent, Object element) {
        ArrayList<Item> ret = new ArrayList<Item>();
        Object data = parent.getData();
        if (data != null && this.equals(data, element)) {
            ret.add(parent);
            return ret;
        }
        Item[] items = this.getChildren((Widget)parent);
        int i = 0;
        while (i < items.length) {
            Item item = items[i];
            ArrayList o = this.internalFindItem(item, element);
            if (o != null) {
                ret.addAll(o);
            }
            ++i;
        }
        return ret;
    }

    protected Widget[] doFindItems(Object element) {
        Widget[] ret = new Widget[]{};
        Object root = this.getRoot();
        if (root == null) {
            return ret;
        }
        ArrayList res = new ArrayList();
        Item[] items = this.getChildren((Widget)this.getControl());
        if (items != null) {
            int i = 0;
            while (i < items.length) {
                ArrayList o = this.internalFindItem(items[i], element);
                if (o != null) {
                    res.addAll(o);
                }
                ++i;
            }
        }
        ret = res.toArray(new Widget[0]);
        return ret;
    }
}

