/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.eclipse.console.model.impl;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.variables.IStringVariableManager;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.hibernate.cfg.Configuration;
import org.hibernate.console.HibernateConsoleRuntimeException;
import org.hibernate.eclipse.console.model.impl.ExporterDefinition;
import org.hibernate.eclipse.console.model.impl.ExporterProperty;
import org.hibernate.eclipse.launch.PathHelper;
import org.hibernate.tool.hbm2x.ArtifactCollector;
import org.hibernate.tool.hbm2x.Exporter;
import org.hibernate.tool.hbm2x.GenericExporter;
import org.hibernate.util.StringHelper;

public class ExporterFactory {
    private ExporterDefinition definition;
    final Map inputProperties;
    private boolean enabled = true;
    private final String exporterId;

    public ExporterFactory(ExporterDefinition definition, String exporterId) {
        this.definition = definition;
        this.exporterId = exporterId;
        this.inputProperties = new HashMap();
    }

    public Map getDefaultExporterProperties() {
        return this.definition.getExporterProperties();
    }

    public String setProperty(String key, String value) {
        return this.inputProperties.put(key, value);
    }

    public void removeProperty(String propertyName) {
        this.inputProperties.remove(propertyName);
    }

    public String getPropertyValue(String key) {
        if (this.inputProperties.containsKey(key)) {
            return (String)this.inputProperties.get(key);
        }
        ExporterProperty ep = (ExporterProperty)this.definition.getExporterProperties().get(key);
        if (ep != null) {
            return ep.getDefaultValue();
        }
        return null;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean b) {
        this.enabled = b;
    }

    public ExporterDefinition getExporterDefinition() {
        return this.definition;
    }

    String getLaunchAttributePrefix(String exporterId) {
        return "org.hibernate.tools.exporters." + exporterId;
    }

    public boolean isEnabled(ILaunchConfiguration configuration) {
        boolean enabled = false;
        try {
            enabled = configuration.getAttribute("org.hibernate.tools.exporters", null) == null ? configuration.getAttribute(this.getId(), false) : configuration.getAttribute(this.getLaunchAttributePrefix(this.getId()), false);
        }
        catch (CoreException coreException) {
            enabled = false;
        }
        this.setEnabled(enabled);
        return this.isEnabled();
    }

    public void setEnabled(ILaunchConfigurationWorkingCopy configuration, boolean enabled, boolean oldSettings) {
        this.setEnabled(enabled);
        if (oldSettings) {
            configuration.setAttribute(this.getId(), this.isEnabled());
        } else {
            configuration.setAttribute(this.getLaunchAttributePrefix(this.getId()), this.isEnabled());
        }
    }

    public void setEnabled(ILaunchConfigurationWorkingCopy configuration, boolean enabled) {
        boolean oldSettings = true;
        try {
            oldSettings = configuration.getAttribute("org.hibernate.tools.exporters", null) == null;
        }
        catch (CoreException coreException) {}
        this.setEnabled(configuration, enabled, oldSettings);
    }

    public Map getProperties() {
        return this.inputProperties;
    }

    public String getId() {
        return this.exporterId;
    }

    public void setProperties(Map props) {
        this.inputProperties.clear();
        this.inputProperties.putAll(props);
    }

    public ExporterProperty getExporterProperty(String key) {
        return (ExporterProperty)this.definition.getExporterProperties().get(key);
    }

    public boolean hasLocalValueFor(String string) {
        return this.inputProperties.containsKey(string);
    }

    private String resolve(String expression) throws CoreException {
        if (expression == null) {
            return null;
        }
        IStringVariableManager variableManager = VariablesPlugin.getDefault().getStringVariableManager();
        return variableManager.performStringSubstitution(expression, false);
    }

    public Exporter createConfiguredExporter(Configuration cfg, String defaultOutputDirectory, String customTemplatePath, Properties globalProperties, Set outputDirectories, ArtifactCollector collector) throws CoreException {
        String locationAsStringPath;
        Exporter exporter = this.getExporterDefinition().createExporterInstance();
        Properties props = new Properties();
        props.putAll((Map<?, ?>)globalProperties);
        props.putAll((Map<?, ?>)this.getProperties());
        exporter.setProperties(props);
        exporter.setArtifactCollector(collector);
        String outputPath = defaultOutputDirectory;
        if (props.containsKey("outputdir")) {
            outputPath = props.getProperty("outputdir");
            props.remove("outputdir");
        }
        String resolvedOutputDir = this.resolve(outputPath);
        String loc = PathHelper.getLocationAsStringPath(resolvedOutputDir);
        if (outputPath != null && loc == null) {
            throw new HibernateConsoleRuntimeException("Output directory '" + resolvedOutputDir + "' in " + this.getExporterDefinition().getDescription() + " does not exist.");
        }
        if (StringHelper.isNotEmpty((String)loc)) {
            outputDirectories.add(loc);
            exporter.setOutputDirectory(new File(loc));
        }
        exporter.setConfiguration(cfg);
        ArrayList<String> templatePathList = new ArrayList<String>();
        if (props.containsKey("template_path")) {
            String resolveTemplatePath = this.resolve(props.getProperty("template_path"));
            locationAsStringPath = PathHelper.getLocationAsStringPath(resolveTemplatePath);
            if (locationAsStringPath == null) {
                throw new HibernateConsoleRuntimeException("Template directory '" + resolveTemplatePath + "' in " + this.getExporterDefinition().getDescription() + " does not exist.");
            }
            templatePathList.add(locationAsStringPath);
            props.remove("template_path");
        }
        if (StringHelper.isNotEmpty((String)customTemplatePath)) {
            String resolvedCustomTemplatePath = this.resolve(customTemplatePath);
            locationAsStringPath = PathHelper.getLocationAsStringPath(resolvedCustomTemplatePath);
            if (locationAsStringPath != null) {
                templatePathList.add(locationAsStringPath);
            } else {
                throw new HibernateConsoleRuntimeException("Template directory '" + resolvedCustomTemplatePath + "' in " + this.getExporterDefinition().getDescription() + " does not exist.");
            }
        }
        exporter.setTemplatePath(templatePathList.toArray(new String[templatePathList.size()]));
        if (this.getExporterDefinition().getId().equals("org.hibernate.tools.hbmtemplate")) {
            GenericExporter ge = (GenericExporter)exporter;
            ge.setFilePattern(props.getProperty("file_pattern", null));
            props.remove("file_pattern");
            ge.setTemplateName(props.getProperty("template_name", null));
            props.remove("template_name");
            ge.setForEach(props.getProperty("for_each", null));
            props.remove("for_each");
        }
        return exporter;
    }
}

