/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.eclipse.console.actions;

import java.io.FileNotFoundException;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.SelectionListenerAction;
import org.hibernate.console.ConsoleConfiguration;
import org.hibernate.eclipse.console.HibernateConsolePlugin;
import org.hibernate.eclipse.console.utils.ProjectUtils;
import org.hibernate.mapping.Component;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;

public class OpenSourceAction
extends SelectionListenerAction {
    private String imageFilePath = "icons/images/java.gif";

    public OpenSourceAction() {
        super("Open Source File");
        this.setToolTipText("Open Source File");
        this.setEnabled(true);
        this.setImageDescriptor(HibernateConsolePlugin.getImageDescriptor(this.imageFilePath));
    }

    public void run() {
        IStructuredSelection sel = this.getStructuredSelection();
        if (sel instanceof TreeSelection) {
            int i = 0;
            while (i < ((TreeSelection)sel).getPaths().length) {
                Object prevSegment;
                TreePath path = ((TreeSelection)sel).getPaths()[i];
                Object lastSegment = path.getLastSegment();
                PersistentClass persClass = this.getPersistentClass(lastSegment);
                ConsoleConfiguration consoleConfiguration = (ConsoleConfiguration)path.getSegment(0);
                IJavaProject proj = ProjectUtils.findJavaProject(consoleConfiguration);
                String fullyQualifiedName = null;
                if (lastSegment instanceof Property && (prevSegment = path.getParentPath().getLastSegment()) instanceof Property && ((Property)prevSegment).isComposite()) {
                    fullyQualifiedName = ((Component)((Property)prevSegment).getValue()).getComponentClassName();
                }
                if (fullyQualifiedName == null && persClass != null) {
                    fullyQualifiedName = persClass.getClassName();
                }
                try {
                    this.run(lastSegment, proj, fullyQualifiedName);
                }
                catch (JavaModelException e) {
                    HibernateConsolePlugin.getDefault().logErrorMessage("Can't find source file.", e);
                }
                catch (PartInitException e) {
                    HibernateConsolePlugin.getDefault().logErrorMessage("Can't open source file.", e);
                }
                catch (FileNotFoundException e) {
                    HibernateConsolePlugin.getDefault().logErrorMessage("Can't find source file.", e);
                }
                ++i;
            }
        }
    }

    public IEditorPart run(Object selection, IJavaProject proj, String fullyQualifiedName) throws JavaModelException, PartInitException, FileNotFoundException {
        if (fullyQualifiedName == null) {
            return null;
        }
        String remainder = null;
        IType type = null;
        if (fullyQualifiedName.indexOf("$") > 0) {
            remainder = fullyQualifiedName.substring(fullyQualifiedName.indexOf("$") + 1);
            fullyQualifiedName = fullyQualifiedName.substring(0, fullyQualifiedName.indexOf("$"));
            type = proj.findType(fullyQualifiedName);
            while (remainder.indexOf("$") > 0) {
                String subtype = remainder.substring(0, fullyQualifiedName.indexOf("$"));
                type = type.getType(subtype);
                remainder = remainder.substring(fullyQualifiedName.indexOf("$") + 1);
            }
            type = type.getType(remainder);
        } else {
            type = proj.findType(fullyQualifiedName);
        }
        IEditorPart editorPart = JavaUI.openInEditor((IJavaElement)type);
        if (editorPart instanceof JavaEditor) {
            Object jElement = null;
            jElement = selection instanceof Property ? type.getField(((Property)selection).getName()) : type;
            JavaEditor jEditor = (JavaEditor)editorPart;
            this.selectionToEditor((IJavaElement)jElement, jEditor);
        }
        if (editorPart == null) {
            throw new FileNotFoundException("Source file for class '" + fullyQualifiedName + "' not found.");
        }
        return editorPart;
    }

    private PersistentClass getPersistentClass(Object selection) {
        if (selection instanceof Property) {
            return ((Property)selection).getPersistentClass();
        }
        if (selection instanceof PersistentClass) {
            return (PersistentClass)selection;
        }
        return null;
    }

    private void selectionToEditor(IJavaElement jElement, JavaEditor jEditor) {
        if (jEditor != null) {
            jEditor.setSelection(jElement);
        }
    }

    public ImageDescriptor getImageDescriptor() {
        return super.getImageDescriptor();
    }
}

