/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.eclipse.console.actions;

import org.eclipse.jface.viewers.TreePath;
import org.hibernate.console.ConsoleConfiguration;
import org.hibernate.eclipse.console.HibernateConsolePlugin;
import org.hibernate.eclipse.console.actions.OpenQueryEditorAction;
import org.hibernate.eclipse.console.utils.EclipseImages;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;

public class HQLScratchpadAction
extends OpenQueryEditorAction {
    public HQLScratchpadAction() {
        super("HQL Editor");
        this.setImageDescriptor(EclipseImages.getImageDescriptor("HQL_EDITOR"));
        this.setToolTipText("Open HQL Editor");
        this.setEnabled(true);
    }

    protected void openQueryEditor(ConsoleConfiguration config, String query) {
        HibernateConsolePlugin.getDefault().openScratchHQLEditor(config == null ? null : config.getName(), query);
    }

    protected String generateQuery(TreePath path) {
        Object node = path.getLastSegment();
        if (node instanceof PersistentClass) {
            String name = ((PersistentClass)node).getEntityName();
            return "from " + name;
        }
        if (node instanceof Property) {
            String prName = ((Property)node).getName();
            PersistentClass pClass = ((Property)node).getPersistentClass();
            String enName = "";
            if (pClass != null) {
                enName = pClass.getEntityName();
                enName = enName.substring(enName.lastIndexOf(46) + 1);
            } else {
                int i = path.getSegmentCount() - 2;
                while (i > 0) {
                    if (path.getSegment(i) instanceof PersistentClass) {
                        enName = ((PersistentClass)path.getSegment(i)).getEntityName();
                        enName = enName.substring(enName.lastIndexOf(46) + 1);
                    } else if (path.getSegment(i) instanceof Property) {
                        prName = String.valueOf(((Property)path.getSegment(i)).getName()) + "." + prName;
                    }
                    --i;
                }
            }
            return "select o." + prName + " from " + enName + " o";
        }
        return "";
    }
}

