/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.eclipse.console.actions;

import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.actions.SelectionListenerAction;
import org.hibernate.HibernateException;
import org.hibernate.console.ConsoleConfiguration;
import org.hibernate.eclipse.console.HibernateConsolePlugin;

public abstract class ConsoleConfigurationBasedAction
extends SelectionListenerAction {
    boolean enabledWhenNoSessionFactory = false;
    boolean supportMultiple = true;

    protected void setEnabledWhenNoSessionFactory(boolean enabledWhenNoSessionFactory) {
        this.enabledWhenNoSessionFactory = enabledWhenNoSessionFactory;
    }

    public void setSupportMultiple(boolean supportMultiple) {
        this.supportMultiple = supportMultiple;
    }

    protected ConsoleConfigurationBasedAction(String text) {
        super(text);
    }

    public final void run() {
        try {
            this.doRun();
        }
        catch (HibernateException he) {
            HibernateConsolePlugin.getDefault().showError(null, "Problem while executing " + this.getText() + "(" + (Object)((Object)he) + ")", he);
        }
    }

    protected abstract void doRun();

    protected final boolean updateSelection(IStructuredSelection selection) {
        boolean enabled = false;
        if (!this.supportMultiple && selection.size() > 1) {
            return false;
        }
        for (Object object : selection) {
            if (object instanceof ConsoleConfiguration) {
                ConsoleConfiguration consoleConfiguration = (ConsoleConfiguration)object;
                enabled |= this.updateState(consoleConfiguration);
                continue;
            }
            enabled = false;
        }
        return enabled;
    }

    protected boolean updateState(ConsoleConfiguration consoleConfiguration) {
        if (this.enabledWhenNoSessionFactory) {
            return true;
        }
        return consoleConfiguration.isSessionFactoryCreated();
    }
}

