/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.eclipse.console;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.hibernate.console.HibernateConsoleRuntimeException;
import org.hibernate.console.preferences.ConsoleConfigurationPreferences;
import org.hibernate.eclipse.console.utils.ClassLoaderHelper;
import org.w3c.dom.Element;

public class EclipseLaunchConsoleConfigurationPreferences
implements ConsoleConfigurationPreferences {
    private final ILaunchConfiguration launchConfiguration;

    public EclipseLaunchConsoleConfigurationPreferences(ILaunchConfiguration configuration) {
        this.launchConfiguration = configuration;
    }

    private File strToFile(String epath) {
        if (epath == null) {
            return null;
        }
        Path path = new Path(epath);
        return this.pathToFile((IPath)path);
    }

    private File pathToFile(IPath path) {
        if (path == null) {
            return null;
        }
        IResource resource = ResourcesPlugin.getWorkspace().getRoot().findMember(path);
        return this.pathToFile(path.toString(), resource);
    }

    private File pathToFile(String path, IResource resource) {
        IPath rawLocation;
        if (resource != null && (rawLocation = resource.getRawLocation()) != null) {
            return rawLocation.toFile();
        }
        throw new HibernateConsoleRuntimeException("Could not resolve " + path + " to a file");
    }

    protected String getAttribute(String attr, String defaultValue) {
        try {
            String value = this.launchConfiguration.getAttribute(attr, defaultValue);
            return value;
        }
        catch (CoreException e) {
            throw new HibernateConsoleRuntimeException((Throwable)e);
        }
    }

    public File getConfigXMLFile() {
        String file = this.getAttribute("org.hibernate.eclipse.launch.CFG_XML_FILE", null);
        return this.strToFile(file);
    }

    public ConsoleConfigurationPreferences.ConfigurationMode getConfigurationMode() {
        return ConsoleConfigurationPreferences.ConfigurationMode.parse((String)this.getAttribute("org.hibernate.eclipse.launch.CONFIGURATION_FACTORY", ""));
    }

    public URL[] getCustomClassPathURLS() {
        try {
            String[] classpath = ClassLoaderHelper.getClasspath(this.launchConfiguration);
            URL[] cp = new URL[classpath.length];
            int i = 0;
            while (i < classpath.length) {
                String str = classpath[i];
                cp[i] = new File(str).toURL();
                ++i;
            }
            return cp;
        }
        catch (CoreException e) {
            throw new HibernateConsoleRuntimeException("Could not compute classpath", (Throwable)e);
        }
        catch (MalformedURLException e) {
            throw new HibernateConsoleRuntimeException("Could not compute classpath", (Throwable)e);
        }
    }

    public String getEntityResolverName() {
        return this.getAttribute("org.hibernate.eclipse.launchENTITY_RESOLVER", null);
    }

    public File[] getMappingFiles() {
        try {
            List mappings = this.launchConfiguration.getAttribute("org.hibernate.eclipse.launch.FILE_MAPPINGS", Collections.EMPTY_LIST);
            File[] result = new File[mappings.size()];
            int i = 0;
            for (String element : mappings) {
                result[i++] = this.strToFile(element);
            }
            return result;
        }
        catch (CoreException e) {
            throw new HibernateConsoleRuntimeException((Throwable)e);
        }
    }

    public String getName() {
        return this.launchConfiguration.getName();
    }

    public String getNamingStrategy() {
        return this.getAttribute("org.hibernate.eclipse.launchNAMING_STRATEGY", null);
    }

    public String getPersistenceUnitName() {
        return this.getAttribute("org.hibernate.eclipse.launch.PERSISTENCE_UNIT_NAME", null);
    }

    public Properties getProperties() {
        File propFile = this.getPropertyFile();
        if (propFile == null) {
            return null;
        }
        try {
            Properties p = new Properties();
            p.load(new FileInputStream(propFile));
            return p;
        }
        catch (IOException io) {
            throw new HibernateConsoleRuntimeException("Could not load property file " + propFile, (Throwable)io);
        }
    }

    public File getPropertyFile() {
        return this.strToFile(this.getAttribute("org.hibernate.eclipse.launch.PROPERTY_FILE", null));
    }

    public void readStateFrom(Element element) {
        throw new IllegalStateException("Cannot read from xml");
    }

    public void setName(String name) {
        throw new IllegalStateException(String.valueOf(this.getName()) + " cannot be renamed");
    }

    public void writeStateTo(Element node) {
        throw new IllegalStateException("Cannot write to xml");
    }
}

