/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.freemarker.preferences;

import java.util.Properties;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.dialogs.PropertyPage;
import org.jboss.ide.eclipse.freemarker.Plugin;
import org.jboss.ide.eclipse.freemarker.configuration.ConfigurationManager;
import org.jboss.ide.eclipse.freemarker.configuration.ContextValue;
import org.jboss.ide.eclipse.freemarker.dialogs.ContextValueDialog;

public class ContextProperties
extends PropertyPage {
    private Table contextValuesTable;
    private Button editContextValueButton;
    private Button deleteContextValueButton;
    private Button addContextValueButton;
    private Properties contextValues;

    public ContextProperties() {
        this.setDescription("Create pre-determined Velocity context variables for all files under this resource");
    }

    protected Control createContents(Composite parent) {
        return this.createContextPage(parent);
    }

    private Control createContextPage(Composite parent) {
        Composite subComp;
        this.contextValues = new Properties();
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(1, true));
        if (this.getElement() instanceof IProject) {
            IProject cfr_ignored_0 = (IProject)this.getElement();
            subComp = new Composite(composite, 0);
            subComp.setLayout((Layout)new GridLayout(2, false));
            subComp.setLayoutData((Object)new GridData(768));
        }
        subComp = new Composite(composite, 0);
        subComp.setLayout((Layout)new GridLayout(1, false));
        subComp.setLayoutData((Object)new GridData(1808));
        new GridData(1536);
        this.contextValuesTable = new Table(subComp, 67840);
        this.contextValuesTable.setVisible(true);
        this.contextValuesTable.setLinesVisible(false);
        this.contextValuesTable.setHeaderVisible(true);
        this.contextValuesTable.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ContextProperties.this.editContextValueButton.setEnabled(true);
                ContextProperties.this.deleteContextValueButton.setEnabled(true);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.contextValuesTable.addKeyListener((KeyListener)new ContextValueDeleteKeyListener());
        this.contextValuesTable.addMouseListener((MouseListener)new EditContextValueButtonListener());
        TableColumn keyColumn = new TableColumn(this.contextValuesTable, 16384);
        TableColumn valueColumn = new TableColumn(this.contextValuesTable, 16384);
        keyColumn.setText("Name");
        valueColumn.setText("Type");
        ColumnWeightData keyColumnLayout = new ColumnWeightData(30, false);
        ColumnWeightData valueColumnLayout = new ColumnWeightData(70, false);
        TableLayout tableLayout = new TableLayout();
        tableLayout.addColumnData((ColumnLayoutData)keyColumnLayout);
        tableLayout.addColumnData((ColumnLayoutData)valueColumnLayout);
        this.contextValuesTable.setLayout((Layout)tableLayout);
        GridData data = new GridData(1808);
        data.heightHint = 50;
        data.grabExcessHorizontalSpace = true;
        data.grabExcessVerticalSpace = true;
        this.contextValuesTable.setLayoutData((Object)data);
        Composite buttonComposite = new Composite(subComp, 0);
        data = new GridData();
        data.horizontalAlignment = 1;
        data.verticalAlignment = 1;
        buttonComposite.setLayoutData((Object)data);
        GridLayout gl = new GridLayout(3, true);
        buttonComposite.setLayout((Layout)gl);
        buttonComposite.setVisible(true);
        this.addContextValueButton = new Button(buttonComposite, 8);
        this.addContextValueButton.setText("New");
        this.addContextValueButton.setVisible(true);
        this.addContextValueButton.addSelectionListener((SelectionListener)new AddContextValueButtonListener());
        data = new GridData();
        data.widthHint = 45;
        data.grabExcessHorizontalSpace = true;
        this.addContextValueButton.setLayoutData((Object)data);
        this.editContextValueButton = new Button(buttonComposite, 8);
        this.editContextValueButton.setText("Edit");
        this.editContextValueButton.addSelectionListener((SelectionListener)new EditContextValueButtonListener());
        data = new GridData();
        data.widthHint = 45;
        data.grabExcessHorizontalSpace = true;
        this.editContextValueButton.setLayoutData((Object)data);
        this.deleteContextValueButton = new Button(buttonComposite, 8);
        this.deleteContextValueButton.setText("Delete");
        this.deleteContextValueButton.addSelectionListener((SelectionListener)new ContextValueDeleteKeyListener());
        data = new GridData();
        data.widthHint = 45;
        data.grabExcessHorizontalSpace = true;
        this.deleteContextValueButton.setLayoutData((Object)data);
        this.reloadContextValues();
        return composite;
    }

    public void reloadContextValues() {
        try {
            this.contextValuesTable.removeAll();
            ContextValue[] values = ConfigurationManager.getInstance(this.getResource().getProject()).getContextValues(this.getResource(), false);
            int i = 0;
            while (i < values.length) {
                TableItem item = new TableItem(this.contextValuesTable, 0);
                String[] arr = new String[]{values[i].name, values[i].objClass.getName()};
                item.setText(arr);
                ++i;
            }
            this.editContextValueButton.setEnabled(false);
            this.deleteContextValueButton.setEnabled(false);
        }
        catch (Exception e) {
            Plugin.log(e);
        }
        this.contextValuesTable.redraw();
    }

    private IResource getResource() {
        return (IResource)this.getElement();
    }

    public boolean performOk() {
        if (this.getElement() instanceof IProject) {
            IProject project = (IProject)this.getElement();
            ConfigurationManager.getInstance(project).reload();
        }
        return super.performOk();
    }

    public class AddContextValueButtonListener
    implements SelectionListener {
        public void mouseDoubleClick(MouseEvent e) {
            this.doWork();
        }

        public void mouseDown(MouseEvent e) {
        }

        public void mouseUp(MouseEvent e) {
        }

        public void widgetSelected(SelectionEvent e) {
            this.doWork();
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void doWork() {
            ContextValueDialog dialog = new ContextValueDialog(new Shell(), null, ContextProperties.this.getResource());
            if (dialog.open() == 0) {
                ContextProperties.this.reloadContextValues();
            }
        }
    }

    public class ContextValueDeleteKeyListener
    implements SelectionListener,
    KeyListener {
        public void widgetSelected(SelectionEvent e) {
            this.doWork();
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void keyPressed(KeyEvent e) {
            if (e.keyCode == 127) {
                this.doWork();
            }
        }

        public void keyReleased(KeyEvent e) {
        }

        public void doWork() {
            int index = ContextProperties.this.contextValuesTable.getSelectionIndex();
            if (index >= 0) {
                try {
                    boolean confirm = MessageDialog.openConfirm((Shell)new Shell(), (String)"Confirmation", (String)"Are you sure you want to delete this context value?");
                    if (confirm) {
                        String key = ContextProperties.this.contextValuesTable.getSelection()[0].getText(0);
                        ContextValue value = ConfigurationManager.getInstance(ContextProperties.this.getResource().getProject()).getContextValue(key, ContextProperties.this.getResource(), false);
                        ConfigurationManager.getInstance(ContextProperties.this.getResource().getProject()).removeContextValue(value.name, ContextProperties.this.getResource());
                        ContextProperties.this.reloadContextValues();
                    }
                }
                catch (Exception e1) {
                    Plugin.log(e1);
                }
            }
        }
    }

    public class EditContextValueButtonListener
    implements SelectionListener,
    MouseListener {
        public void mouseDoubleClick(MouseEvent e) {
            this.doWork();
        }

        public void mouseDown(MouseEvent e) {
        }

        public void mouseUp(MouseEvent e) {
        }

        public void widgetSelected(SelectionEvent e) {
            this.doWork();
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void doWork() {
            int index = ContextProperties.this.contextValuesTable.getSelectionIndex();
            if (index >= 0) {
                String key = ContextProperties.this.contextValuesTable.getSelection()[0].getText(0);
                ContextValue value = ConfigurationManager.getInstance(ContextProperties.this.getResource().getProject()).getContextValue(key, ContextProperties.this.getResource(), false);
                ContextValueDialog dialog = new ContextValueDialog(new Shell(), value, ContextProperties.this.getResource());
                if (dialog.open() == 0) {
                    ContextProperties.this.reloadContextValues();
                }
            }
        }
    }
}

