/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.freemarker.model;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.source.ISourceViewer;
import org.jboss.ide.eclipse.freemarker.configuration.ConfigurationManager;
import org.jboss.ide.eclipse.freemarker.configuration.MacroLibrary;
import org.jboss.ide.eclipse.freemarker.model.AbstractDirective;
import org.jboss.ide.eclipse.freemarker.model.AbstractItem;
import org.jboss.ide.eclipse.freemarker.model.Item;
import org.jboss.ide.eclipse.freemarker.model.MacroDirective;
import org.jboss.ide.eclipse.freemarker.model.MacroEndInstance;

public class MacroInstance
extends AbstractDirective {
    private MacroEndInstance endInstance;
    private String name;
    private Item[] relatedItems;

    protected void init(ITypedRegion region, ISourceViewer viewer, IResource resource) throws Exception {
        this.name = this.getSplitValue(0);
    }

    public boolean isStartItem() {
        return true;
    }

    public void relateItem(Item directive) {
        if (directive instanceof MacroEndInstance) {
            this.endInstance = (MacroEndInstance)directive;
        }
    }

    public boolean relatesToItem(Item directive) {
        if (directive instanceof MacroEndInstance) {
            MacroEndInstance endDirective = (MacroEndInstance)directive;
            return endDirective.getName() == null || endDirective.getName().length() == 0 || endDirective.getName().equals(this.getName());
        }
        return false;
    }

    public MacroEndInstance getEndDirective() {
        return this.endInstance;
    }

    public Item[] getRelatedItems() {
        if (this.relatedItems == null) {
            ArrayList<MacroEndInstance> l = new ArrayList<MacroEndInstance>();
            if (this.getEndDirective() != null) {
                l.add(this.getEndDirective());
            }
            this.relatedItems = l.toArray(new Item[l.size()]);
        }
        return this.relatedItems;
    }

    public String getTreeImage() {
        return "macro_instance.png";
    }

    public String getName() {
        return this.name;
    }

    public ICompletionProposal[] getCompletionProposals(int offset, Map context) {
        AbstractItem.ContentWithOffset contentWithOffset = this.splitContents(offset);
        int index = contentWithOffset.getIndex();
        int subOffset = contentWithOffset.getOffsetInIndex();
        contentWithOffset.getOffset();
        String[] contents = contentWithOffset.getContents();
        if (index == 0 && !contentWithOffset.wasLastCharSpace()) {
            String prefix = contents[index].substring(0, subOffset);
            ArrayList<ICompletionProposal> l = new ArrayList<ICompletionProposal>();
            Iterator i = this.getItemSet().getMacroDefinitions().iterator();
            while (i.hasNext()) {
                MacroDirective macro = (MacroDirective)i.next();
                if (!macro.getName().startsWith(prefix)) continue;
                l.add(this.getCompletionProposal(offset, subOffset, macro.getName(), contents[0]));
            }
            MacroLibrary[] libraries = ConfigurationManager.getInstance(this.getResource().getProject()).getMacroLibraries();
            int i2 = 0;
            while (i2 < libraries.length) {
                int j = 0;
                while (j < libraries[i2].getMacros().length) {
                    MacroDirective macro = libraries[i2].getMacros()[j];
                    if (macro.getName().startsWith(prefix)) {
                        l.add(this.getCompletionProposal(offset, subOffset, macro.getName(), contents[0]));
                    }
                    ++j;
                }
                ++i2;
            }
            return this.completionProposals(l);
        }
        if (contentWithOffset.wasLastCharSpace() || !contents[index - 1].equals("=")) {
            String name = contents[0];
            MacroDirective match = null;
            Iterator i = this.getItemSet().getMacroDefinitions().iterator();
            while (i.hasNext()) {
                MacroDirective macro = (MacroDirective)i.next();
                if (!macro.getName().equals(name)) continue;
                match = macro;
                break;
            }
            if (match == null) {
                MacroLibrary[] libraries = ConfigurationManager.getInstance(this.getResource().getProject()).getMacroLibraries();
                int i3 = 0;
                while (i3 < libraries.length) {
                    int j = 0;
                    while (j < libraries[i3].getMacros().length) {
                        MacroDirective macro = libraries[i3].getMacros()[j];
                        if (macro.getName().equals(name)) {
                            match = macro;
                            break;
                        }
                        ++j;
                    }
                    if (match != null) break;
                    ++i3;
                }
            }
            if (match != null) {
                String prefix = null;
                prefix = contentWithOffset.wasLastCharSpace() || contents.length < index + 1 ? "" : contents[index].substring(0, subOffset);
                ArrayList<ICompletionProposal> l = new ArrayList<ICompletionProposal>();
                int i4 = 0;
                while (i4 < match.getAttributes().length) {
                    if (match.getAttributes()[i4].startsWith(prefix)) {
                        l.add(this.getCompletionProposal(offset, subOffset, match.getAttributes()[i4], contentWithOffset.isNextCharSpace() || contents.length < index + 1 ? "" : contents[index]));
                    }
                    ++i4;
                }
                return this.completionProposals(l);
            }
        }
        return null;
    }
}

