/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.stack;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.net.InetAddress;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.jgroups.Address;
import org.jgroups.util.Util;

public class LogicalAddress1_4
implements Address {
    protected static int count = 1;
    protected String host = null;
    protected long timestamp = 0L;
    protected int id = 0;
    protected boolean multicast_addr = false;
    transient SocketAddress primary_physical_addr = null;
    protected ArrayList physical_addrs = null;
    byte[] additional_data = null;

    public LogicalAddress1_4() {
    }

    public LogicalAddress1_4(String host_name, List physical_addrs) {
        this.init(host_name, physical_addrs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void init(String host_name, List physical_addrs) {
        if (host_name != null) {
            this.host = host_name;
        } else {
            try {
                this.host = InetAddress.getLocalHost().getHostName();
            }
            catch (Exception e) {
                this.host = "localhost";
            }
        }
        this.timestamp = System.currentTimeMillis();
        Class clazz = LogicalAddress1_4.class;
        synchronized (clazz) {
            this.id = count++;
        }
        if (physical_addrs != null) {
            this.physical_addrs = new ArrayList(physical_addrs);
        }
    }

    public String getHost() {
        return this.host;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public long getId() {
        return this.id;
    }

    public SocketAddress getPrimaryPhysicalAddress() {
        return this.primary_physical_addr;
    }

    public void setPrimaryPhysicalAddress(SocketAddress primary_physical_addr) {
        this.primary_physical_addr = primary_physical_addr;
    }

    public ArrayList getPhysicalAddresses() {
        return this.physical_addrs != null ? (ArrayList)this.physical_addrs.clone() : null;
    }

    public void addPhysicalAddress(SocketAddress addr) {
        if (addr != null) {
            if (this.physical_addrs == null) {
                this.physical_addrs = new ArrayList();
            }
            if (!this.physical_addrs.contains(addr)) {
                this.physical_addrs.add(addr);
            }
        }
    }

    public void removePhysicalAddress(SocketAddress addr) {
        if (addr != null && this.physical_addrs != null) {
            this.physical_addrs.remove(addr);
        }
    }

    public void removeAllPhysicalAddresses() {
        if (this.physical_addrs != null) {
            this.physical_addrs.clear();
        }
    }

    public boolean isMulticastAddress() {
        return false;
    }

    public int size() {
        return 22;
    }

    public byte[] getAdditionalData() {
        return this.additional_data;
    }

    public void setAdditionalData(byte[] additional_data) {
        this.additional_data = additional_data;
    }

    public int compare(LogicalAddress1_4 other) {
        return this.compareTo(other);
    }

    public int compareTo(Object o) {
        if (o == null || !(o instanceof LogicalAddress1_4)) {
            throw new ClassCastException("LogicalAddress1_4.compareTo(): comparison between different classes");
        }
        LogicalAddress1_4 other = (LogicalAddress1_4)o;
        int rc = this.host.compareTo(other.host);
        if (rc != 0) {
            return rc;
        }
        if (this.timestamp != other.timestamp) {
            return this.timestamp < other.timestamp ? -1 : 1;
        }
        if (this.id != other.id) {
            return this.id < other.id ? -1 : 1;
        }
        return 0;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        return this.compareTo(obj) == 0;
    }

    public int hashCode() {
        int retval = (int)((long)this.host.hashCode() + this.timestamp + (long)this.id);
        return retval;
    }

    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean print_details) {
        StringBuffer sb = new StringBuffer();
        sb.append(this.host);
        sb.append(':').append(this.id);
        if (print_details) {
            sb.append(" (created ").append(new Date(this.timestamp)).append(')');
            if (this.physical_addrs != null) {
                sb.append("\nphysical addrs: ").append(this.physical_addrs);
            }
        }
        if (this.additional_data != null) {
            sb.append(" (additional data: ").append(this.additional_data.length).append(" bytes)");
        }
        return sb.toString();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.host);
        out.writeLong(this.timestamp);
        out.writeInt(this.id);
        if (this.physical_addrs != null) {
            out.writeInt(this.physical_addrs.size());
            out.writeObject(this.physical_addrs);
        } else {
            out.writeInt(0);
        }
        if (this.additional_data != null) {
            out.writeInt(this.additional_data.length);
            out.write(this.additional_data, 0, this.additional_data.length);
        } else {
            out.writeInt(0);
        }
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.host = (String)in.readObject();
        this.timestamp = in.readLong();
        this.id = in.readInt();
        int len = in.readInt();
        if (len > 0) {
            this.physical_addrs = (ArrayList)in.readObject();
        }
        if ((len = in.readInt()) > 0) {
            this.additional_data = new byte[len];
            in.readFully(this.additional_data, 0, this.additional_data.length);
        }
    }

    public void writeTo(DataOutputStream out) throws IOException {
        Util.writeString(this.host, out);
        out.writeLong(this.timestamp);
        out.writeInt(this.id);
        out.writeBoolean(this.multicast_addr);
        ObjectOutputStream oos = new ObjectOutputStream(out);
        oos.writeObject(this.physical_addrs);
        oos.close();
        Util.writeByteBuffer(this.additional_data, out);
    }

    public void readFrom(DataInputStream in) throws IOException, IllegalAccessException, InstantiationException {
        this.host = Util.readString(in);
        this.timestamp = in.readLong();
        this.id = in.readInt();
        this.multicast_addr = in.readBoolean();
        ObjectInputStream ois = new ObjectInputStream(in);
        try {
            this.physical_addrs = (ArrayList)ois.readObject();
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        this.additional_data = Util.readByteBuffer(in);
    }

    public Object clone() throws CloneNotSupportedException {
        LogicalAddress1_4 ret = new LogicalAddress1_4();
        ret.host = this.host;
        ret.timestamp = this.timestamp;
        ret.id = this.id;
        ret.multicast_addr = this.multicast_addr;
        ret.additional_data = this.additional_data;
        ret.primary_physical_addr = this.primary_physical_addr;
        if (this.physical_addrs != null) {
            ret.physical_addrs = (ArrayList)this.physical_addrs.clone();
        }
        return ret;
    }

    public LogicalAddress1_4 copy() {
        try {
            return (LogicalAddress1_4)this.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }
}

