/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Properties;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import org.jgroups.Event;
import org.jgroups.Header;
import org.jgroups.Message;
import org.jgroups.stack.Protocol;
import org.jgroups.util.Streamable;
import org.jgroups.util.Util;

public class COMPRESS
extends Protocol {
    Deflater deflater = null;
    Inflater inflater = null;
    int compression_level = 9;
    long min_size = 500L;
    static final String name = "COMPRESS";

    public String getName() {
        return name;
    }

    public void init() throws Exception {
        this.deflater = new Deflater(this.compression_level);
        this.inflater = new Inflater();
    }

    public void destroy() {
        this.deflater.end();
        this.deflater = null;
        this.inflater.end();
        this.inflater = null;
    }

    public boolean setProperties(Properties props) {
        super.setProperties(props);
        String str = props.getProperty("compression_level");
        if (str != null) {
            this.compression_level = Integer.parseInt(str);
            props.remove("compression_level");
        }
        if ((str = props.getProperty("min_size")) != null) {
            this.min_size = Long.parseLong(str);
            props.remove("min_size");
        }
        if (props.size() > 0) {
            System.err.println("COMPRESS.setProperties(): the following properties are not recognized:");
            props.list(System.out);
            return false;
        }
        return true;
    }

    public void up(Event evt) {
        block4: {
            byte[] compressed_payload;
            Message msg;
            CompressHeader hdr;
            if (evt.getType() == 1 && (hdr = (CompressHeader)(msg = (Message)evt.getArg()).removeHeader(name)) != null && (compressed_payload = msg.getRawBuffer()) != null && compressed_payload.length > 0) {
                int original_size = hdr.original_size;
                byte[] uncompressed_payload = new byte[original_size];
                this.inflater.reset();
                this.inflater.setInput(compressed_payload, msg.getOffset(), msg.getLength());
                try {
                    this.inflater.inflate(uncompressed_payload);
                    if (this.log.isTraceEnabled()) {
                        this.log.trace((Object)("uncompressed " + compressed_payload.length + " bytes to " + original_size + " bytes"));
                    }
                    msg.setBuffer(uncompressed_payload);
                }
                catch (DataFormatException e) {
                    if (!this.log.isErrorEnabled()) break block4;
                    this.log.error((Object)("exception on uncompression: " + Util.printStackTrace(e)));
                }
            }
        }
        this.passUp(evt);
    }

    public void down(Event evt) {
        Message msg;
        int length;
        if (evt.getType() == 1 && (long)(length = (msg = (Message)evt.getArg()).getLength()) >= this.min_size) {
            byte[] payload = msg.getRawBuffer();
            byte[] compressed_payload = new byte[length];
            this.deflater.reset();
            this.deflater.setInput(payload, msg.getOffset(), length);
            this.deflater.finish();
            this.deflater.deflate(compressed_payload);
            int compressed_size = this.deflater.getTotalOut();
            byte[] new_payload = new byte[compressed_size];
            System.arraycopy(compressed_payload, 0, new_payload, 0, compressed_size);
            msg.setBuffer(new_payload);
            msg.putHeader(name, new CompressHeader(length));
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("compressed payload from " + length + " bytes to " + compressed_size + " bytes"));
            }
        }
        this.passDown(evt);
    }

    public static class CompressHeader
    extends Header
    implements Streamable {
        int original_size = 0;

        public CompressHeader() {
        }

        public CompressHeader(int s) {
            this.original_size = s;
        }

        public long size() {
            return 4L;
        }

        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeInt(this.original_size);
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.original_size = in.readInt();
        }

        public void writeTo(DataOutputStream out) throws IOException {
            out.writeInt(this.original_size);
        }

        public void readFrom(DataInputStream in) throws IOException, IllegalAccessException, InstantiationException {
            this.original_size = in.readInt();
        }
    }
}

