/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.system;

import org.jboss.logging.Logger;
import org.jboss.mx.interceptor.AbstractInterceptor;
import org.jboss.mx.interceptor.Interceptor;
import org.jboss.mx.server.Interceptable;
import org.jboss.mx.server.Invocation;
import org.jboss.system.InterceptorServiceMBean;
import org.jboss.system.ServiceMBeanSupport;

public abstract class InterceptorServiceMBeanSupport
extends ServiceMBeanSupport
implements InterceptorServiceMBean {
    private Interceptable interceptable;
    private Interceptor interceptor;

    public InterceptorServiceMBeanSupport() {
    }

    public InterceptorServiceMBeanSupport(Class type) {
        super(type);
    }

    public InterceptorServiceMBeanSupport(String category) {
        super(category);
    }

    public InterceptorServiceMBeanSupport(Logger log) {
        super(log);
    }

    public void setInterceptable(Interceptable interceptable) {
        this.interceptable = interceptable;
    }

    public Interceptable getInterceptable() {
        return this.interceptable;
    }

    public void attach() {
        if (this.interceptable != null) {
            this.interceptor = new AttachedInterceptor();
            this.interceptable.addOperationInterceptor(this.interceptor);
        }
    }

    public void detach() {
        if (this.interceptable != null) {
            this.interceptable.removeOperationInterceptor(this.interceptor);
            this.interceptor = null;
        }
    }

    public void startService() throws Exception {
        this.attach();
    }

    public void stopService() {
        this.detach();
    }

    public Object invoke(Invocation invocation) throws Throwable {
        AbstractInterceptor next = invocation.nextInterceptor();
        if (next != null) {
            return next.invoke(invocation);
        }
        return invocation.dispatch();
    }

    private class AttachedInterceptor
    extends AbstractInterceptor {
        public AttachedInterceptor() {
            super("AttachedInterceptor from '" + InterceptorServiceMBeanSupport.this.getServiceName() + "'");
        }

        public Object invoke(Invocation invocation) throws Throwable {
            return InterceptorServiceMBeanSupport.this.invoke(invocation);
        }
    }
}

