/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.interceptors;

import java.lang.reflect.Method;
import java.util.List;
import org.jboss.cache.GlobalTransaction;
import org.jboss.cache.InvocationContext;
import org.jboss.cache.TreeCache;
import org.jboss.cache.config.Option;
import org.jboss.cache.interceptors.BaseRpcInterceptor;
import org.jgroups.blocks.MethodCall;

public class ReplicationInterceptor
extends BaseRpcInterceptor {
    public Object invoke(MethodCall m) throws Throwable {
        InvocationContext ctx = this.getInvocationContext();
        Option optionOverride = ctx.getOptionOverrides();
        if (optionOverride != null && optionOverride.isCacheModeLocal()) {
            return super.invoke(m);
        }
        Method method = m.getMethod();
        if (ctx.getTransaction() != null) {
            GlobalTransaction gtx = ctx.getGlobalTransaction();
            if (this.containsModifications(m) && gtx != null && !gtx.isRemote()) {
                if (method.equals(TreeCache.commitMethod)) {
                    this.replicateCall(m, this.cache.getSyncCommitPhase());
                } else if (method.equals(TreeCache.prepareMethod)) {
                    this.runPreparePhase(m, gtx);
                } else if (method.equals(TreeCache.rollbackMethod)) {
                    this.replicateCall(m, this.cache.getSyncRollbackPhase());
                }
            }
        } else if (TreeCache.isCrudMethod(method)) {
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)"Non-tx crud meth");
            }
            if (ctx.isOriginLocal()) {
                this.handleReplicatedMethod(m, this.cache.getCacheModeInternal());
            }
        } else if (this.log.isTraceEnabled()) {
            this.log.trace((Object)"Non-tx and non crud meth");
        }
        return super.invoke(m);
    }

    private boolean containsModifications(MethodCall m) {
        if (m.getMethod().equals(TreeCache.prepareMethod)) {
            List mods = (List)m.getArgs()[1];
            return mods.size() > 0;
        }
        if (m.getMethod().equals(TreeCache.commitMethod) || m.getMethod().equals(TreeCache.rollbackMethod)) {
            return (Boolean)m.getArgs()[1];
        }
        return false;
    }

    void handleReplicatedMethod(MethodCall m, int mode) throws Throwable {
        if (mode == 3 && m.equals(TreeCache.putFailFastKeyValueMethodLocal)) {
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)"forcing asynchronous replication for putFailFast()");
            }
            mode = 2;
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("invoking method " + m.getName() + "(" + m.getArgs() + ")" + ", members=" + this.cache.getMembers() + ", mode=" + this.cache.getCacheMode() + ", exclude_self=" + true + ", timeout=" + this.cache.getSyncReplTimeout()));
        }
        switch (mode) {
            case 2: {
                this.replicateCall(m, false);
                break;
            }
            case 3: {
                this.replicateCall(m, true);
            }
        }
    }

    protected void runPreparePhase(MethodCall prepareMethod, GlobalTransaction gtx) throws Throwable {
        boolean async;
        boolean bl = async = this.cache.getCacheModeInternal() == 2;
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("(" + this.cache.getLocalAddress() + "): running remote prepare for global tx " + gtx + " with async mode=" + async));
        }
        this.replicateCall(prepareMethod, !async);
    }
}

