/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.interceptors;

import EDU.oswego.cs.dl.util.concurrent.ConcurrentHashMap;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import org.jboss.cache.CacheException;
import org.jboss.cache.GlobalTransaction;
import org.jboss.cache.InvocationContext;
import org.jboss.cache.TreeCache;
import org.jboss.cache.config.Option;
import org.jboss.cache.interceptors.BaseRpcInterceptor;
import org.jgroups.blocks.MethodCall;

public class OptimisticReplicationInterceptor
extends BaseRpcInterceptor {
    private Map broadcastTxs = new ConcurrentHashMap();

    public void setCache(TreeCache cache) {
        super.setCache(cache);
    }

    public Object invoke(MethodCall m) throws Throwable {
        InvocationContext ctx = this.getInvocationContext();
        Option optionOverride = ctx.getOptionOverrides();
        if (optionOverride != null && optionOverride.isCacheModeLocal()) {
            return super.invoke(m);
        }
        Object retval = null;
        Method meth = m.getMethod();
        if (ctx.getTransaction() != null) {
            GlobalTransaction gtx = ctx.getGlobalTransaction();
            if (gtx == null) {
                throw new CacheException("failed to get global transaction");
            }
            this.log.debug((Object)(" received method " + m));
            if (meth.equals(TreeCache.optimisticPrepareMethod)) {
                retval = super.invoke(m);
                if (!gtx.isRemote() && (retval = this.broadcastPrepare(m, gtx)) instanceof Throwable) {
                    throw (Throwable)retval;
                }
            } else if (meth.equals(TreeCache.commitMethod)) {
                Throwable temp = null;
                if (!gtx.isRemote() && this.broadcastTxs.containsKey(gtx)) {
                    try {
                        this.broadcastCommit(m, gtx);
                    }
                    catch (Throwable t) {
                        this.log.error((Object)" a problem occurred with remote commit", t);
                        temp = t;
                    }
                }
                retval = super.invoke(m);
                if (temp != null) {
                    throw temp;
                }
            } else if (meth.equals(TreeCache.rollbackMethod)) {
                Throwable temp = null;
                if (!gtx.isRemote() && this.broadcastTxs.containsKey(gtx)) {
                    try {
                        this.broadcastRollback(m, gtx);
                    }
                    catch (Throwable t) {
                        this.log.error((Object)" a problem occurred with remote rollback", t);
                        temp = t;
                    }
                }
                retval = super.invoke(m);
                if (temp != null) {
                    throw temp;
                }
            } else {
                this.log.debug((Object)(" received method " + m + " not handling"));
                retval = super.invoke(m);
            }
        } else {
            throw new CacheException("transaction does not exist");
        }
        return retval;
    }

    protected Object broadcastPrepare(MethodCall methodCall, GlobalTransaction gtx) throws Throwable {
        int num_mods;
        boolean remoteCallSync = this.cache.getCacheModeInternal() == 3;
        Object[] args = methodCall.getArgs();
        List modifications = (List)args[1];
        int n = num_mods = modifications != null ? modifications.size() : 0;
        if (this.cache.getMembers() != null && this.cache.getMembers().size() > 1) {
            this.broadcastTxs.put(gtx, gtx);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("(" + this.cache.getLocalAddress() + "): broadcasting prepare for " + gtx + " (" + num_mods + " modifications"));
            }
            this.replicateCall(methodCall, remoteCallSync);
        } else if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("(" + this.cache.getLocalAddress() + "):not broadcasting prepare as members are " + this.cache.getMembers()));
        }
        return null;
    }

    protected void broadcastCommit(MethodCall methodCall, GlobalTransaction gtx) throws Throwable {
        Boolean hasMods;
        boolean remoteCallSync = this.cache.getSyncCommitPhase();
        Object[] args = methodCall.getArgs();
        Boolean bl = hasMods = this.hasModifications(methodCall) ? Boolean.TRUE : Boolean.FALSE;
        if (this.cache.getMembers() != null && this.cache.getMembers().size() > 1) {
            try {
                this.broadcastTxs.remove(gtx);
                MethodCall commit_method = new MethodCall(TreeCache.commitMethod, new Object[]{gtx, hasMods});
                this.log.debug((Object)("running remote commit for " + gtx + " and coord=" + this.cache.getLocalAddress()));
                this.replicateCall(commit_method, remoteCallSync);
            }
            catch (Exception e) {
                this.log.fatal((Object)"commit failed", (Throwable)e);
                throw e;
            }
        }
    }

    protected void broadcastRollback(MethodCall methodCall, GlobalTransaction gtx) throws Throwable {
        Boolean hasMods;
        boolean remoteCallSync = this.cache.getSyncRollbackPhase();
        Object[] args = methodCall.getArgs();
        Boolean bl = hasMods = this.hasModifications(methodCall) ? Boolean.TRUE : Boolean.FALSE;
        if (this.cache.getMembers() != null && this.cache.getMembers().size() > 1) {
            try {
                this.broadcastTxs.remove(gtx);
                MethodCall rollback_method = new MethodCall(TreeCache.rollbackMethod, new Object[]{gtx, hasMods});
                this.log.debug((Object)("running remote rollback for " + gtx + " and coord=" + this.cache.getLocalAddress()));
                this.replicateCall(rollback_method, remoteCallSync);
            }
            catch (Exception e) {
                this.log.error((Object)"rollback failed", (Throwable)e);
                throw e;
            }
        }
    }

    private boolean hasModifications(MethodCall m) {
        Method meth = m.getMethod();
        boolean hasMods = false;
        if (meth.equals(TreeCache.prepareMethod) || meth.equals(TreeCache.optimisticPrepareMethod)) {
            List mods = (List)m.getArgs()[1];
            hasMods = mods != null && mods.size() > 0;
        } else if (meth.equals(TreeCache.commitMethod) || meth.equals(TreeCache.rollbackMethod)) {
            Boolean mods = (Boolean)m.getArgs()[1];
            hasMods = mods;
        }
        return hasMods;
    }
}

