/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.interceptors;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.jboss.cache.TreeCache;
import org.jboss.cache.interceptors.CacheMgmtInterceptorMBean;
import org.jboss.cache.interceptors.Interceptor;
import org.jgroups.blocks.MethodCall;

public class CacheMgmtInterceptor
extends Interceptor
implements CacheMgmtInterceptorMBean {
    private long m_hit_times = 0L;
    private long m_miss_times = 0L;
    private long m_store_times = 0L;
    private long m_hits = 0L;
    private long m_misses = 0L;
    private long m_stores = 0L;
    private long m_evictions = 0L;
    private long m_start;
    private long m_reset = this.m_start = System.currentTimeMillis();

    public void setCache(TreeCache cache) {
        super.setCache(cache);
    }

    public Object invoke(MethodCall m) throws Throwable {
        Method meth = m.getMethod();
        Object[] args = m.getArgs();
        Object retval = null;
        if (!this.statsEnabled) {
            return super.invoke(m);
        }
        if (meth.equals(TreeCache.getKeyValueMethodLocal)) {
            long t1 = System.currentTimeMillis();
            retval = super.invoke(m);
            long t2 = System.currentTimeMillis();
            if (retval == null) {
                this.m_miss_times += t2 - t1;
                ++this.m_misses;
            } else {
                this.m_hit_times += t2 - t1;
                ++this.m_hits;
            }
        } else if (meth.equals(TreeCache.putKeyValMethodLocal) || meth.equals(TreeCache.putFailFastKeyValueMethodLocal)) {
            long t1 = System.currentTimeMillis();
            retval = super.invoke(m);
            long t2 = System.currentTimeMillis();
            this.m_store_times += t2 - t1;
            ++this.m_stores;
        } else if (meth.equals(TreeCache.putDataMethodLocal) || meth.equals(TreeCache.putDataEraseMethodLocal)) {
            Map attributes = (Map)args[2];
            long t1 = System.currentTimeMillis();
            retval = super.invoke(m);
            long t2 = System.currentTimeMillis();
            if (attributes != null && attributes.size() > 0) {
                this.m_store_times += t2 - t1;
                this.m_stores += (long)attributes.size();
            }
        } else if (meth.equals(TreeCache.evictNodeMethodLocal) || meth.equals(TreeCache.evictVersionedNodeMethodLocal)) {
            retval = super.invoke(m);
            ++this.m_evictions;
        } else {
            retval = super.invoke(m);
        }
        return retval;
    }

    public long getHits() {
        return this.m_hits;
    }

    public long getMisses() {
        return this.m_misses;
    }

    public long getStores() {
        return this.m_stores;
    }

    public long getEvictions() {
        return this.m_evictions;
    }

    public double getHitMissRatio() {
        double total = this.m_hits + this.m_misses;
        if (total == 0.0) {
            return 0.0;
        }
        return (double)this.m_hits / total;
    }

    public double getReadWriteRatio() {
        if (this.m_stores == 0L) {
            return 0.0;
        }
        return (double)(this.m_hits + this.m_misses) / (double)this.m_stores;
    }

    public long getAverageReadTime() {
        long total = this.m_hits + this.m_misses;
        if (total == 0L) {
            return 0L;
        }
        return (this.m_hit_times + this.m_miss_times) / total;
    }

    public long getAverageWriteTime() {
        if (this.m_stores == 0L) {
            return 0L;
        }
        return this.m_store_times / this.m_stores;
    }

    public int getNumberOfAttributes() {
        return this.cache.getNumberOfAttributes();
    }

    public int getNumberOfNodes() {
        return this.cache.getNumberOfNodes();
    }

    public long getElapsedTime() {
        return (System.currentTimeMillis() - this.m_start) / 1000L;
    }

    public long getTimeSinceReset() {
        return (System.currentTimeMillis() - this.m_reset) / 1000L;
    }

    public Map dumpStatistics() {
        HashMap<String, Number> retval = new HashMap<String, Number>();
        retval.put("hits", new Long(this.m_hits));
        retval.put("misses", new Long(this.m_misses));
        retval.put("stores", new Long(this.m_stores));
        retval.put("evictions", new Long(this.m_evictions));
        retval.put("attributes", new Integer(this.cache.getNumberOfAttributes()));
        retval.put("nodes", new Integer(this.cache.getNumberOfNodes()));
        retval.put("elapsedTime", new Long(this.getElapsedTime()));
        retval.put("timeSinceReset", new Long(this.getTimeSinceReset()));
        retval.put("averageReadTime", new Long(this.getAverageReadTime()));
        retval.put("averageWriteTime", new Long(this.getAverageWriteTime()));
        return retval;
    }

    public void resetStatistics() {
        this.m_hits = 0L;
        this.m_misses = 0L;
        this.m_stores = 0L;
        this.m_evictions = 0L;
        this.m_reset = System.currentTimeMillis();
    }
}

