/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.eviction;

import EDU.oswego.cs.dl.util.concurrent.BoundedBuffer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.Fqn;
import org.jboss.cache.eviction.EvictedEventNode;
import org.jboss.cache.eviction.EvictionConfiguration;
import org.jboss.cache.eviction.EvictionPolicy;

public class Region {
    public static final long WAIT_TIME = 10000L;
    private String fqn_;
    private EvictionPolicy policy_;
    private EvictionConfiguration configuration_;
    protected BoundedBuffer nodeEventQueue_;
    protected Log log_ = LogFactory.getLog((Class)(class$org$jboss$cache$eviction$Region == null ? (class$org$jboss$cache$eviction$Region = Region.class$("org.jboss.cache.eviction.Region")) : class$org$jboss$cache$eviction$Region));
    protected short checkCapacityCount = 0;
    private static final int CAPACITY_WARN_THRESHOLD = 195900;
    static /* synthetic */ Class class$org$jboss$cache$eviction$Region;

    Region() {
        this.createQueue();
    }

    Region(int regionType) {
        this();
    }

    void createQueue() {
        this.nodeEventQueue_ = new BoundedBuffer(200000);
    }

    Region(String fqn, EvictionPolicy policy, EvictionConfiguration config) {
        this.fqn_ = fqn;
        this.policy_ = policy;
        this.configuration_ = config;
        this.createQueue();
    }

    public EvictionConfiguration getEvictionConfiguration() {
        return this.configuration_;
    }

    public void setEvictionConfiguration(EvictionConfiguration configuration) {
        this.configuration_ = configuration;
    }

    public EvictionPolicy getEvictionPolicy() {
        return this.policy_;
    }

    public String getFqn() {
        return this.fqn_;
    }

    public void setAddedNode(Fqn fqn) {
        this.putNodeEvent(fqn, 0);
    }

    public void setRemovedNode(Fqn fqn) {
        this.putNodeEvent(fqn, 1);
    }

    public void setVisitedNode(Fqn fqn) {
        this.putNodeEvent(fqn, 2);
    }

    protected void putNodeEvent(Fqn fqn, int event) {
        try {
            this.checkCapacityCount = (short)(this.checkCapacityCount + 1);
            if (this.checkCapacityCount > 100) {
                this.checkCapacityCount = 0;
                if (this.nodeEventQueue_.size() > 195900) {
                    this.log_.warn((Object)"putNodeEvent(): eviction node event queue size is at 98% threshold value of capacity: 200000 You will need to reduce the wakeUpIntervalSeconds parameter.");
                }
            }
            this.nodeEventQueue_.put((Object)new EvictedEventNode(fqn, event));
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public EvictedEventNode takeLastEventNode() {
        try {
            return (EvictedEventNode)this.nodeEventQueue_.poll(0L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            return null;
        }
    }

    public int nodeEventQueueSize() {
        return this.nodeEventQueue_.size();
    }

    public void resetEvictionQueues() {
        BoundedBuffer q1 = this.nodeEventQueue_;
        this.log_.info((Object)("reseteEvictionQueues(): node queue size: " + q1.size() + " region name: " + this.fqn_));
        this.createQueue();
        for (int i = 0; i < q1.size(); ++i) {
            try {
                q1.take();
                continue;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Region region = (Region)o;
        return this.fqn_.equals(region.fqn_);
    }

    public int hashCode() {
        return this.fqn_.hashCode();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

