/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.aop;

import java.util.Iterator;
import java.util.Map;
import java.util.WeakHashMap;
import javax.transaction.SystemException;
import javax.transaction.TransactionManager;
import org.jboss.cache.CacheException;
import org.jboss.cache.DataNode;
import org.jboss.cache.Fqn;
import org.jboss.cache.GlobalTransaction;
import org.jboss.cache.RegionNotEmptyException;
import org.jboss.cache.TreeCache;
import org.jboss.cache.aop.CachedType;
import org.jboss.cache.aop.InternalDelegate;
import org.jboss.cache.aop.TreeCacheAopDelegate;
import org.jboss.cache.aop.TreeCacheAopIfc;
import org.jboss.cache.aop.TreeCacheAopMBean;
import org.jboss.cache.aop.util.ObjectUtil;
import org.jboss.cache.eviction.AopEvictionPolicy;
import org.jboss.cache.marshall.Region;
import org.jboss.cache.marshall.RegionNameConflictException;
import org.jboss.cache.transaction.BatchModeTransactionManager;
import org.jboss.util.NestedRuntimeException;
import org.jgroups.JChannel;

public class TreeCacheAop
extends TreeCache
implements TreeCacheAopMBean,
TreeCacheAopIfc {
    protected Map cachedTypes = new WeakHashMap();
    public static final String DUMMY = "dummy";
    TransactionManager localTm_ = BatchModeTransactionManager.getInstance();
    protected TreeCacheAopDelegate delegate_;

    public TreeCacheAop(String cluster_name, String props, long state_fetch_timeout) throws Exception {
        super(cluster_name, props, state_fetch_timeout);
        this.init();
    }

    public TreeCacheAop() throws Exception {
        this.init();
    }

    public TreeCacheAop(JChannel channel) throws Exception {
        super(channel);
        this.init();
    }

    protected void init() {
        this.delegate_ = new TreeCacheAopDelegate(this);
    }

    public void setEvictionPolicyClass(String eviction_policy_class) {
        this.eviction_policy_class = eviction_policy_class;
        if (eviction_policy_class == null || eviction_policy_class.length() == 0) {
            return;
        }
        try {
            Object obj = this.loadClass(eviction_policy_class).newInstance();
            if (!(obj instanceof AopEvictionPolicy)) {
                throw new RuntimeException("TreeCacheAop.setEvictionPolicyClass(). Eviction policy provider:" + eviction_policy_class + " is not an instance of AopEvictionPolicy.");
            }
            super.setEvictionPolicyClass(eviction_policy_class);
        }
        catch (RuntimeException ex) {
            log.error((Object)("setEvictionPolicyClass(): failed creating instance of  " + eviction_policy_class), (Throwable)ex);
            throw ex;
        }
        catch (Throwable t) {
            log.error((Object)("setEvictionPolicyClass(): failed creating instance of  " + eviction_policy_class), t);
        }
    }

    public void evict(Fqn fqn) throws CacheException {
        if (this.delegate_.isAopNode(fqn)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("evict(): evicting whole aop node " + fqn));
            }
            this.recursiveEvict(fqn);
        } else {
            super.evict(fqn);
        }
    }

    void recursiveEvict(Fqn fqn) throws CacheException {
        boolean create_undo_ops = true;
        boolean sendNodeEvent = false;
        this._remove((GlobalTransaction)null, fqn, create_undo_ops, sendNodeEvent);
    }

    void plainEvict(Fqn fqn) throws CacheException {
        super.evict(fqn);
    }

    protected void _evictSubtree(Fqn subtree) throws CacheException {
        if (log.isTraceEnabled()) {
            log.trace((Object)("_evictSubtree(" + subtree + ")"));
        }
        if (this.delegate_.isAopNode(subtree)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("evict(): evicting whole aop node " + subtree));
            }
            this.recursiveEvict(subtree);
        } else {
            super._evictSubtree(subtree);
        }
    }

    public void activateRegion(String subtreeFqn) throws RegionNotEmptyException, RegionNameConflictException, CacheException {
        if (!this.useMarshalling_) {
            throw new IllegalStateException("TreeCache.activateRegion(). useMarshalling flag is not set!");
        }
        if ("/".equals(subtreeFqn)) {
            super.activateRegion(subtreeFqn);
        } else {
            Region region = this.regionManager_.getRegion(InternalDelegate.JBOSS_INTERNAL.toString());
            if (region == null && this.inactiveOnStartup || region != null && region.isInactive()) {
                super.activateRegion(InternalDelegate.JBOSS_INTERNAL.toString());
            }
            if (this.get(InternalDelegate.JBOSS_INTERNAL_MAP) == null) {
                this.createSubtreeRootNode(InternalDelegate.JBOSS_INTERNAL_MAP);
            }
            super.activateRegion(subtreeFqn);
        }
    }

    protected void acquireLocksForStateTransfer(DataNode root, Object lockOwner, long timeout, boolean force) throws Exception {
        DataNode refMapNode;
        super.acquireLocksForStateTransfer(root, lockOwner, timeout, true, force);
        Fqn fqn = root.getFqn();
        if (fqn.size() > 0 && !fqn.isChildOf(InternalDelegate.JBOSS_INTERNAL) && (refMapNode = this.get(InternalDelegate.JBOSS_INTERNAL_MAP)) != null) {
            super.acquireLocksForStateTransfer(refMapNode, lockOwner, timeout, false, force);
            Map children = refMapNode.getChildren();
            if (children != null) {
                String targetFqn = ObjectUtil.getIndirectFqn(fqn.toString());
                Iterator iter = children.entrySet().iterator();
                while (iter.hasNext()) {
                    Map.Entry entry = iter.next();
                    if (!((String)entry.getKey()).startsWith(targetFqn)) continue;
                    super.acquireLocksForStateTransfer((DataNode)entry.getValue(), lockOwner, timeout, false, force);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void releaseStateTransferLocks(DataNode root, Object lockOwner) {
        block8: {
            boolean releaseInternal = true;
            try {
                super.releaseStateTransferLocks(root, lockOwner, true);
                Fqn fqn = root.getFqn();
                releaseInternal = fqn.size() > 0 && !fqn.isChildOf(InternalDelegate.JBOSS_INTERNAL);
                Object var6_5 = null;
                if (!releaseInternal) break block8;
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                if (releaseInternal) {
                    try {
                        DataNode refMapNode = this.get(InternalDelegate.JBOSS_INTERNAL_MAP);
                        if (refMapNode != null) {
                            super.releaseStateTransferLocks(refMapNode, lockOwner, true);
                        }
                    }
                    catch (CacheException ce) {
                        log.error((Object)"Caught exception releasing locks on internal RefMap", (Throwable)((Object)ce));
                    }
                }
                throw throwable;
            }
            try {
                DataNode refMapNode = this.get(InternalDelegate.JBOSS_INTERNAL_MAP);
                if (refMapNode != null) {
                    super.releaseStateTransferLocks(refMapNode, lockOwner, true);
                }
            }
            catch (CacheException ce) {
                log.error((Object)"Caught exception releasing locks on internal RefMap", (Throwable)((Object)ce));
            }
        }
    }

    public synchronized CachedType getCachedType(Class clazz) {
        CachedType type = (CachedType)this.cachedTypes.get(clazz);
        if (type == null) {
            type = new CachedType(clazz);
            this.cachedTypes.put(clazz, type);
        }
        return type;
    }

    public Object getObject(String fqn) throws CacheException {
        return this.getObject(Fqn.fromString(fqn));
    }

    public Object getObject(Fqn fqn) throws CacheException {
        Object obj = this._getObject(fqn);
        return obj;
    }

    public Object putObject(String fqn, Object obj) throws CacheException {
        return this.putObject(Fqn.fromString(fqn), obj);
    }

    public Object putObject(Fqn fqn, Object obj) throws CacheException {
        if (this.hasCurrentTransaction()) {
            return this._putObject(fqn, obj);
        }
        try {
            this.localTm_.begin();
            this.put(fqn, (Object)DUMMY, (Object)DUMMY);
            Object objOld = this._putObject(fqn, obj);
            this.remove(fqn, (Object)DUMMY);
            Object object = objOld;
            return object;
        }
        catch (Exception e) {
            e.printStackTrace();
            try {
                this.localTm_.setRollbackOnly();
            }
            catch (Exception exn) {
                exn.printStackTrace();
            }
            throw new NestedRuntimeException("TreeCacheAop.putObject(): ", (Throwable)e);
        }
        finally {
            this.endTransaction();
        }
    }

    public Object removeObject(String fqn) throws CacheException {
        return this.removeObject(Fqn.fromString(fqn));
    }

    public Object removeObject(Fqn fqn) throws CacheException {
        if (this.hasCurrentTransaction()) {
            return this._removeObject(fqn, true);
        }
        try {
            this.localTm_.begin();
            this.put(fqn, (Object)DUMMY, (Object)DUMMY);
            Object obj = this._removeObject(fqn, true);
            this.remove(fqn, (Object)DUMMY);
            Object object = obj;
            return object;
        }
        catch (Exception e) {
            e.printStackTrace();
            try {
                this.localTm_.setRollbackOnly();
            }
            catch (Exception exn) {
                exn.printStackTrace();
            }
            throw new NestedRuntimeException("TreeCacheAop.removeObject(): ", (Throwable)e);
        }
        finally {
            this.endTransaction();
        }
    }

    public Map findObjects(String fqn) throws CacheException {
        return this.findObjects(Fqn.fromString(fqn));
    }

    public Map findObjects(Fqn fqn) throws CacheException {
        return this._findObjects(fqn);
    }

    protected boolean hasCurrentTransaction() {
        try {
            if (this.getCurrentTransaction() != null || this.localTm_.getTransaction() != null) {
                return true;
            }
        }
        catch (SystemException e) {
            e.printStackTrace();
        }
        return false;
    }

    protected void endTransaction() {
        try {
            if (this.localTm_.getTransaction().getStatus() != 1) {
                this.localTm_.commit();
            } else {
                this.localTm_.rollback();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new NestedRuntimeException("TreeCacheAop.endTransaction(): ", (Throwable)e);
        }
    }

    protected Object _getObject(Fqn fqn) throws CacheException {
        return this.delegate_._getObject(fqn);
    }

    protected Object _putObject(Fqn fqn, Object obj) throws CacheException {
        return this.delegate_._putObject(fqn, obj);
    }

    protected Object _removeObject(Fqn fqn, boolean removeCacheInterceptor) throws CacheException {
        boolean evict = false;
        return this.delegate_._removeObject(fqn, removeCacheInterceptor, evict);
    }

    protected Object _evictObject(Fqn fqn) throws CacheException {
        boolean evict = true;
        boolean removeCacheInterceptor = false;
        return this.delegate_._removeObject(fqn, removeCacheInterceptor, evict);
    }

    protected Map _findObjects(Fqn fqn) throws CacheException {
        return this.delegate_._findObjects(fqn);
    }
}

