/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.xml.binding.metadata;

import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import org.jboss.xml.binding.metadata.JavaValue;
import org.jboss.xml.binding.metadata.XmlAttribute;
import org.jboss.xml.binding.metadata.XmlAttributeImpl;
import org.jboss.xml.binding.metadata.XmlDataContent;
import org.jboss.xml.binding.metadata.XmlDataContentImpl;
import org.jboss.xml.binding.metadata.XmlElement;
import org.jboss.xml.binding.metadata.XmlElementImpl;
import org.jboss.xml.binding.metadata.XmlNamespace;
import org.jboss.xml.binding.metadata.XmlType;

public class XmlTypeImpl
implements XmlType {
    protected final String name;
    protected final XmlNamespace ns;
    private final JavaValue javaValue;
    private final Map elements = new HashMap();
    private final Map attributes = new HashMap();
    private XmlDataContent dataContent;

    public XmlTypeImpl(String name, XmlNamespace ns) {
        this.name = name;
        this.ns = ns;
        this.javaValue = new JavaValue();
    }

    public String getName() {
        return this.name;
    }

    public XmlNamespace getNamespace() {
        return this.ns;
    }

    public JavaValue getJavaValue() {
        return this.javaValue;
    }

    public XmlDataContent getDataContent() {
        return this.dataContent;
    }

    public XmlElement getElement(String namespaceUri, String name) {
        return (XmlElement)this.elements.get(new QName(namespaceUri, name));
    }

    public XmlAttribute getAttribute(String namespaceUri, String name) {
        return (XmlAttribute)this.attributes.get(new QName(namespaceUri, name));
    }

    public XmlElement addElement(XmlNamespace ns, String name, XmlType xmlType) {
        XmlElementImpl element = new XmlElementImpl(ns, name, xmlType);
        this.elements.put(new QName(ns.getNamespaceUri(), name), element);
        return element;
    }

    public XmlElement addElement(XmlNamespace ns, String name) {
        XmlTypeImpl type = new XmlTypeImpl(name + "Type", ns);
        return this.addElement(ns, name, type);
    }

    public XmlElement addElement(String name, XmlType xmlType) {
        return this.addElement(this.ns, name, xmlType);
    }

    public XmlElement addElement(String name) {
        return this.addElement(this.ns, name);
    }

    public XmlAttribute addAttribute(XmlNamespace ns, String name, XmlType xmlType) {
        XmlAttributeImpl attr = new XmlAttributeImpl(ns, name, xmlType);
        this.attributes.put(new QName(ns.getNamespaceUri(), name), attr);
        return attr;
    }

    public XmlAttribute addAttribute(XmlNamespace ns, String name) {
        XmlTypeImpl type = new XmlTypeImpl(name + "Type", ns);
        return this.addAttribute(ns, name, type);
    }

    public XmlAttribute addAttribute(String name, XmlType xmlType) {
        return this.addAttribute(this.ns, name, xmlType);
    }

    public XmlAttribute addAttribute(String name) {
        return this.addAttribute(this.ns, name);
    }

    public XmlDataContent addDataContent(XmlType xmlType) {
        this.dataContent = new XmlDataContentImpl(xmlType);
        return this.dataContent;
    }

    public XmlDataContent addDataContent() {
        XmlTypeImpl dataType = new XmlTypeImpl(this.name + "Data", this.ns);
        this.dataContent = new XmlDataContentImpl(dataType);
        return this.dataContent;
    }
}

