/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.console.node;

import org.hibernate.SessionFactory;
import org.hibernate.console.ConsoleConfiguration;
import org.hibernate.console.ConsoleConfigurationListener;
import org.hibernate.console.QueryPage;
import org.hibernate.console.node.BaseNode;
import org.hibernate.console.node.NodeFactory;

public class ConfigurationNode
extends BaseNode {
    private final ConsoleConfiguration configuration;
    private boolean childrenCreated;

    public ConfigurationNode(BaseNode parent, ConsoleConfiguration configuration) {
        super(null, parent);
        this.configuration = configuration;
        configuration.addConsoleConfigurationListener(new ConsoleConfigurationListener(){

            public void sessionFactoryBuilt(ConsoleConfiguration ccfg, SessionFactory builtSessionFactory) {
                ConfigurationNode.this.clear();
            }

            public void sessionFactoryClosing(ConsoleConfiguration configuration, SessionFactory closedSessionFactory) {
                ConfigurationNode.this.clear();
            }

            public void queryPageCreated(QueryPage qp) {
            }
        });
        this.name = configuration.getName();
        this.iconName = "images/configuration.gif";
    }

    public ConsoleConfiguration getConsoleConfiguration() {
        return this.configuration;
    }

    protected void checkChildren() {
        if (!this.childrenCreated) {
            if (this.configuration.isSessionFactoryCreated()) {
                NodeFactory fac = new NodeFactory(this.configuration);
                this.children.add(fac.createConfigurationEntitiesNode("Mapped entities"));
                this.childrenCreated = true;
            } else {
                this.children.clear();
            }
        }
    }

    public String getHQL() {
        return null;
    }

    public void clear() {
        super.clear();
        this.childrenCreated = false;
    }
}

