/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.console.execution;

import java.net.URLClassLoader;
import java.util.Map;
import java.util.WeakHashMap;
import org.hibernate.console.execution.ExecutionContext;
import org.hibernate.eclipse.logging.CurrentContext;

public class DefaultExecutionContext
implements ExecutionContext {
    private final URLClassLoader configurationClassLoader;
    private volatile int installs;
    private Map previousLoaders = new WeakHashMap();
    final String key;

    public DefaultExecutionContext(String key, URLClassLoader loader) {
        this.configurationClassLoader = loader;
        this.key = key;
    }

    public void installLoader() {
        ++this.installs;
        if (this.configurationClassLoader != null && Thread.currentThread().getContextClassLoader() != this.configurationClassLoader) {
            this.previousLoaders.put(Thread.currentThread(), Thread.currentThread().getContextClassLoader());
            Thread.currentThread().setContextClassLoader(this.configurationClassLoader);
        }
    }

    public Object execute(ExecutionContext.Command c) {
        try {
            CurrentContext.push(this.key);
            this.installLoader();
            Object object = c.execute();
            return object;
        }
        finally {
            this.uninstallLoader();
            CurrentContext.pop();
        }
    }

    public void uninstallLoader() {
        --this.installs;
        if (this.installs == 0) {
            ClassLoader cl = (ClassLoader)this.previousLoaders.get(Thread.currentThread());
            if (this.configurationClassLoader != null && Thread.currentThread().getContextClassLoader() != this.configurationClassLoader) {
                throw new IllegalStateException("Existing classloader is not equal to the previously installed classloader! Existing=" + Thread.currentThread().getContextClassLoader() + " Previous=" + this.configurationClassLoader);
            }
            if (cl != null) {
                this.previousLoaders.remove(Thread.currentThread());
                Thread.currentThread().setContextClassLoader(cl);
            }
        }
    }
}

