/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.console;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Node;
import org.dom4j.io.DOMWriter;
import org.hibernate.HibernateException;
import org.hibernate.MappingException;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.cfg.Configuration;
import org.hibernate.cfg.NamingStrategy;
import org.hibernate.cfg.Settings;
import org.hibernate.console.ConsoleConfigurationListener;
import org.hibernate.console.FakeDelegatingDriver;
import org.hibernate.console.HQLQueryPage;
import org.hibernate.console.HibernateConsoleRuntimeException;
import org.hibernate.console.JavaPage;
import org.hibernate.console.QueryInputModel;
import org.hibernate.console.QueryPage;
import org.hibernate.console.execution.DefaultExecutionContext;
import org.hibernate.console.execution.ExecutionContext;
import org.hibernate.console.execution.ExecutionContextHolder;
import org.hibernate.console.preferences.ConsoleConfigurationPreferences;
import org.hibernate.util.ConfigHelper;
import org.hibernate.util.ReflectHelper;
import org.hibernate.util.StringHelper;
import org.hibernate.util.XMLHelper;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;

public class ConsoleConfiguration
implements ExecutionContextHolder {
    private ExecutionContext executionContext;
    private Map fakeDrivers = new HashMap();
    private Configuration configuration;
    private SessionFactory sessionFactory;
    public ConsoleConfigurationPreferences prefs = null;
    int execcount;
    List queryListeners = new ArrayList();
    List consoleCfgListeners = new ArrayList();

    public String getName() {
        return this.prefs.getName();
    }

    public ConsoleConfiguration(ConsoleConfigurationPreferences config) {
        this.prefs = config;
    }

    public Object execute(ExecutionContext.Command c) {
        return this.executionContext.execute(c);
    }

    public void reset() {
        this.configuration = null;
        this.closeSessionFactory();
    }

    public void build() {
        this.configuration = this.buildWith(null, true);
    }

    private Configuration buildJPAConfiguration(String persistenceUnit, Properties properties, String entityResolver, boolean includeMappings) {
        if (StringHelper.isEmpty((String)persistenceUnit)) {
            persistenceUnit = null;
        }
        try {
            HashMap<Object, Object> overrides = new HashMap<Object, Object>();
            if (properties != null) {
                overrides.putAll(properties);
            }
            if (StringHelper.isNotEmpty((String)this.prefs.getNamingStrategy())) {
                overrides.put("hibernate.ejb.naming_strategy", this.prefs.getNamingStrategy());
            }
            if (!includeMappings) {
                overrides.put("hibernate.archive.autodetection", "none");
            }
            Class clazz = ReflectHelper.classForName((String)"org.hibernate.ejb.Ejb3Configuration", ConsoleConfiguration.class);
            Object ejb3cfg = clazz.newInstance();
            if (StringHelper.isNotEmpty((String)entityResolver)) {
                Class resolver = ReflectHelper.classForName((String)entityResolver, this.getClass());
                Object object = resolver.newInstance();
                Method method = clazz.getMethod("setEntityResolver", EntityResolver.class);
                method.invoke(ejb3cfg, object);
            }
            Method method = clazz.getMethod("configure", String.class, Map.class);
            if (method.invoke(ejb3cfg, persistenceUnit, overrides) == null) {
                throw new HibernateConsoleRuntimeException("Persistence unit not found: '" + persistenceUnit + "'.");
            }
            method = clazz.getMethod("getHibernateConfiguration", new Class[0]);
            Configuration invoke = (Configuration)method.invoke(ejb3cfg, null);
            return invoke;
        }
        catch (Exception e) {
            throw new HibernateConsoleRuntimeException("Could not create JPA based Configuration", e);
        }
    }

    private Configuration buildAnnotationConfiguration() throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        Class clazz = ReflectHelper.classForName((String)"org.hibernate.cfg.AnnotationConfiguration");
        Configuration newInstance = (Configuration)clazz.newInstance();
        return newInstance;
    }

    public Configuration buildWith(final Configuration cfg, final boolean includeMappings) {
        URL[] customClassPathURLS = this.prefs.getCustomClassPathURLS();
        this.executionContext = new DefaultExecutionContext(this.getName(), new URLClassLoader(customClassPathURLS, this.getParentClassLoader()){

            protected Class findClass(String name) throws ClassNotFoundException {
                return super.findClass(name);
            }

            protected synchronized Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
                return super.loadClass(name, resolve);
            }

            public Class loadClass(String name) throws ClassNotFoundException {
                return super.loadClass(name);
            }
        });
        Configuration result = (Configuration)this.executionContext.execute(new ExecutionContext.Command(){

            public Object execute() {
                String str;
                Configuration localCfg = cfg;
                Properties properties = ConsoleConfiguration.this.prefs.getProperties();
                if (properties != null && (str = properties.getProperty("hibernate.transaction.manager_lookup_class")) != null && StringHelper.isEmpty((String)str)) {
                    properties.setProperty("hibernate.transaction.manager_lookup_class", "org.hibernate.console.FakeTransactionManagerLookup");
                }
                if (localCfg == null) {
                    localCfg = ConsoleConfiguration.this.buildConfiguration(properties, includeMappings);
                }
                ConsoleConfiguration.this.registerFakeDriver(localCfg.getProperty("hibernate.connection.driver_class"));
                if (includeMappings) {
                    File[] mappingFiles = ConsoleConfiguration.this.prefs.getMappingFiles();
                    int i = 0;
                    while (i < mappingFiles.length) {
                        File hbm = mappingFiles[i];
                        localCfg = localCfg.addFile(hbm);
                        ++i;
                    }
                }
                localCfg.setProperty("hibernate.temp.use_jdbc_metadata_defaults", "false");
                localCfg.setProperty("hibernate.hbm2ddl.auto", "false");
                return localCfg;
            }
        });
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Configuration loadConfigurationXML(Configuration localCfg, boolean includeMappings, EntityResolver entityResolver) {
        Configuration configuration;
        InputStream stream;
        File configXMLFile = this.prefs.getConfigXMLFile();
        if (includeMappings) {
            if (configXMLFile == null) return localCfg.configure();
            return localCfg.configure(configXMLFile);
        }
        XMLHelper xmlHelper = new XMLHelper();
        String resourceName = "<unknown>";
        try {
            if (configXMLFile != null) {
                resourceName = configXMLFile.toString();
                stream = new FileInputStream(configXMLFile);
            } else {
                resourceName = "/hibernate.cfg.xml";
                stream = ConfigHelper.getResourceAsStream((String)resourceName);
            }
        }
        catch (FileNotFoundException e1) {
            throw new HibernateConsoleRuntimeException("Could not access " + configXMLFile, e1);
        }
        try {
            ArrayList errors = new ArrayList();
            Document doc = xmlHelper.createSAXReader(resourceName, errors, entityResolver).read(new InputSource(stream));
            if (errors.size() != 0) {
                throw new MappingException("invalid configuration", (Throwable)errors.get(0));
            }
            List list = doc.getRootElement().element("session-factory").elements("mapping");
            Iterator iterator = list.iterator();
            while (true) {
                if (!iterator.hasNext()) {
                    DOMWriter dw = new DOMWriter();
                    org.w3c.dom.Document document = dw.write(doc);
                    configuration = localCfg.configure(document);
                    break;
                }
                Node element = (Node)iterator.next();
                element.getParent().remove(element);
            }
        }
        catch (DocumentException e) {
            try {
                throw new HibernateException("Could not parse configuration: " + resourceName, (Throwable)e);
            }
            catch (Throwable throwable) {
                try {
                    stream.close();
                    throw throwable;
                }
                catch (IOException iOException) {}
                throw throwable;
            }
        }
        try {
            stream.close();
            return configuration;
        }
        catch (IOException iOException) {}
        return configuration;
    }

    private void registerFakeDriver(String driverClassName) {
        if (driverClassName != null) {
            try {
                Class driverClass = ReflectHelper.classForName((String)driverClassName);
                if (!this.fakeDrivers.containsKey(driverClassName)) {
                    FakeDelegatingDriver fakeDelegatingDriver = new FakeDelegatingDriver((Driver)driverClass.newInstance());
                    DriverManager.registerDriver(fakeDelegatingDriver);
                    this.fakeDrivers.put(driverClassName, fakeDelegatingDriver);
                }
            }
            catch (ClassNotFoundException e) {
                throw new HibernateConsoleRuntimeException("Problems while loading database driverclass (" + driverClassName + ")", e);
            }
            catch (InstantiationException e) {
                throw new HibernateConsoleRuntimeException("Problems while loading database driverclass (" + driverClassName + ")", e);
            }
            catch (IllegalAccessException e) {
                throw new HibernateConsoleRuntimeException("Problems while loading database driverclass (" + driverClassName + ")", e);
            }
            catch (SQLException e) {
                throw new HibernateConsoleRuntimeException("Problems while loading database driverclass (" + driverClassName + ")", e);
            }
        }
    }

    protected ClassLoader getParentClassLoader() {
        return Thread.currentThread().getContextClassLoader();
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public boolean hasConfiguration() {
        return this.configuration != null;
    }

    public void buildSessionFactory() {
        this.execute(new ExecutionContext.Command(){

            public Object execute() {
                if (ConsoleConfiguration.this.sessionFactory != null) {
                    throw new HibernateConsoleRuntimeException("Factory were not closed before attempting to built a new factory.");
                }
                ConsoleConfiguration.this.sessionFactory = ConsoleConfiguration.this.getConfiguration().buildSessionFactory();
                ConsoleConfiguration.this.fireFactoryBuilt();
                return null;
            }
        });
    }

    public SessionFactory getSessionFactory() {
        return this.sessionFactory;
    }

    public QueryPage executeHQLQuery(String hql) {
        return this.executeHQLQuery(hql, new QueryInputModel());
    }

    public QueryPage executeHQLQuery(final String hql, final QueryInputModel queryParameters) {
        return (QueryPage)this.executionContext.execute(new ExecutionContext.Command(){

            public Object execute() {
                org.hibernate.classic.Session session = ConsoleConfiguration.this.getSessionFactory().openSession();
                HQLQueryPage qp = new HQLQueryPage(ConsoleConfiguration.this, hql, queryParameters);
                qp.setSession((Session)session);
                qp.setId(++ConsoleConfiguration.this.execcount);
                ConsoleConfiguration.this.fireQueryPageCreated(qp);
                return qp;
            }
        });
    }

    public QueryPage executeBSHQuery(final String queryString, final QueryInputModel model) {
        return (QueryPage)this.executionContext.execute(new ExecutionContext.Command(){

            public Object execute() {
                org.hibernate.classic.Session session = ConsoleConfiguration.this.getSessionFactory().openSession();
                JavaPage qp = new JavaPage(ConsoleConfiguration.this, queryString, model);
                qp.setSession((Session)session);
                qp.setId(++ConsoleConfiguration.this.execcount);
                ConsoleConfiguration.this.fireQueryPageCreated(qp);
                return qp;
            }
        });
    }

    private void fireQueryPageCreated(QueryPage qp) {
        for (ConsoleConfigurationListener view : this.consoleCfgListeners) {
            view.queryPageCreated(qp);
        }
    }

    private void fireFactoryBuilt() {
        for (ConsoleConfigurationListener view : this.consoleCfgListeners) {
            view.sessionFactoryBuilt(this, this.sessionFactory);
        }
    }

    private void fireFactoryClosing(SessionFactory sessionFactory2) {
        for (ConsoleConfigurationListener view : this.consoleCfgListeners) {
            view.sessionFactoryClosing(this, sessionFactory2);
        }
    }

    public void addConsoleConfigurationListener(ConsoleConfigurationListener v) {
        this.consoleCfgListeners.add(v);
    }

    public void removeConsoleConfigurationListener(ConsoleConfigurationListener sfListener) {
        this.consoleCfgListeners.remove(sfListener);
    }

    public ConsoleConfigurationListener[] getConsoleConfigurationListeners() {
        return this.consoleCfgListeners.toArray(new ConsoleConfigurationListener[this.consoleCfgListeners.size()]);
    }

    public boolean isSessionFactoryCreated() {
        return this.sessionFactory != null;
    }

    public ConsoleConfigurationPreferences getPreferences() {
        return this.prefs;
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + ":" + this.getName();
    }

    public ExecutionContext getExecutionContext() {
        return this.executionContext;
    }

    public void closeSessionFactory() {
        if (this.sessionFactory != null) {
            this.fireFactoryClosing(this.sessionFactory);
            this.sessionFactory.close();
            this.sessionFactory = null;
        }
    }

    public Settings getSettings(final Configuration cfg) {
        return (Settings)this.execute(new ExecutionContext.Command(){

            public Object execute() {
                return cfg.buildSettings();
            }
        });
    }

    private Configuration buildConfiguration(Properties properties, boolean includeMappings) {
        Configuration localCfg = null;
        if (this.prefs.getConfigurationMode().equals(ConsoleConfigurationPreferences.ConfigurationMode.ANNOTATIONS)) {
            try {
                localCfg = this.buildAnnotationConfiguration();
                localCfg = this.configureStandardConfiguration(includeMappings, localCfg, properties);
            }
            catch (Exception e) {
                throw new HibernateConsoleRuntimeException("Could not load AnnotationConfiguration", e);
            }
        } else if (this.prefs.getConfigurationMode().equals(ConsoleConfigurationPreferences.ConfigurationMode.JPA)) {
            try {
                localCfg = this.buildJPAConfiguration(this.getPreferences().getPersistenceUnitName(), properties, this.prefs.getEntityResolverName(), includeMappings);
            }
            catch (Exception e) {
                throw new HibernateConsoleRuntimeException("Could not load JPA Configuration", e);
            }
        } else {
            localCfg = new Configuration();
            localCfg = this.configureStandardConfiguration(includeMappings, localCfg, properties);
        }
        return localCfg;
    }

    private Configuration configureStandardConfiguration(boolean includeMappings, Configuration localCfg, Properties properties) {
        if (properties != null) {
            localCfg = localCfg.setProperties(properties);
        }
        EntityResolver entityResolver = XMLHelper.DEFAULT_DTD_RESOLVER;
        if (StringHelper.isNotEmpty((String)this.prefs.getEntityResolverName())) {
            try {
                entityResolver = (EntityResolver)ReflectHelper.classForName((String)this.prefs.getEntityResolverName()).newInstance();
            }
            catch (Exception c) {
                throw new HibernateConsoleRuntimeException("Could not configure entity resolver " + this.prefs.getEntityResolverName(), c);
            }
        }
        localCfg.setEntityResolver(entityResolver);
        if (StringHelper.isNotEmpty((String)this.prefs.getNamingStrategy())) {
            try {
                NamingStrategy ns = (NamingStrategy)ReflectHelper.classForName((String)this.prefs.getNamingStrategy()).newInstance();
                localCfg.setNamingStrategy(ns);
            }
            catch (Exception c) {
                throw new HibernateConsoleRuntimeException("Could not configure naming strategy " + this.prefs.getNamingStrategy(), c);
            }
        }
        localCfg = this.loadConfigurationXML(localCfg, includeMappings, entityResolver);
        return localCfg;
    }
}

