/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.eclipse.mapper.model;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.wst.sse.core.internal.provisional.INodeAdapter;
import org.eclipse.wst.sse.core.internal.provisional.INodeAdapterFactory;
import org.eclipse.wst.sse.core.internal.provisional.INodeNotifier;
import org.eclipse.wst.xml.core.internal.provisional.format.ElementNodeFormatter;
import org.jboss.deployment.DeploymentException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DOMModelUtil {
    private DOMModelUtil() {
    }

    public static Node getNextNamedSibling(Node node, String nodeName) {
        Node nextSibling = node.getNextSibling();
        while (nextSibling != null && !nextSibling.getNodeName().equals(nodeName)) {
            nextSibling = nextSibling.getNextSibling();
        }
        return nextSibling;
    }

    static Node getPreviousNamedSibling(Node node, String nodeName) {
        Node nextSibling = node.getPreviousSibling();
        while (nextSibling != null && !nextSibling.getNodeName().equals(nodeName)) {
            nextSibling = nextSibling.getPreviousSibling();
        }
        return nextSibling;
    }

    public static void addElementBefore(Node parentNode, Node element, Node before) {
        if (before == null) {
            parentNode.appendChild(element);
        } else {
            parentNode.insertBefore(element, before);
        }
        DOMModelUtil.formatNode(parentNode);
    }

    static void formatNode(Node node) {
        ElementNodeFormatter formatter = new ElementNodeFormatter();
        formatter.format(node);
    }

    public static boolean isWhiteSpace(Node node) {
        return node != null && node.getNodeType() == 3 && node.getNodeValue().trim().length() == 0;
    }

    public static List getAdaptedElements(Element n, String elementName, INodeAdapterFactory factory) {
        ArrayList<INodeAdapter> result = new ArrayList<INodeAdapter>();
        List list = DOMModelUtil.getChildrenByTagName(n, elementName);
        int i = 0;
        while (i < list.size()) {
            Node item = (Node)list.get(i);
            result.add(factory.adapt((INodeNotifier)item));
            ++i;
        }
        return result;
    }

    public static List getChildrenByTagName(Node element, String tagName) {
        if (element == null) {
            return null;
        }
        NodeList children = element.getChildNodes();
        ArrayList<Node> goodChildren = new ArrayList<Node>();
        int i = 0;
        while (i < children.getLength()) {
            Node currentChild = children.item(i);
            if (currentChild.getNodeType() == 1 && ((Element)currentChild).getTagName().equals(tagName)) {
                goodChildren.add(currentChild);
            }
            ++i;
        }
        return goodChildren;
    }

    public static Element getOptionalChild(Element element, String tagName) throws DeploymentException {
        List goodChildren = DOMModelUtil.getChildrenByTagName(element, tagName);
        if (goodChildren.size() == 1) {
            return (Element)goodChildren.get(0);
        }
        return null;
    }
}

