/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.eclipse.mapper.extractor;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jface.text.contentassist.CompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.hibernate.eclipse.mapper.extractor.HBMInfoExtractor;
import org.hibernate.eclipse.mapper.extractor.HBMInfoHandler;
import org.hibernate.eclipse.mapper.extractor.HibernateTypeDescriptor;
import org.w3c.dom.Attr;
import org.w3c.dom.Node;

public class HibernateTypeHandler
implements HBMInfoHandler {
    private final HBMInfoExtractor extractor;

    public HibernateTypeHandler(HBMInfoExtractor extractor) {
        this.extractor = extractor;
    }

    public ICompletionProposal[] attributeCompletionProposals(IJavaProject project, Node node, String attributeName, String start, int offset) {
        List types = this.extractor.findMatchingHibernateTypes(start);
        ArrayList<CompletionProposal> proposals = new ArrayList<CompletionProposal>(types.size());
        for (HibernateTypeDescriptor element : types) {
            String extendedinfo = "<b>Hibernate type</b>: " + element.getName();
            if (element.getReturnClass() != null) {
                extendedinfo = String.valueOf(extendedinfo) + "<br><b>Return class</b>: " + element.getReturnClass();
            }
            if (element.getPrimitiveClass() != null) {
                extendedinfo = String.valueOf(extendedinfo) + "<br><b>Return primitive</b>: " + element.getPrimitiveClass();
            }
            proposals.add(new CompletionProposal(element.getName(), offset, start.length(), element.getName().length(), null, null, null, extendedinfo));
        }
        try {
            IType[] classes;
            ITypeHierarchy hier;
            IType typeInterface = project.findType("org.hibernate.usertype.CompositeUserType");
            HashSet alreadyFound = new HashSet();
            if (typeInterface != null) {
                hier = typeInterface.newTypeHierarchy(project, (IProgressMonitor)new NullProgressMonitor());
                classes = hier.getAllSubtypes(typeInterface);
                this.extractor.generateTypeProposals(start, offset, proposals, alreadyFound, classes, null);
            }
            if ((typeInterface = project.findType("org.hibernate.usertype.UserType")) != null) {
                hier = typeInterface.newTypeHierarchy(project, (IProgressMonitor)new NullProgressMonitor());
                classes = hier.getAllSubtypes(typeInterface);
                this.extractor.generateTypeProposals(start, offset, proposals, alreadyFound, classes, null);
            }
        }
        catch (CoreException e) {
            throw new RuntimeException(e);
        }
        ICompletionProposal[] result = proposals.toArray(new ICompletionProposal[proposals.size()]);
        return result;
    }

    public IJavaElement getJavaElement(IJavaProject project, Node currentNode, Attr currentAttrNode) {
        return this.extractor.getNearestTypeJavaElement(project, currentNode);
    }
}

