/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.eclipse.mapper.editors.reveng;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.hibernate.console.ConsoleConfiguration;
import org.hibernate.console.KnownConfigurations;
import org.hibernate.eclipse.console.model.IReverseEngineeringDefinition;
import org.hibernate.eclipse.mapper.MapperPlugin;
import org.hibernate.eclipse.mapper.editors.ReverseEngineeringEditor;
import org.hibernate.eclipse.mapper.editors.reveng.RevEngSectionPart;
import org.hibernate.util.StringHelper;

public class ConsoleConfigNamePart
extends RevEngSectionPart {
    private CCombo text;
    private ReverseEngineeringEditor re;

    public ConsoleConfigNamePart(Composite parent, IManagedForm form, ReverseEngineeringEditor re) {
        super(parent, form);
        this.re = re;
    }

    public boolean setFormInput(IReverseEngineeringDefinition def) {
        if (StringHelper.isEmpty((String)this.text.getText())) {
            String initialConfg = "";
            try {
                if (this.re.getHibernateNature() != null) {
                    initialConfg = this.re.getHibernateNature().getDefaultConsoleConfigurationName();
                }
            }
            catch (CoreException e) {
                MapperPlugin.getDefault().getLogger().logException("Problem when trying to Hibernate Project information", (Throwable)e);
            }
            this.text.setText(initialConfg);
        }
        return false;
    }

    public void dispose() {
    }

    Control createClient(IManagedForm form) {
        FormToolkit toolkit = form.getToolkit();
        Composite composite = toolkit.createComposite((Composite)this.getSection());
        composite.setLayout((Layout)new GridLayout());
        this.text = new CCombo(composite, 0x800000);
        this.text.setEditable(false);
        this.adaptRecursively(toolkit, (Composite)this.text);
        ConsoleConfiguration[] cfg = KnownConfigurations.getInstance().getConfigurationsSortedByName();
        String[] names = new String[cfg.length];
        int i = 0;
        while (i < cfg.length) {
            ConsoleConfiguration configuration = cfg[i];
            names[i] = configuration.getName();
            ++i;
        }
        this.text.setItems(names);
        return composite;
    }

    protected String getSectionDescription() {
        return "Select Console configuration to be used for editing the reverse engineering settings";
    }

    protected String getSectionTitle() {
        return "Console Configuration";
    }

    String getConsoleConfigName() {
        return this.text.getText();
    }

    public void setConsoleConfigName(String name) {
        this.text.setText(name);
    }
}

